/** @file
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
*/
/**
 * @brief this file contains the USB descriptors used
 * in the enumeration process to identify the IXP425
 * as an USB RNDIS device
 */

PUBLIC UCHAR ixUSBRNDISDeviceDescriptor[] = 
{
  18,			              /* Descriptor length */
  USB_DEVICE_DESCRIPTOR,	  /* Device descriptor */
  0x10,		            	  /* USB 1.1 (LSB) */
  1,			              /* USB 1.1 (MSB) */
  USB_COMMUCATION_DEVICE,     /* Device class */
  0x00,			              /* No subclass */
  0x00,			              /* No protocol */
  CONTROL_PACKET_SIZE,        /* Max packet size EP0 */
  0x86,			              /* Vendor ID (LSB) (Intel VID 0x8086) */
  0x80,			              /* Vendor ID (MSB) */
  0x01,			              /* Product ID (LSB) (1) */
  0x00,			              /* Product ID (MSB) */
  1,			              /* Device BCD (LSB) */
  0,			              /* Device BCD (MSB) */
  1,			              /* Index of Manufacturer string */
  2,			              /* Index of Product string */
  3,			              /* Index of Serial number string */
  1		                      /* Number of configurations */
};

PUBLIC UCHAR ixUSBRNDISConfigurationDescriptor[] = 
{
  9,			                /* Descriptor length */
  USB_CONFIGURATION_DESCRIPTOR, /* Configuration descriptor */
  67,	                        /* Total len (LSB) */
  0,			                /* Total len (MSB) */
  2,			                /* Number of interfaces (Communication and Data Interfaces)*/
  1,			                /* Configuration value */
  4,			                /* Configuration string index */
  0xC0,			                /* Attributes (self-powered) */
  125,			                /* Max Power */

  /* Communication Class Interface Descriptor */

  9,			                /* Descriptor length  */
  USB_INTERFACE_DESCRIPTOR,     /* Interface descriptor */
  0,			                /* Number of interface */
  0,			                /* Alternate setting */
  1,			                /* Number of endpoints */
  USB_COMMUNICATION_INTERFACE,	/* Interface class  */
  USB_ABSTRACT_CONTROL_MODEL,   /* Interface sub class */
  USB_VENDOR_SPECIFIC_PROTOCOL, /* Interface protocol (vendor specific) */
  0,			                /* Interface string descriptor */

  /* Header Functional Descriptor */

  5,                            /* Descriptor length */
  0x24,                         /* Descriptor type (functional interface) */
  0x00,                         /* Descriptor subtype (header functional) */
  0x10,                         /* CDC Revision 1.1 (LSB) */
  0x01,                         /* CDC Revision 1.1 (MSB) */

  /* Call Management Functional Descriptor */

  5,                            /* Descriptor length */
  0x24,                         /* Descriptor type (functional interface) */
  0x01,                         /* Descriptor subtype (call management) */
  0x00,                         /* No capabilities */
  0x00,                         /* No data interface */

  /* Abstract Control Management Descriptor */

  4,                            /* Descriptor length */
  0x24,                         /* Descriptor type (functional interface) */
  0x02,                         /* Subtype (Abstract Control Management) */
  0x00,                         /* No capabilities */

  /* Union Functional Descriptor */

  5,                            /* Descriptor length */
  0x24,                         /* Descriptor type (functional interface) */
  0x06,                         /* Descriptor subtype (union) */
  0x00,                         /* Master interface (communication interface) */
  0x01,                         /* Slave interface (data interface) */

  /* Notification Endpoint Descriptor */

  7,			                /* Descriptor length */
  USB_ENDPOINT_DESCRIPTOR,      /* Endpoint descriptor */
  0x85,			                /* Endpoint address 5 (IN) */
  USB_INTERRUPT_ENDPOINT,       /* Interrupt transfer  */
  INTERRUPT_FIFO_SIZE,          /* Max packet size LSB */
  0,			                /* Max packet size MSB */
  1, 			                /* Polling interval */

  /* Data Class Interface Descriptor */

  9,			                /* Descriptor length  */
  USB_INTERFACE_DESCRIPTOR,     /* Interface descriptor */
  1,			                /* Number of interface */
  0,			                /* Alternate setting */
  2,			                /* Number of endpoints */
  USB_DATA_INTERFACE,           /* Interface class  */
  0x00,			                /* Interface sub class (unused) */
  0x00,			                /* Interface protocol (unused) */
  0,			                /* Interface string descriptor */

  /* Data IN Endpoint Descriptor */

  7,			                /* Descriptor length */
  USB_ENDPOINT_DESCRIPTOR,      /* Endpoint descriptor */
  0x81,			                /* Endpoint address 1 (IN) */
  USB_BULK_ENDPOINT,            /* Bulk transfer  */
  BULK_FIFO_SIZE,               /* Max packet size LSB */
  0,			                /* Max packet size MSB */
  0,			                /* Polling interval */

  /* Data OUT Endpoint Descriptor */

  7,			                /* Descriptor length */
  USB_ENDPOINT_DESCRIPTOR,      /* Endpoint descriptor */
  0x02,			                /* Endpoint address 2 (OUT) */
  USB_BULK_ENDPOINT,            /* Bulk transfer  */
  BULK_FIFO_SIZE,               /* Max packet size LSB */
  0,			                /* Max packet size MSB */
  0		                        /* Polling interval */
};

/* string descriptor 0 (supported languages) */
PUBLIC UCHAR ixUSBRNDISLangIdDescriptor[] =
{
    4,                              /* Descriptor length */
    USB_STRING_DESCRIPTOR,          /* String descriptor */
    USB_ENGLISH_LANGUAGE && 0xFF,   /* LangId 1 LSB */
    USB_ENGLISH_LANGUAGE >> 8       /* LangId 1 MSB */
};

/* Unicode string descriptor 1 (manufacturer) */
PUBLIC UCHAR ixUSBRNDISManufacturerStringDescriptor[] =
{
    12,
    USB_STRING_DESCRIPTOR,
    'I', 0,
    'n', 0,
    't', 0,
    'e', 0,
    'l', 0
};

/* Unicode string descriptor 2 (product) */
PUBLIC UCHAR ixUSBRNDISProductStringDescriptor[] =
{
    14,
    USB_STRING_DESCRIPTOR,
    'I', 0,
    'X', 0,
    'P', 0,
    '4', 0,
    '2', 0,
    '5', 0
};

/* Unicode string descriptor 3 (serial number) */
PUBLIC UCHAR ixUSBRNDISSerialNumberStringDescriptor[] =
{
    4,
    USB_STRING_DESCRIPTOR,
    '1', 0
};

/* Unicode string descriptor 4 (configuration description) */
PUBLIC UCHAR ixUSBRNDISConfigurationStringDescriptor[] = 
{
    68,
    USB_STRING_DESCRIPTOR,
    'I', 0,
    'n', 0,
    't', 0,
    'e', 0,
    'l', 0,
    ' ', 0,
    'I', 0,
    'X', 0,
    'P', 0,
    '4', 0,
    '2', 0,
    '5', 0,
    ' ', 0,
    'D', 0,
    'e', 0,
    'v', 0,
    'e', 0,
    'l', 0,
    'o', 0,
    'p', 0,
    'm', 0,
    'e', 0,
    'n', 0,
    't', 0,
    ' ', 0,
    'P', 0,
    'l', 0,
    'a', 0,
    't', 0,
    'f', 0,
    'o', 0,
    'r', 0,
    'm', 0
};
