#include <stdlib.h>

#include "gets_alloc.h"

/* Use a static pointer to an allocated buffer for mygets(). 
 * If we ever run out of space, we realloc() it bigger
 */
static char *gets_buf = 0;
static int gets_buflen = 0;

void gets_alloc_done(void)
{
	if (gets_buf) {
		free(gets_buf);
		gets_buf = 0;
		gets_buflen = 0;
	}
}

char *gets_alloc(FILE *f)
{
	int c;
	int bpos = 0;

	while ((c = getc(f)) != EOF) {
		if (bpos >= gets_buflen) {
			gets_buflen += BUFSIZ;
			gets_buf = realloc(gets_buf, gets_buflen + 1);
		}
		gets_buf[bpos] = c;
		if (c == '\n') {
			gets_buf[bpos] = '\0';
			return(gets_buf);
		}
		bpos++;
	}

	if (bpos == 0 || ferror(f)) {
		// Reached end of file with no more data
		gets_alloc_done();
		return(0);
	}
	
	gets_buf[bpos++] = '\0';
	return(gets_buf);
}
