#ifndef _MICROBLAZE_PGALLOC_H
#define _MICROBLAZE_PGALLOC_H

/*
 * Copyright (C) 2000 Lineo, David McCullough <davidm@lineo.com>
 * Copyright (C) 2001 Lineo, Greg Ungerer <gerg@snapgear.com>
 */

#include <asm/setup.h>
#include <asm/virtconvert.h>

/*
 * Cache handling functions
 */

extern inline void __flush_cache_all(void)
{
#ifdef CONFIG_MICROBLAZE_ICACHE
	unsigned int i;
	unsigned int flags;

	save_flags(flags);cli();
	__disable_icache();
	__disable_dcache();

	for(i=0;i<0x8000;i+=4)
	{
		__invalidate_icache(i+0x80000000);
		__invalidate_dcache(i+0x80000000);
	}
	__enable_icache();
	__enable_dcache();
	restore_flags(flags);
#endif /* CONFIG_MICROBLAZE_ICACHE */
}

#define flush_cache_all()			__flush_cache_all()
#define flush_cache_mm(mm)			__flush_cache_all()
#define flush_cache_range(mm, start, end)	__flush_cache_all()
#define flush_cache_page(vma, vmaddr)		__flush_cache_all()
#define flush_page_to_ram(page)			__flush_cache_all()
#define flush_dcache_page(page)			__flush_cache_all()
#define flush_icache_range(start, end)		__flush_cache_all()
#define flush_icache_user_range(vma,pg,adr,len) __flush_cache_all()
#define flush_icache_page(vma,pg)		__flush_cache_all()
#define flush_icache()				__flush_cache_all()
#define flush_cache_sigtramp(vaddr)		__flush_cache_all()

/*
 * DAVIDM - the rest of these are just so I can check where they happen
 */

/*
 * flush all user-space atc entries.
 */
static inline void __flush_tlb(void)
{
	BUG();
}

static inline void __flush_tlb_one(unsigned long addr)
{
	BUG();
}

#define flush_tlb() __flush_tlb()

/*
 * flush all atc entries (both kernel and user-space entries).
 */
static inline void flush_tlb_all(void)
{
	BUG();
}

static inline void flush_tlb_mm(struct mm_struct *mm)
{
	BUG();
}

static inline void flush_tlb_page(struct vm_area_struct *vma, unsigned long addr)
{
	BUG();
}

static inline void flush_tlb_range(struct mm_struct *mm,
				   unsigned long start, unsigned long end)
{
	BUG();
}

extern inline void flush_tlb_kernel_page(unsigned long addr)
{
	BUG();
}

extern inline void flush_tlb_pgtables(struct mm_struct *mm,
				      unsigned long start, unsigned long end)
{
	BUG();
}

#endif /* _MICROBLAZE_PGALLOC_H */
