/* FreeS/WAN NAT-Traversal
 * Copyright (C) 2002 Mathieu Lafon - Arkoon Network Security
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: nat_traversal.h,v 1.2 2002/09/19 00:08:54 damion Exp $
 */

#ifndef _NAT_TRAVERSAL_H_
#define _NAT_TRAVERSAL_H_

/* Comment if you have problems with NAT-T floating ports */
#define NAT_T_SUPPORT_LAST_DRAFTS

#define NAT_TRAVERSAL_IETF_00_01     1
#define NAT_TRAVERSAL_IETF_02_03     2

#define NAT_TRAVERSAL_NAT_BHND_ME    30
#define NAT_TRAVERSAL_NAT_BHND_PEER  31

#define NAT_TRAVERSAL_METHOD  (0xffffffff - LELEM(30) - LELEM(31))

/**
 * NAT-Traversal methods that needs NAT-D
 */
#define NAT_T_WITH_NATD \
	( LELEM(NAT_TRAVERSAL_IETF_00_01) | LELEM(NAT_TRAVERSAL_IETF_02_03) )
/**
 * NAT-Traversal methods that needs NAT-OA
 */
#define NAT_T_WITH_NATOA \
	( LELEM(NAT_TRAVERSAL_IETF_00_01) | LELEM(NAT_TRAVERSAL_IETF_02_03) )
/**
 * NAT-Traversal methods that uses NAT-KeepAlive
 */
#define NAT_T_WITH_KA \
	( LELEM(NAT_TRAVERSAL_IETF_00_01) | LELEM(NAT_TRAVERSAL_IETF_02_03) )
/**
 * NAT-Traversal methods that uses floating port
 */
#define NAT_T_WITH_FLOATING_PORT \
	( LELEM(NAT_TRAVERSAL_IETF_02_03) )

/**
 * NAT-Traversal detected
 */
#define NAT_T_DETECTED \
	( LELEM(NAT_TRAVERSAL_NAT_BHND_ME) | LELEM(NAT_TRAVERSAL_NAT_BHND_PEER) )

#define NAT_T_IKE_FLOAT_PORT     4500
#ifdef NAT_T_SUPPORT_LAST_DRAFTS
#define NAT_TRAVERSAL_FLOATED_PORT
#endif /* NAT_T_LAST_DRAFTS */

void init_nat_traversal (bool activate, unsigned int keep_alive_period);

/**
 * NAT-D
 */
void nat_traversal_natd_lookup(struct msg_digest *md);
bool nat_traversal_add_natd(u_int8_t np, pb_stream *outs,
	struct msg_digest *md);

/**
 * NAT-OA
 */
void nat_traversal_natoa_lookup(struct msg_digest *md);
bool nat_traversal_add_natoa(u_int8_t np, pb_stream *outs,
	struct state *st);

/**
 * NAT-keep_alive
 */
void nat_traversal_new_ka_event (void);
void nat_traversal_ka_event (void);

bool nat_traversal_activated(void);

void nat_traversal_show_result (u_int32_t nt);

int nat_traversal_espinudp_socket (int sk, u_int32_t type);

bool nat_traversal_add_vid(u_int8_t np, pb_stream *outs);

/**
 * New NAT mapping
 */
#ifdef __PFKEY_V2_H
void process_pfkey_nat_t_new_mapping(
	struct sadb_msg *,
	struct sadb_ext *[SADB_EXT_MAX + 1]);
#endif
void nat_traversal_new_mapping(struct state *st, ip_address *ip,
	u_int16_t port);

/**
 * IKE port floating
 */
bool
nat_traversal_port_float(struct state *st, struct msg_digest *md, bool in);

#endif /* _NAT_TRAVERSAL_H_ */

