/*
 * smart_daemon.c
 *
 * Copyright (C) 2000 Michael Cornwell <cornwell@acm.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * You should have received a copy of the GNU General Public License
 * (for example COPYING); if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <math.h>
#include <syslog.h>
#include <linux/hdreg.h>
#include "smart_all.h"
#include "smart.h"
#include "LOG_log.h"
//#include "UTL_SetLED.h"
#include "PRO_file.h"

static char SmartMsg[1][128]={{0}};
static char disk1[1][128]={{0}},disk2[1][128]={{0}};
int numatadevices=0;
int doonce=0;
#define DiskStatusFile	"/etc/disk.status"
#define	StatusSec		"status"

int read_index_smart_msg(int index)
{
	int ret=0;
	char tmp[1][128]={{0}};
		
	ret=PRO_GetMsgByIndex(SMART_ERR,index,1,tmp,ERRMSG_FILE);
	if(ret<0){	
		strcpy(SmartMsg[0],"S.M.A.R.T.: Fail to get status message.");
		return ret;		
	}
	sprintf(SmartMsg[0],"S.M.A.R.T.: %s",tmp[0]);
	return 0;
}


int atadevicescan ( atadevices_t *devices,char *device)
{
	int fd;
	struct hd_driveid drive;	
	char SmartShowMsg[128]={0};

		fd = 0;
		fd = open ( device , O_RDWR );

		if ( fd >= 0)
		{
	
			if (  ataReadHDIdentity ( fd, &drive) == 0 ) 
			{

				if ( ataSmartSupport (drive)>0) 
				{
					
					if (ataEnableSmart(fd)==0)
					{
		
						devices[numatadevices].fd = fd;
						strcpy((char *) &devices[numatadevices].devicename,(char*) &device);
						devices[numatadevices].drive = drive;

						if ( ataReadSmartValues ( fd, &devices[numatadevices].smartval) != 0 )
						{
							read_index_smart_msg(SMART_VALUE_READ_ERR);
							LOG_LogMsg ("SMART",LOG_LEVEL_2,SmartMsg[0]);
							return -3;
						}

						if ( ataReadSmartThresholds ( fd, &devices[numatadevices].smartthres) != 0 )
						{
							read_index_smart_msg(SMART_TH_READ_ERR);
							if(!strcmp(device,FSH_DEV_HD1))
								sprintf(SmartShowMsg,SmartMsg[0],disk1[0]);
							else if(!strcmp(device,FSH_DEV_HD2))
								sprintf(SmartShowMsg,SmartMsg[0],disk2[0]);
							else
								strncpy(SmartShowMsg,SmartMsg[0],sizeof(SmartShowMsg));
							LOG_LogMsg ("SMART",LOG_LEVEL_2,SmartShowMsg);
							return -4;
						}
						
						devices[numatadevices].selftest = isSupportSelfTest(devices[numatadevices].smartval);
						numatadevices++;

					}
				}
			}
		}

	if(numatadevices==0)
	{
		read_index_smart_msg(NO_DEVICE_ERR);
		LOG_LogMsg ("SMART",LOG_LEVEL_2,SmartMsg[0]);
		return -5;
	}
	return 0;
	
}

int ataCompareSmartValues ( atadevices_t *device, struct ata_smart_values b )
{
	int i;
	for ( i =0; i < NUMBER_ATA_SMART_ATTRIBUTES; i++)
	{
		if( device->smartval.vendor_attributes[i].id & b.vendor_attributes[i].id &
			(device->smartval.vendor_attributes[i].normalized != b.vendor_attributes[i].normalized))
			return -1;
	}
	return 0;
}

int ataCheckDevice( atadevices_t *drive)
{
	struct ata_smart_values tempsmartval;
	struct ata_smart_thresholds tempsmartthres;
	int i_return;
	
	i_return=ataReadSmartValues ( drive->fd, &tempsmartval);
	if (  i_return!= 0 )
		return -1;

	
	i_return=ataReadSmartThresholds ( drive->fd, &tempsmartthres);	
	if ( i_return != 0 )
		return -2;
	
	i_return=ataCheckSmart( tempsmartval, tempsmartthres);				
	if (i_return != 0)
		return -3;
	
	i_return=ataCompareSmartValues (drive , tempsmartval);	
	if (i_return != 0)
		return -4;
		
	/* Copy the values back to the structure */
	drive->smartval = tempsmartval;
	drive->smartthres = tempsmartthres;
			
	return 0;
}

int CheckDevices (  atadevices_t *atadevices, int checktime)
{
	int i;
	int i_return=0;
	char SmartShowMsg[128]={0};
	
	while (1)
	{
		for (i = 0; i < numatadevices;i++)
		{
			i_return=ataCheckDevice (  &atadevices[i]);
			if(i_return==0)
				continue;
			switch (i_return)
			{
			case -1:
				read_index_smart_msg(SMART_VALUE_READ_ERR);
				break;
			case -2:
				read_index_smart_msg(SMART_TH_READ_ERR);
				if(!strcmp(atadevices[i].devicename,FSH_DEV_HD1))
					sprintf(SmartShowMsg,SmartMsg[0],disk1[0]);
				else if(!strcmp(atadevices[i].devicename,FSH_DEV_HD2))
					sprintf(SmartShowMsg,SmartMsg[0],disk2[0]);
				else
					strncpy(SmartShowMsg,SmartMsg[0],sizeof(SmartShowMsg));
				strncpy(SmartMsg[0],SmartShowMsg,sizeof(SmartShowMsg));
				break;
			case -3:
				read_index_smart_msg(SMART_ATTR_ERR);
				if(!strcmp(atadevices[i].devicename,FSH_DEV_HD1))
					sprintf(SmartShowMsg,SmartMsg[0],disk1[0]);
				else if(!strcmp(atadevices[i].devicename,FSH_DEV_HD2))
					sprintf(SmartShowMsg,SmartMsg[0],disk2[0]);
				else
					strncpy(SmartShowMsg,SmartMsg[0],sizeof(SmartShowMsg));
				strncpy(SmartMsg[0],SmartShowMsg,sizeof(SmartShowMsg));
				break;
			case -4:
				read_index_smart_msg(SMART_ATTR_CH);
				if(!strcmp(atadevices[i].devicename,FSH_DEV_HD1))
					sprintf(SmartShowMsg,SmartMsg[0],disk1[0]);
				else if(!strcmp(atadevices[i].devicename,FSH_DEV_HD2))
					sprintf(SmartShowMsg,SmartMsg[0],disk2[0]);
				else
					strncpy(SmartShowMsg,SmartMsg[0],sizeof(SmartShowMsg));
				strncpy(SmartMsg[0],SmartShowMsg,sizeof(SmartShowMsg));
				break;
			}
			LOG_LogMsg ("SMART",LOG_LEVEL_2,SmartMsg[0]);
			return (i_return-5);
			
		}
		if(doonce==1)
		{
			if(i_return==0)
				return 0;
		}	
		sleep ( checktime );
	}
}


/*********start smart daemon function ***********/
/**return val:0,ok;-1,input error;-2,failed to start;-3,has been started******/
int StartSmartDaemon(int interval,char *device)
{
	FILE *fp;
	pid_t pid;
	atadevices_t atadevices[MAXATADEVICES], *atadevicesptr;
	int i_return,status;
	char 	SmartShowMsg[128]={0},item[16];
	atadevicesptr = atadevices;

	PRO_GetMsgByIndex(DISK_NAME,FIRST,1,disk1,ERRMSG_FILE);
	if(!disk1[0][0])
		strcpy(disk1[0],"Disk 1");	
	PRO_GetMsgByIndex(DISK_NAME,SECOND,1,disk2,ERRMSG_FILE);
	if(!disk2[0][0])
		strcpy(disk2[0],"Disk 2");		
	if(interval<0)
		return -1;
	
	if(interval==0)
		doonce=1;
	if(!doonce&&access(SMART_PID,F_OK)!=-1)
		return -1;
	if(strstr(device,FSH_DEV_HD1))
		strcpy(item,"smart_1");
	else
		strcpy(item,"smart_2");
	if ( (pid = fork()) < 0)
		return -2;
	else if (pid > 0){
		waitpid(pid,&status,0);
		return status;
	}
	else if(pid==0){
		setsid ();
		chdir("/");
		umask(0);
		PRO_SetInt(StatusSec,item,1,DiskStatusFile);
//		act_setled(CMD_CHECKHD,LEDSTATUS_EINVALID);	
		if(interval>0){
			fp=fopen(SMART_PID,"wt");
			fprintf(fp,"%d",(int)getpid());	
			fclose(fp);
		}
		if(doonce!=1){	
			read_index_smart_msg(SMART_RUNNING);
	   		LOG_LogMsg ("SMART",LOG_LEVEL_3,SmartMsg[0]);
		}
		i_return=atadevicescan (atadevicesptr,device);
		if(i_return!=0){
			if(doonce!=1)
	   			remove(SMART_PID);
//	   		act_setled(CMD_NOCHECKHD,LEDSTATUS_EINVALID);
			PRO_SetInt(StatusSec,item,3,DiskStatusFile);	   		
	   		return i_return;
		}
		i_return=CheckDevices ( atadevicesptr, interval);
		if(doonce==1&&i_return==0){
			read_index_smart_msg(SMART_OK);
			if(strstr(device,FSH_DEV_HD1))
				sprintf(SmartShowMsg,SmartMsg[0],disk1[0]);
			else if(strstr(device,FSH_DEV_HD2))
				sprintf(SmartShowMsg,SmartMsg[0],disk2[0]);
			else
				strncpy(SmartShowMsg,SmartMsg[0],sizeof(SmartShowMsg));
			LOG_LogMsg ("SMART",LOG_LEVEL_3,SmartShowMsg);
//			act_setled(CMD_NOCHECKHD,LEDSTATUS_EINVALID);
			PRO_SetInt(StatusSec,item,2,DiskStatusFile);	   		
			return 0;
		}
		else if(doonce==1&&i_return<0)  {
//				act_setled(CMD_NOCHECKHD,LEDSTATUS_EINVALID);	
				PRO_SetInt(StatusSec,item,3,DiskStatusFile);	   		
				return i_return;
		}
		if(doonce!=1)
	   		remove(SMART_PID);
	}
//	act_setled(CMD_NOCHECKHD,LEDSTATUS_EINVALID);
	PRO_SetInt(StatusSec,item,2,DiskStatusFile);	   		
	return 0;				
}

/*********stop smartdaemon function ***********/

int StopSmartDaemon()
{
	FILE *fp;
	char buf[128];
	int pid;
	
	if(access(SMART_PID,F_OK)==-1)
		return -1;	
	fp=fopen(SMART_PID,"rt");
	if(!fp)
		return -1;
	fscanf(fp,"%d",&pid);
	fclose(fp);
	if(pid==0)
		return -1;
	sprintf(buf,"/bin/kill -9 %d &>/dev/null",pid);	
	system(buf);
	read_index_smart_msg(SMART_TERMATED);
	LOG_LogMsg ("SMART",LOG_LEVEL_3,SmartMsg[0]);
//	act_setled(CMD_NOCHECKHD,LEDSTATUS_EINVALID);
	return 0;
}
