#ifndef _PRINTER_H_
#define _PRINTER_H_

#define		MAIL_ADDRESS_LEN	49
#define		MAIL_SUBJECT_LEN	49
#define 		MAX_PRINT_NAME_LEN	12
#define 		MAX_IP_ADDRESS_LEN	15
#define		MAX_PRINT_PORT_LEN	12

#define 		PRN_LASWER_WRITER	1
#define 		PRN_OTHER		2

#ifdef _LPR_
#define 	PRN_REDIRECT_YES	"yes"
#define 	PRN_REDIRECT_NO		"no"
#endif

#define 	PRN_ERR_OPERATION		1
#define 	PRN_OK					0
#define 	PRN_ERR_INPUT			-1
#define 	PRN_ERR_NO_JOB			-2	// No print jobs
#define 	PRN_ERR_NO_PRINTER	-3	// No printer attached
#define 	PRN_ERR_READ			-4
#define		U_AVAILABLE			-5
#define		PRN_Fport			-6
#define		PRN_Fseek			-7
#define 	Out_Of_Paper			-8
#define		PRN_Fdir				-9
#define		READDFCONFERR			-10
#define		RESTARTSMBERR			-11
typedef struct sys_print {
    char prn_name[MAX_PRINT_NAME_LEN + 1];	// printer name
#ifdef _LPR_
    char lpr_redirect[8];	//Printer redirect, yes: Enable  no: disable
    char lpr_ip[MAX_IP_ADDRESS_LEN + 1];	// Redirected printer IP address.
    char lpr_port[MAX_PRINT_PORT_LEN + 1];	// Redirect to the new printer's name
#endif
    int mac_client;		//1: LaserWriter or compatible   2: Other (correct printer on Mac)
    char mac_prn_type[MAX_PRINT_NAME_LEN + 1];	// MAC Printer type
} sys_print;			//system printer structure


#define Printcap "/etc/printcap"
#define PrintcapTmp "/etc/printcap.tmp"

/**************************************************/
//      NOTE:This function will read system       //
//      printer information from config files.    //
//      input:  NONE                              //
//      output: p       point to the structure    //    
//      return: 0       success                   //
//              1       failure                   //
/**************************************************/
int PRN_Read(sys_print * p);

/**************************************************/
//      NOTE:This function will save system       //
//      printer information to config files.      //
//      input:  p       system printer information//
//                      saved here.               //
//              m       point to messages.        //    
//      output: NONE                              //    
//      return: 0       success                   //
//                              1       failure                   //
/**************************************************/
int PRN_Save(sys_print p);

/**************************************************/
//      NOTE:This function will change the server //
//      printer setting according to config files.//
//      input:  NONE                              //
//      output: NONE                              //    
//      return: 0       success                   //
//                              1       failure                   //
/**************************************************/
int PRN_Restart(void);

int PRN_Stop(void);

int DeleteAllJobs(void);

int DeleteCurrentJob(void);
/********************************************************/
//   Get the following printer status                   //
//      1.      On-line/off-line                        //
//      2.      Paper end                               //
//      3.      busy                                    //
//      4.      wait                                    //
//      5.      How many jobs are queued                //
//Status        output  the status of printer           //
//                      0 - off-line                    //
//                      1 - on-line                     //
//                      2 - paper end                   //
//       Num    output  the number of jobs are queued   //
/********************************************************/
int GetPrinterStatus(int *status, int *num);
void ResetIPP(void);
int recover_printcap(void);
#endif
