/** 
 * @file IxUSBRNDISVendor.h
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
*/

/**
 * @ingroup IxUSBRNDIS
 *
 * @defgroup IxUSBRNDISVendor IXP425 USB RNDIS Vendor Codelet (IxUSBRNDIS)
 *
 * @brief IXP425 codelet for RNDIS Vendor information
 *
 * @{
 */

/**
 * @def RNDIS_VENDOR_ID
 *
 * @brief RNDIS with static Intel Vendor ID 
 */
#define RNDIS_VENDOR_ID  (0x8086)

/**
 * @def RNDIS_PRODUCT_ID
 *
 * @brief RNDIS with static Product ID 
 */
#define RNDIS_PRODUCT_ID (0x0001)

/**
 * @def RNDIS_VENDOR_DESCRIPTION
 *
 * @brief RNDIS with vendor description 
 */
#define RNDIS_VENDOR_DESCRIPTION "Intel Corporation"

/**
 * @def RNDIS_MAC_ADDRESS
 *
 * @brief RNDIS with MAC address
 */
#define RNDIS_MAC_ADDRESS { 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 }

/** @} defgroup IxUSBRNDIS*/
