#ifndef _WINBINDD_PROTO_H_
#define _WINBINDD_PROTO_H_

/* This file is automatically generated with "make proto". DO NOT EDIT */


/* The following definitions come from nsswitch/winbindd.c  */

void winbind_process_packet(struct winbindd_cli_state *state);
void winbind_client_read(struct winbindd_cli_state *state);
int main(int argc, char **argv);

/* The following definitions come from nsswitch/winbindd_acct.c  */

WINBINDD_PW* wb_getpwnam( const char * name );
WINBINDD_PW* wb_getpwuid( const uid_t uid );
WINBINDD_GR* wb_getgrnam( const char * name );
WINBINDD_GR* wb_getgrgid( gid_t gid );
enum winbindd_result winbindd_create_user(struct winbindd_cli_state *state);
enum winbindd_result winbindd_create_group(struct winbindd_cli_state *state);
enum winbindd_result winbindd_add_user_to_group(struct winbindd_cli_state *state);
enum winbindd_result winbindd_remove_user_from_group(struct winbindd_cli_state *state);
enum winbindd_result winbindd_set_user_primary_group(struct winbindd_cli_state *state);
enum winbindd_result winbindd_delete_user(struct winbindd_cli_state *state);
enum winbindd_result winbindd_delete_group(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_ads.c  */


/* The following definitions come from nsswitch/winbindd_cache.c  */

void wcache_flush_cache(void);
void winbindd_check_cache_size(time_t t);
struct cache_entry *centry_start(struct winbindd_domain *domain, NTSTATUS status);
void wcache_invalidate_samlogon(struct winbindd_domain *domain, 
				NET_USER_INFO_3 *info3);
void wcache_invalidate_cache(void);

/* The following definitions come from nsswitch/winbindd_cm.c  */

NTSTATUS cm_fresh_connection(struct winbindd_domain *domain, const int pipe_index,
			       struct cli_state **cli);
void set_dc_type_and_flags( struct winbindd_domain *domain );
NTSTATUS cm_get_lsa_handle(struct winbindd_domain *domain, CLI_POLICY_HND **return_hnd);
NTSTATUS cm_get_sam_handle(struct winbindd_domain *domain, CLI_POLICY_HND **return_hnd);
NTSTATUS cm_get_netlogon_cli(struct winbindd_domain *domain, 
			     const unsigned char *trust_passwd, 
			     uint32 sec_channel_type,
			     BOOL fresh,
			     struct cli_state **cli);
void winbindd_cm_status(void);
void winbindd_cm_flush(void);

/* The following definitions come from nsswitch/winbindd_dual.c  */

int dual_select_setup(fd_set *fds, int maxfd);
void dual_select(fd_set *fds);
void dual_send_request(struct winbindd_cli_state *state);
void do_dual_daemon(void);

/* The following definitions come from nsswitch/winbindd_group.c  */

enum winbindd_result winbindd_getgrnam(struct winbindd_cli_state *state);
enum winbindd_result winbindd_getgrgid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_setgrent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_endgrent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_getgrent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_list_groups(struct winbindd_cli_state *state);
enum winbindd_result winbindd_getgroups(struct winbindd_cli_state *state);
enum winbindd_result winbindd_getusersids(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_misc.c  */

enum winbindd_result winbindd_check_machine_acct(struct winbindd_cli_state *state);
enum winbindd_result winbindd_list_trusted_domains(struct winbindd_cli_state
						   *state);
enum winbindd_result winbindd_show_sequence(struct winbindd_cli_state *state);
enum winbindd_result winbindd_domain_info(struct winbindd_cli_state *state);
enum winbindd_result winbindd_ping(struct winbindd_cli_state
						   *state);
enum winbindd_result winbindd_info(struct winbindd_cli_state *state);
enum winbindd_result winbindd_interface_version(struct winbindd_cli_state *state);
enum winbindd_result winbindd_domain_name(struct winbindd_cli_state *state);
enum winbindd_result winbindd_netbios_name(struct winbindd_cli_state *state);
enum winbindd_result winbindd_priv_pipe_dir(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_pam.c  */

enum winbindd_result winbindd_pam_auth(struct winbindd_cli_state *state) ;
enum winbindd_result winbindd_pam_auth_crap(struct winbindd_cli_state *state) ;
enum winbindd_result winbindd_pam_chauthtok(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_passdb.c  */

BOOL fill_passdb_alias_grmem(struct winbindd_domain *domain,
			     DOM_SID *group_sid, 
			     int *num_gr_mem, char **gr_mem, int *gr_mem_len);

/* The following definitions come from nsswitch/winbindd_rpc.c  */

NTSTATUS msrpc_name_to_sid(struct winbindd_domain *domain,
			    TALLOC_CTX *mem_ctx,
			    const char *domain_name,
			    const char *name,
			    DOM_SID *sid,
			    enum SID_NAME_USE *type);
NTSTATUS msrpc_sid_to_name(struct winbindd_domain *domain,
			    TALLOC_CTX *mem_ctx,
			    const DOM_SID *sid,
			    char **domain_name,
			    char **name,
			    enum SID_NAME_USE *type);
NTSTATUS msrpc_lookup_useraliases(struct winbindd_domain *domain,
				  TALLOC_CTX *mem_ctx,
				  uint32 num_sids, DOM_SID **sids,
				  uint32 *num_aliases, uint32 **alias_rids);

/* The following definitions come from nsswitch/winbindd_sid.c  */

enum winbindd_result winbindd_lookupsid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_lookupname(struct winbindd_cli_state *state);
enum winbindd_result winbindd_sid_to_uid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_sid_to_gid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_uid_to_sid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_gid_to_sid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_allocate_rid(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_user.c  */

enum winbindd_result winbindd_getpwnam(struct winbindd_cli_state *state) ;
enum winbindd_result winbindd_getpwuid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_setpwent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_endpwent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_getpwent(struct winbindd_cli_state *state);
enum winbindd_result winbindd_list_users(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_util.c  */

struct winbindd_domain *domain_list(void);
void free_domain_list(void);
void rescan_trusted_domains( void );
BOOL init_domain_list(void);
struct winbindd_domain *find_domain_from_name(const char *domain_name);
struct winbindd_domain *find_domain_from_sid(const DOM_SID *sid);
struct winbindd_domain *find_our_domain(void);
struct winbindd_domain *find_lookup_domain_from_sid(const DOM_SID *sid);
struct winbindd_domain *find_lookup_domain_from_name(const char *domain_name);
BOOL winbindd_lookup_sid_by_name(struct winbindd_domain *domain, 
				 const char *domain_name,
				 const char *name, DOM_SID *sid, 
				 enum SID_NAME_USE *type);
BOOL winbindd_lookup_name_by_sid(DOM_SID *sid,
				 fstring dom_name,
				 fstring name,
				 enum SID_NAME_USE *type);
void free_getent_state(struct getent_state *state);
BOOL winbindd_param_init(void);
BOOL check_domain_env(char *domain_env, char *domain);
BOOL parse_domain_user(const char *domuser, fstring domain, fstring user);
void fill_domain_username(fstring name, const char *domain, const char *user);
char *get_winbind_priv_pipe_dir(void) ;
int open_winbindd_socket(void);
int open_winbindd_priv_socket(void);
void close_winbindd_socket(void);
struct winbindd_cli_state *winbindd_client_list(void);
void winbindd_add_client(struct winbindd_cli_state *cli);
void winbindd_remove_client(struct winbindd_cli_state *cli);
void winbindd_demote_client(struct winbindd_cli_state *cli);
void winbindd_kill_all_clients(void);
int winbindd_num_clients(void);
DOM_SID *rid_to_talloced_sid(struct winbindd_domain *domain,
				    TALLOC_CTX *mem_ctx,
				    uint32 rid) ;
BOOL winbindd_upgrade_idmap(void);
BOOL get_trust_pw(const char *domain, uint8 ret_pwd[16],
                          time_t *pass_last_set_time, uint32 *channel);

/* The following definitions come from nsswitch/winbindd_wins.c  */

enum winbindd_result winbindd_wins_byip(struct winbindd_cli_state *state);
enum winbindd_result winbindd_wins_byname(struct winbindd_cli_state *state);

#endif /*  _WINBINDD_PROTO_H_  */
