/* ====================================================================
 * Copyright (c) 2001 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.openssl.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core@openssl.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.openssl.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 */

#ifndef OPENSSL_NO_AES
#include <openssl/evp.h>
#include <openssl/err.h>
#include <string.h>
#include <openssl/aes.h>
#include "evp_locl.h"
#include "IXCryptoAction.h"

static int aes_init_key(EVP_CIPHER_CTX *ctx, const unsigned char *key,
					const unsigned char *iv, int enc);

typedef struct
	{
	AES_KEY ks;
	} EVP_AES_KEY;

static int aes_128_cbc_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { CRYPTO_AES128_CBC(in, out, (long)inl, (unsigned char*)&((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->iv, ctx->encrypt); return 1;}
static int aes_128_cfb_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { AES_cfb128_encrypt(in, out, (long)inl, &((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->iv, &ctx->num, ctx->encrypt); return 1;}
static int aes_128_ecb_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { CRYPTO_AES128_ECB(in, out, (long)inl, (unsigned char*)&((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->encrypt); return 1;} 
static int aes_128_ofb_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { AES_ofb128_encrypt(in, out, (long)inl, &((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->iv, &ctx->num); return 1;}
static const EVP_CIPHER aes_128_cbc = { 419, 16, 16, 16, 0 | 0x2, aes_init_key, aes_128_cbc_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_128_cbc(void) { return &aes_128_cbc; }
static const EVP_CIPHER aes_128_cfb = { 421, 1, 16, 16, 0 | 0x3, aes_init_key, aes_128_cfb_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_128_cfb(void) { return &aes_128_cfb; }
static const EVP_CIPHER aes_128_ofb = { 420, 1, 16, 16, 0 | 0x4, aes_init_key, aes_128_ofb_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_128_ofb(void) { return &aes_128_ofb; }
static const EVP_CIPHER aes_128_ecb = { 418, 16, 16, 16, 0 | 0x1, aes_init_key, aes_128_ecb_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_128_ecb(void) { return &aes_128_ecb; }

static int aes_192_cbc_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { CRYPTO_AES192_CBC(in, out, (long)inl,(unsigned char*)&((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->iv, ctx->encrypt); return 1;} 
static int aes_192_cfb_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { AES_cfb128_encrypt(in, out, (long)inl, &((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->iv, &ctx->num, ctx->encrypt); return 1;}
static int aes_192_ecb_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { CRYPTO_AES192_ECB(in, out, (long)inl, (unsigned char*)&((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->encrypt); return 1;}
static int aes_192_ofb_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { AES_ofb128_encrypt(in, out, (long)inl, &((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->iv, &ctx->num); return 1;}
static const EVP_CIPHER aes_192_cbc = { 423, 16, 24, 16, 0 | 0x2, aes_init_key, aes_192_cbc_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_192_cbc(void) { return &aes_192_cbc; }
static const EVP_CIPHER aes_192_cfb = { 425, 1, 24, 16, 0 | 0x3, aes_init_key, aes_192_cfb_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_192_cfb(void) { return &aes_192_cfb; }
static const EVP_CIPHER aes_192_ofb = { 424, 1, 24, 16, 0 | 0x4, aes_init_key, aes_192_ofb_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_192_ofb(void) { return &aes_192_ofb; }
static const EVP_CIPHER aes_192_ecb = { 422, 16, 24, 16, 0 | 0x1, aes_init_key, aes_192_ecb_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_192_ecb(void) { return &aes_192_ecb; }

static int aes_256_cbc_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { CRYPTO_AES256_CBC(in, out, (long)inl, (unsigned char*)&((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->iv, ctx->encrypt); return 1;}
static int aes_256_cfb_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { AES_cfb128_encrypt(in, out, (long)inl, &((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->iv, &ctx->num, ctx->encrypt); return 1;}
static int aes_256_ecb_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { CRYPTO_AES256_ECB(in, out, (long)inl, (unsigned char*)&((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->encrypt); return 1;}
static int aes_256_ofb_cipher(EVP_CIPHER_CTX *ctx, unsigned char *out, const unsigned char *in, unsigned int inl) { AES_ofb128_encrypt(in, out, (long)inl, &((EVP_AES_KEY *)ctx->cipher_data)->ks, ctx->iv, &ctx->num); return 1;}
static const EVP_CIPHER aes_256_cbc = { 427, 16, 32, 16, 0 | 0x2, aes_init_key, aes_256_cbc_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_256_cbc(void) { return &aes_256_cbc; }
static const EVP_CIPHER aes_256_cfb = { 429, 1, 32, 16, 0 | 0x3, aes_init_key, aes_256_cfb_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_256_cfb(void) { return &aes_256_cfb; }
static const EVP_CIPHER aes_256_ofb = { 428, 1, 32, 16, 0 | 0x4, aes_init_key, aes_256_ofb_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_256_ofb(void) { return &aes_256_ofb; }
static const EVP_CIPHER aes_256_ecb = { 426, 16, 32, 16, 0 | 0x1, aes_init_key, aes_256_ecb_cipher, ((void *)0), sizeof(EVP_AES_KEY), EVP_CIPHER_set_asn1_iv, EVP_CIPHER_get_asn1_iv, ((void *)0), ((void *)0) };
const EVP_CIPHER *EVP_aes_256_ecb(void) { return &aes_256_ecb; }



static int aes_init_key(EVP_CIPHER_CTX *ctx, const unsigned char *key,
		   const unsigned char *iv, int enc) {

	if ((ctx->cipher->flags & EVP_CIPH_MODE) == EVP_CIPH_CFB_MODE
	    || (ctx->cipher->flags & EVP_CIPH_MODE) == EVP_CIPH_OFB_MODE
	    || enc) 
		AES_set_encrypt_key(key, ctx->key_len * 8, ctx->cipher_data);
	else
		AES_set_decrypt_key(key, ctx->key_len * 8, ctx->cipher_data);

	return 1;
}

#endif
