/**
 * @file IxEthAcc_p.h
 *
 * @author Intel Corporation
 * @date 12-Feb-2002
 *
 * @brief  Internal Header file for IXP425 Ethernet Access component.
 *
 * Design Notes:
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */

/**
 * @addtogroup IxEthAccPri
 *@{
 */

#ifndef IxEthAcc_p_H
#define IxEthAcc_p_H

/*
 * Os/System dependancies.
 */
#include <IxTypes.h>
#include <IxOsServices.h>
#include <IxOsCacheMMU.h>

/*
 * Intermodule dependancies
 */
#include <IxNpeDl.h>

#include <IxEthNpe.h>

/* 
 * Intra module dependancies
 */

#include <IxEthAccDataPlane_p.h>


#define INLINE __inline__

#ifdef NDEBUG

#define IX_ETH_ACC_PRIVATE static

#else

#define IX_ETH_ACC_PRIVATE

#endif /* ndef NDEBUG */

#define IX_ETH_ACC_PUBLIC


/**
 * @brief port ID => message handler NPE id conversion (0 => NPE_B, 1 => NPE_C)
 */
#define IX_ETH_ACC_PORT_ID_TO_NPE(id) (id + 1)

/**
 * @brief message handler NPE id => port ID conversion (NPE_B => 0, NPE_C => 1)
 */
#define IX_ETH_ACC_NPE_TO_PORT_ID(npe) (npe - 1)



#define IX_ETH_ACC_IS_PORT_VALID(port) (port <  IX_ETH_ACC_NUMBER_OF_PORTS  ? TRUE : FALSE )



#ifndef NDEBUG
#define IX_ETH_ACC_FATAL_LOG(a,b,c,d,e,f,g) { ixOsServLog ( LOG_FATAL,a,b,c,d,e,f,g);}
#define IX_ETH_ACC_WARNING_LOG(a,b,c,d,e,f,g) { ixOsServLog ( LOG_WARNING,a,b,c,d,e,f,g);}
#define IX_ETH_ACC_DEBUG_LOG(a,b,c,d,e,f,g) { ixOsServLog ( LOG_FATAL,a,b,c,d,e,f,g);}
#else
#define IX_ETH_ACC_FATAL_LOG(a,b,c,d,e,f,g) { ixOsServLog ( LOG_FATAL,a,b,c,d,e,f,g);}
#define IX_ETH_ACC_WARNING_LOG(a,b,c,d,e,f,g) { ixOsServLog ( LOG_WARNING,a,b,c,d,e,f,g);}
#define IX_ETH_ACC_DEBUG_LOG(a,b,c,d,e,f,g) {}
#endif

IX_ETH_ACC_PUBLIC IxEthAccStatus ixEthAccInitDataPlane(void);
IX_ETH_ACC_PUBLIC IxEthAccStatus ixEthAccRegisterQMgrCallbacks(void);
IX_ETH_ACC_PUBLIC IxEthAccStatus ixEthAccSingleEthNpeCheck(IxEthAccPortId portId);

/**
 * @struct  ixEthAccRxDataStats
 * @brief   Stats data structures for data path. - Not obtained from h/w
 *
 */
typedef struct
{ 
    UINT32 rxFrameClientCallback;
    UINT32 rxFreeRepOK;
    UINT32 rxFreeRepDelayed;
    UINT32 rxFreeRepFromSwQOK;
    UINT32 rxFreeRepFromSwQDelayed;
    UINT32 rxFreeLateNotificationEnabled;
    UINT32 rxFreeLowCallback;
    UINT32 rxFreeOverflow;
    UINT32 rxFreeLock;
    UINT32 rxDuringDisable;
    UINT32 rxSwQDuringDisable;
    UINT32 rxUnexpectedError;
} ixEthAccRxDataStats;

/**
 * @struct  ixEthAccTxDataStats
 * @brief   Stats data structures for data path. - Not obtained from h/w
 *
 */
typedef struct
{   
    UINT32 txQOK;
    UINT32 txQDelayed;
    UINT32 txFromSwQOK;
    UINT32 txFromSwQDelayed;
    UINT32 txLowThreshCallback;
    UINT32 txDoneClientCallback;
    UINT32 txDoneClientCallbackDisable;
    UINT32 txOverflow;
    UINT32 txLock;
    UINT32 txPriority[IX_ETH_ACC_TX_PRIORITY_7 + 1];
    UINT32 txLateNotificationEnabled;
    UINT32 txDoneDuringDisable;
    UINT32 txDoneSwQDuringDisable;
    UINT32 txUnexpectedError;
} ixEthAccTxDataStats;


/**
 * @struct  ixEthAccRxDataInfo
 * @brief   Per Port data structures associated with the receive data plane.
 *
 */
typedef struct
{
  IxEthAccPortRxCallback rxCallbackFn;
  UINT32  rxCallbackTag;
  IxEthAccDataPlaneQList freeBufferList;

  ixEthAccRxDataStats stats; /**< Receive s/w stats */
} ixEthAccRxDataInfo; 

/**
 * @struct  ixEthAccTxDataInfo
 * @brief   Per Port data structures associated with the transmit data plane.
 *
 */
typedef struct
{
  IxEthAccPortTxDoneCallback  txBufferDoneCallbackFn;
  UINT32  txCallbackTag;
  IxEthAccDataPlaneQList 	txQ[IX_ETH_ACC_NUM_TX_PRIORITIES]; /**< Transmit Q */
  IxEthAccTxSchedulerDiscipline schDiscipline;
  ixEthAccTxDataStats stats; /**< Transmit s/w stats */
} ixEthAccTxDataInfo; 


/**
 * @struct  ixEthAccPortDataInfo
 * @brief   Per Port data structures associated with the port data plane.
 *
 */
typedef struct
{
   BOOL               portInitialized;
   ixEthAccTxDataInfo ixEthAccTxData; /**< Transmit data control structures */
   ixEthAccRxDataInfo ixEthAccRxData; /**< Recieve data control structures */
} ixEthAccPortDataInfo; 

extern ixEthAccPortDataInfo  ixEthAccPortData[];
#define IX_ETH_IS_PORT_INITIALIZED(port) (ixEthAccPortData[port].portInitialized)

extern BOOL ixEthAccServiceInit;
#define IX_ETH_ACC_IS_SERVICE_INITIALIZED() (ixEthAccServiceInit == TRUE )

/* 
 * Maximum number of frames to consume from the Rx Frame Q.
 */

#define IX_ETH_ACC_MAX_RX_FRAME_CONSUME_PER_CALLBACK (128)

/*
 * Max number of times to load the Rx Free Q from callback.  
 */
#define IX_ETH_ACC_MAX_RX_FREE_BUFFERS_LOAD (256)  /* Set greater than depth of h/w Q + drain time at line rate */

/*
 *  Max number of times to read from the Tx Done Q in one sitting.
 */

#define IX_ETH_ACC_MAX_TX_FRAME_DONE_CONSUME_PER_CALLBACK (256)

/*
 *  Max number of times to take buffers from S/w queues and write them to the H/w Tx
 *  queues on receipt of a Tx low threshold callback 
 */

#define IX_ETH_ACC_MAX_TX_FRAME_TX_CONSUME_PER_CALLBACK (16)


#define IX_ETH_ACC_FLUSH_CACHE(addr,size)  IX_ACC_DATA_CACHE_FLUSH(addr,size)
#define IX_ETH_ACC_INVALIDATE_CACHE(addr,size)  IX_ACC_DATA_CACHE_INVALIDATE(addr,size)


#define IX_ETH_ACC_MEMSET(start,value,size) memset(start,value,size)

#endif /* ndef IxEthAcc_p_H */



