//*****************************************************************************
//*
//*
//*     BitUtility.h
//*
//*
//*****************************************************************************
#ifndef __BITUTILITY_H__
#define __BITUTILITY_H__

//#define     SMB_NO_ASM
#if  defined(__GNUC__)
#if !defined(SMB_NO_ASM)
#if !defined(__i386__) && !defined(__x86_64__)
#warning    "CPU not x86 - not using assembler"
#define     SMB_NO_ASM
#endif
#endif
#endif


		int bit_find_0_next(const void *pMem,unsigned uSize,unsigned uOffset);
		int bit_find_1_next(const void *pMem,unsigned uSize,unsigned uOffset);
inline	int bit_find_0     (const void *pMem,unsigned uSize){return bit_find_0_next(pMem,uSize,0);}
inline	int bit_find_1     (const void *pMem,unsigned uSize){return bit_find_1_next(pMem,uSize,0);}


#ifdef SMB_NO_ASM
    	int bit_set        (      void *pMem,int iOffset);
     	int bit_clear      (      void *pMem,int iOffset);
     	int bit_read       (const void *pMem,int iOffset);
#endif



#ifdef  linux
#ifndef LINUX
#define LINUX   1
#endif
#endif




//*****************************************************************************
//*
//*
//*     LINUX functions
//*
//*
//*****************************************************************************
#if defined(LINUX) && !defined(SMB_NO_ASM)


#if !defined(__i386__) && !defined(__x86_64__)
#error  Error wrong CPU type
#endif



//*****************************************************************************
//*
//*     bit_set
//*
//*****************************************************************************
//  sets a bit in a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_set(void *pMem,int iBit)
{
int iRet;


    #ifdef  __i386__

    asm volatile (
        "movl      %1   ,%%eax  \n"
        "lock bts  %2,  (%%eax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #else

    asm volatile (
        "movl      %1   ,%%rax  \n"
        "lock bts  %2,  (%%rax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #endif


return  iRet;
}


//*****************************************************************************
//*
//*     bit_clear
//*
//*****************************************************************************
//  clears a bit in a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_clear(void *pMem,int iBit)
{
int iRet;


    #ifdef  __i386__

    asm volatile (
        "movl      %1   ,%%eax  \n"
        "lock btr  %2,  (%%eax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #else

    asm volatile (
        "movl      %1   ,%%rax  \n"
        "lock btr  %2,  (%%rax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #endif


return  iRet;
}




//*****************************************************************************
//*
//*     bit_read
//*
//*****************************************************************************
//  reads a bit from a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_read(const void *pMem,int iBit)
{
int iRet;


    #ifdef  __i386__

    asm volatile (
        "movl      %1   ,%%eax  \n"
        "bt        %2,  (%%eax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #else

    asm volatile (
        "movl      %1   ,%%rax  \n"
        "bt        %2,  (%%rax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #endif


return  iRet;
}


#endif




#if  defined(_WIN32) || defined(_WIN64)
#if !defined(SMB_NO_ASM)

#if _MSC_VER >= 1000
#pragma once
#endif

#ifdef  _MSC_VER
#pragma warning( disable :4035 )
#ifdef	_WIN64 
#include <intrin.h>
#endif		
#endif



//*****************************************************************************
//*
//*     bit_set
//*
//*****************************************************************************
//  sets a bit in a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_set(void *pMem,int iBit)
{

	#if defined(_WIN64) || !defined(_M_IX86)

	return _interlockedbittestandset((long*)pMem,iBit);

    #else

    _asm{
        mov  eax,pMem
        mov  ebx,iBit
        lock bts [eax],ebx
        sbb  eax,eax
        }

    #endif

}

//*****************************************************************************
//*
//*     bit_clear
//*
//*****************************************************************************
//  clears a bit in a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_clear(void *pMem,int iBit)
{

	#if defined(_WIN64) || !defined(_M_IX86)

	return _interlockedbittestandreset((long*)pMem,iBit);

    #else

    _asm{
        mov  eax,pMem
        mov  ebx,iBit
        lock btr [eax],ebx
        sbb  eax,eax
        }

    #endif

}

//*****************************************************************************
//*
//*     bit_read
//*
//*****************************************************************************
//  reads a bit from a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_read(const void *pMem,int iBit)
{

	#if defined(_WIN64) || !defined(_M_IX86)

	return _bittest((long*)pMem,iBit);

    #else

    _asm{
        mov     eax,pMem
        mov     ebx,iBit
        bt      [eax],ebx
        sbb     eax,eax
        }

    #endif
}



#ifdef  _MSC_VER
#pragma warning( default :4035 )
#endif

#endif
#endif




#endif
