//*****************************************************************************
//*
//*
//*      SmbServer.cpp
//*
//*
//*****************************************************************************
//
//  Copyright  2003    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
//
#include "System/System.h"
#include "SmbInclude.h"
#include "SmbServer.h"
#include "Smb.h"


int ReplySpecial(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut);
int ReplyCommon (SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize);

extern int   _cdecl  SmbTreeCheck     (const SmbTreeData *pData);
extern int   _cdecl  SmbUserLogon     (SmbUserEntry      *pUser,const char *pUsername);
extern int   _cdecl  SmbGetPassword   (const char        *pUser,char *pBuffer,int iSize);
extern int  (_cdecl *smb_get_password)(const char        *pUser,char *pBuffer,int iSize);
extern int  (_cdecl *smb_user_logon  )(SmbUserEntry      *pUser,const char *pUsername);
extern int  (_cdecl *smb_tree_check  )(const SmbTreeData *pData);


typedef struct
    {
    TcpHandle   hServer;
    int         bRun;
    }SmbInterface;


        SysHeap         hProcessHeap = 0;
        unsigned        uSmbProcess  = 0;
static  unsigned        uAccept      = 0;
static  SmbInterface    sInterface;
static  SmbConfigData   sSmbConfig;
        int             bSmbIsStarted=0;

SmbSession  *aSessionArray[MAX_PROCESS_COUNT];

extern  unsigned    uNmbSendPackets;
extern  unsigned    uNmbResvPackets;
extern  unsigned    uDrgSendPackets;
extern  unsigned    uDrgResvPackets;


#define LARGE_WRITEX_HDR_SIZE   65
#define SAFETY_MARGIN           1024

//*****************************************************************************
//*
//*      SmbReadPacket
//*
//*****************************************************************************
//  Reads a smb packet from the tcp stream
int SmbReadPacket(TcpHandle hTcp,unsigned char *pBuffer,int iMax,int iTimeout)
{
unsigned long   dwStart;
int             iNum;


    if(iTimeout)
        {
        dwStart=SysTickCount();

            iNum = TcpGetWait(hTcp,pBuffer,4,iTimeout);
        if( iNum<=0)return iNum;
            iNum = smb_len(pBuffer);
        if( iNum > iMax)return 0;
            iNum = TcpGetWait(hTcp,pBuffer+4,iNum,iTimeout-SysTickCount()+dwStart);
        if( iNum<=0)return iNum;

        return iNum+4;
        }



        iNum = TcpGet(hTcp,pBuffer,4);
    if( iNum<=0)return iNum;
        iNum = smb_len(pBuffer);
    if( iNum > iMax)return 0;
        iNum = TcpGet(hTcp,pBuffer+4,iNum);
    if( iNum<=0)return iNum;




return iNum+4;
}


//*****************************************************************************
//*
//*      SmbReadNextPacket
//*
//*****************************************************************************
//  Reads the next smb packet from the tcp stream with timeout
int SmbReadNextPacket(TcpHandle hTcp,unsigned char *pBuffer,int iMax,int iTimeout)
{
int     bKeepalive;
int     iSize;


    do  {
        iSize = SmbReadPacket(hTcp,pBuffer,iMax,iTimeout);
        bKeepalive = (iSize>0) && (pBuffer[0]==0x85);
        }while(iSize>0 && bKeepalive);


return iSize;
}

//*****************************************************************************
//*
//*      SmbProcess
//*
//*****************************************************************************
//  Starts a new SMB process
static void SmbProcess(void *pParam)
{
TcpHandle       hTcp=(TcpHandle)pParam;
SmbSession     *pSession;
unsigned char  *pIn,*pOut;
int             iBreak;
int             iType;
int             iOut;
int             iNum;

    iBreak=0;
    uSmbProcess++;

       iNum=SmbNewProcess();
    if(iNum<0)
        {
        PRINT_SMB_ERRS(("\nSYSERRROR too much processes"))
        TcpClose(hTcp);
        return;
        }

        pSession=(SmbSession*)SysHeapAlloc(hProcessHeap,sizeof(SmbSession));
    if(!pSession)
        {
        PRINT_SMB_ERRS(("\nSYSERRROR out of memory for processe"))
        return;
        }

    SmbSessionInit(pSession);
    aSessionArray[iNum]=pSession;


    pIn  = (unsigned char *)SysHeapAlloc(hProcessHeap,sSmbConfig.iMaxBufferSize+LARGE_WRITEX_HDR_SIZE+SAFETY_MARGIN);
    pOut = (unsigned char *)SysHeapAlloc(hProcessHeap,sSmbConfig.iMaxBufferSize+LARGE_WRITEX_HDR_SIZE+SAFETY_MARGIN);

    PRINT_SMB_STATE(("\nSmbProcess() start"));
    memset(pSession,0,sizeof(*pSession));
    pSession->hTcp           = hTcp;
    pSession->ulId           = SmbGetSessionId();
    pSession->iMaxResvSize   = sSmbConfig.iMaxBufferSize;
    pSession->iSecurityMode  = sSmbConfig.iSecurityMode;
    pSession->uProcessNumber = iNum;
    pSession->pChainOut      = pOut;
    pSession->pChainIn       = pIn;
    pSession->iChainSize     = 0;

    if(!pIn || !pOut)
        {
        PRINT_SMB_ERRS(("\nSYSERROR out of memory (size=%i)",sSmbConfig.iMaxBufferSize+LARGE_WRITEX_HDR_SIZE+SAFETY_MARGIN));
        SmbSessionExit(pSession);
        return;
        }

    while(bSmbIsStarted)
        {
        pSession->iCurrentPacket = -1;              // current handlet packet
        pSession->iState = 1;
        
						//printf("\n***************************************\n");
						//printf("Process_NUM: %d\n", iNum);
            iNum = SmbReadPacket(hTcp,pIn,sSmbConfig.iMaxBufferSize+LARGE_WRITEX_HDR_SIZE,SMB_PROCESS_TIMEOUT);
            //printf("Byes_Recviv: %d\n", iNum);
            //printf("***************************************\n");
        
        if( iNum<=0)
            {
            iBreak++;
            SysSleep(20);
            if(iBreak<10)continue;
            PRINT_SMB_STATE(("\nSmbProcess() tcp break"))
            break;
            }

        pSession->iPacketCount++;                   // count of the recived packets

        iBreak=0;
        iType=pIn[0];
        PRINT_SMB_MSG(("\nSMB %02Xh ",iType))


        if(iType==0x85){
        	printf("\n****************KEEPALIVE_85***********************\n");
        	continue;                    // keepalive packet.
				}
				
        pSession->iState = 2;
		
        PRINT_SMB_LOCK();

        if(iType!=0)
            {
            iOut=ReplySpecial(pSession,pIn,pOut);
            }
        else{
            iOut=ReplyCommon(pSession,pIn,pOut,iNum);
            }
            /*
printf("\n============================================\n");
tp=(char *)malloc(5000);
SmbInfo(tp, 5000);
printf("%s",tp);
free(tp);
printf("\n============================================\n");
*/
        PRINT_SMB_MSG1(("\tp:%i com=%02X",iOut,pOut[smb_com]))
        PRINT_SMB_UNLOCK();

        pSession->iState = 3;

        if(iOut>0)
            {
            if(!TcpPut(hTcp,pOut,iOut))
                {
                PRINT_SMB_ERRS(("ERROR tcp write"))
                SmbSessionExit(pSession);
				return;
                }
            }
        
        if(iOut<0)
            {
            PRINT_SMB_STATE(("\nSmbProcess ERROR SIZE size=%i",iOut))
            break;
            }

        //SysSleep(0);
        }

    PRINT_SMB_STATE(("\nSmbProcess() end Number=%i Procces=%i",uAccept,uSmbProcess))
    SmbSessionExit(pSession);

}



//*****************************************************************************
//*
//*      SmbAccept
//*
//*****************************************************************************
//  Acceps new connections from to the smb server
static void SmbAccept(void *pParam)
{
TcpHandle        hTcp;
IpAddr           iAddr;


    PRINT_SMB_STATE(("\n\nSmbAccept() start"));
    sInterface.bRun=TRUE;


    while(bSmbIsStarted)
        {
            hTcp=TcpAcceptWait(sInterface.hServer,&iAddr,NULL,3000);
        if(!hTcp){SysSleep(50);continue;}

        uAccept++;

        #if SMB_PRINT

        char cStr[40];
        IpToString(&iAddr,cStr);
        PRINT_SMB_STATE(("\nSMB Accept: %s Number=%u Procces=%u",cStr,uAccept,uSmbProcess))

        #endif

        SysThreadStart(SmbProcess,0x4000,hTcp,sSmbConfig.iPriority|SYS_GLOBAL,"SMB Process");
        }


    PRINT_SMB_STATE(("\nSmbAccept() end Number=%u Procces=%u",uAccept,uSmbProcess))

}


//*****************************************************************************
//*
//*      SmbDisconnect
//*
//*****************************************************************************
//  Disconnects a connection to a smb sever
void SmbDisconnect()
{

    TcpShutdown(sInterface.hServer);
    TcpClose   (sInterface.hServer);

}

//*****************************************************************************
//*
//*      SmbDaemon
//*
//*****************************************************************************
//  Initalise the smb server
SMB_API int SmbDaemon(SmbConfigData *pConfig)
{
TcpHandle   hTcp;
IpAddr      ipSocket;
int         iError;
int         iSize;



    if(bSmbIsStarted                 )return SMB_ERR_ISRUNNING;
    if(pConfig->iMaxBufferSize<0x1000)return SMB_ERR_WRONGSIZE;
    if(pConfig->iMaxBufferSize>0xFFFF)return SMB_ERR_WRONGSIZE;

	
	SMB_PRINT_SEMINIT();


       iError=SmbInit();
    if(iError)
        {
        if(iError==2)return SMB_ERR_MEMORY;
                     return SMB_ERR_INIT;
        }


    if(!hProcessHeap)                                   // create processheap
        {
        iSize   = pConfig->iMaxBufferSize+LARGE_WRITEX_HDR_SIZE+SAFETY_MARGIN+32;
        iSize  *= 2;
        iSize  += sizeof(SmbSession)+32;
        iSize  *= MAX_PROCESS_COUNT;

            hProcessHeap=SysHeapCreate(iSize+0x1000);
        if(!hProcessHeap)return SMB_ERR_MEMORY;
        }

    memcpy(&sSmbConfig,pConfig,sizeof(sSmbConfig));

    if(!IpAddress(&ipSocket,sSmbConfig.cIpAddress,0))
        {
        return SMB_ERR_WRONGIP;
        }
        
        //Barry_20130508
        //hTcp = TcpOpen(&ipSocket,SMB_PORT,TRUE,FALSE);
        hTcp = TcpOpen(&ipSocket,SMB_PORT,TRUE,8);
    if(!hTcp)
        {
        return SMB_ERR_SOCKET;
        }


    sInterface.hServer = hTcp;



    if(sSmbConfig.pTreeCheck)
            smb_tree_check=sSmbConfig.pTreeCheck;
    else    smb_tree_check=SmbTreeCheck;

    if(sSmbConfig.pUserLogon)
            smb_user_logon=(int(__cdecl*)(SmbUserEntry*,const char*))sSmbConfig.pUserLogon;
    else    smb_user_logon=SmbUserLogon;

    if(sSmbConfig.pGetPassword)
            smb_get_password=sSmbConfig.pGetPassword;
    else    smb_get_password=SmbGetPassword;


    bSmbIsStarted=1;                                    // start accept thread
    SysThreadStart(SmbAccept,0x4000,0,sSmbConfig.iPriority|SYS_GLOBAL,"SMB Daemon");



return SMB_ERR_NONE;
}



//*****************************************************************************
//*
//*      SmbStopDaemon
//*
//*****************************************************************************
//  Disconnets the smb server
SMB_API int SmbStopDaemon()
{

    if(!bSmbIsStarted)return SMB_ERR_ISNOTRUNNING;

    bSmbIsStarted=0;

    if(SmbExit())
        {
        bSmbIsStarted=1;
        return SMB_ERR_ISRUNNING;
        }


return SMB_ERR_NONE;
}



//*****************************************************************************
//*
//*      SmbInfo
//*
//*****************************************************************************
//  Gets inforations about the smb sessions.
//  pBuffer     : buffer for the info text
//  iBufferSize : size of the info text
SMB_API void SmbInfo(char *pBuffer,int iBufferSize)
{
static const char  *pStates[]={"init","read","reply","write","exit"};
SmbSession         *pSession;
SmbTreeEntry       *pTree;
SmbFileEntry       *pFile;
int                 iCount;
int                 iNum;
int                 i,j;
int                 k,l;



    if(iBufferSize<=0)return;
    if(iBufferSize<=160)
        {
        pBuffer[0]=0;
        return;
        }

    j=sprintf(pBuffer,"\nNumber  Remote   P.N P.Type P.Name  State  Trees Users  Files \n---------------------------------------------------------------------------------");
    iBufferSize-=j;
    pBuffer+=j;
    iNum=0;

    for(i=0;i<MAX_PROCESS_COUNT;i++)
        {

            pSession=aSessionArray[i];
        if(!pSession)continue;
        if(!SmbSessionLock(i))continue;

        iNum++;

        if(iBufferSize<45){SmbSessionUnlock(i);continue;}
        j=sprintf(pBuffer,"\n %2i   %7s %5i %4i   ",i,pSession->cRemoteMachine,pSession->iPacketCount,pSession->iCurrentPacket);
        iBufferSize-=j;
        pBuffer+=j;

        if(iBufferSize<16){SmbSessionUnlock(i);continue;}
        j=sprintf(pBuffer,"%-15s ",SmbPacketType(pSession->iCurrentPacket));
        iBufferSize-=j;
        pBuffer+=j;

        if(iBufferSize<16){SmbSessionUnlock(i);continue;}
        j=sprintf(pBuffer,"%-7s ",pStates[pSession->iState]);
        iBufferSize-=j;
        pBuffer+=j;

        for(j=0,iCount=0;j<MAX_TREE_ENTRIES;j++)
            {
            if(SmbGetTree(pSession,j))iCount++;
            }

        if(iBufferSize<5){SmbSessionUnlock(i);continue;}
        j=sprintf(pBuffer,"%2i    ",iCount);
        iBufferSize-=j;
        pBuffer+=j;

        for(j=0,iCount=0;j<MAX_USER_ENTRIES;j++)
            {
            if(SmbGetUser(pSession,j))iCount++;
            }

        if(iBufferSize<5){SmbSessionUnlock(i);continue;}
        j=sprintf(pBuffer,"%2i    ",iCount);
        iBufferSize-=j;
        pBuffer+=j;

        for(j=0;j<MAX_TREE_ENTRIES;j++)
            {
                pTree=SmbGetTree(pSession,j);
            if(!pTree)continue;

            for(k=0;k<MAX_FILE_ENTRIES;k++)
                {
                if(iBufferSize<10)continue;
                if(!bit_read(pTree->cFileEntryBits,k))continue;
                pFile=pTree->sFileEntry+k;
                if(pFile->bType)continue;
                l=sprintf(pBuffer,"%08X ",(unsigned)pFile->hFile);
                iBufferSize-=l;
                pBuffer+=l;
                }
            }


        SmbSessionUnlock(i);
        }

    if(iBufferSize>90)
        {
        j=sprintf(pBuffer,"\n\nActive Sessions: %i  Total Sessions: %i  Accepted Sessions: %i",iNum,uSmbProcess,uAccept);
        iBufferSize-=j;
        pBuffer+=j;
        }

    if(iBufferSize>90)
        {
        j=sprintf(pBuffer,"\nNMB Packets send: %6i  recive: %6i  ",uNmbSendPackets,uNmbResvPackets);
        iBufferSize-=j;
        pBuffer+=j;
        }

    if(iBufferSize>90)
        {
        j=sprintf(pBuffer,"\nDRG Packets send: %6i  recive: %6i  \n\n",uDrgSendPackets,uDrgResvPackets);
        iBufferSize-=j;
        pBuffer+=j;
        }


}



//*****************************************************************************
//*
//*      SmbMemReAlloc
//*
//*****************************************************************************
//  Changes the size of an allocated memory
//  pMem        : is the pointer to the memory
//  uSize       : is the new memory size
//  returns the pointer to the new menory
SMB_API void *SmbMemReAlloc(void *pMem,unsigned uSize)
{
    return SmbReAlloc(pMem,uSize);
}

//*****************************************************************************
//*
//*      SmbMemAlloc
//*
//*****************************************************************************
//  Allocates new memory
//  uSize       : is the new memory size
//  returns the pointer to the menory
SMB_API void *SmbMemAlloc(unsigned uSize)
{
    return SmbAlloc(uSize);
}

//*****************************************************************************
//*
//*      SmbMemFree
//*
//*****************************************************************************
//  Deallocates a memory
//  pMem        : is the pointer to the memory
SMB_API void SmbMemFree(void *pMem)
{
    SmbFree(pMem);
}
