#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include "xml_db.h"

void getCableState (MIPF_INFO* Net_Data)
{
	FILE *fp;
	char *pRet ;
  char read_buff [2] ;
  
  fp = fopen("/etc/network/net_state", "r");
  if (fp == NULL) {
    fprintf(stderr, "Open /etc/network/net_state failed \n");
    return ; 	  
  }
  
  memset(read_buff, 0, sizeof(read_buff));	 
  pRet = fgets(read_buff, sizeof(read_buff), fp);
  if (pRet == NULL) return ;
  	
  Net_Data->cabState = atoi(pRet); 	
  fclose(fp);
  
  return ;
  
}	

void getIpFindInfo(MIPF_INFO* Net_Data)
{ 
 FILE *fp;
 char *pRet ;
 char read_buff [20]; 
   	
 fp = fopen("/etc/network/ip_info", "r");
 if (fp == NULL) {
    fprintf(stderr, "Open /etc/network/ip_info failed \n");
    return ; 	  
 }	
 
 while (!feof(fp))
 { 		
    memset(read_buff, 0, sizeof(read_buff));		
    pRet = fgets(read_buff, sizeof(read_buff), fp);
    if (pRet == NULL) break ;
    	
    if (memcmp(read_buff, "Wireless=", 9) == 0) {
    	 if (read_buff [9] == 't') Net_Data->CamType = 1 ; //Wireless camera
    	 else	                     Net_Data->CamType = 0 ; //Wired camera   	 	  
    }	
    
    if (memcmp(read_buff, "net_type=", 9) == 0) {
    	 if (read_buff [9] == 'l')       Net_Data->netType = 0 ; //Lan
    	 else if (read_buff [9] == 'p')	 Net_Data->netType = 1 ; //PPPoE
    	 else if (read_buff [9] == 'w')	 Net_Data->netType = 2 ; //Wireless
    	 continue ;
    }
    
    if (memcmp(read_buff, "extHttpPort=", 12) == 0) {
    	 Net_Data->extHttpPort = atoi (&read_buff[12]);
    	 continue ;
    }	     	
    
    if (memcmp(read_buff, "extRtspPort=", 12) == 0) {
    	 Net_Data->extRtspPort = atoi (&read_buff[12]);
    	 continue ;
    }	    	  	 
    
    if (memcmp(read_buff, "extRtpPort=", 11) == 0) {
    	 Net_Data->extRtpPort = atoi (&read_buff[11]);
    	 continue ;
    }	    	  	  	
    
    if (memcmp(read_buff, "HttPort=", 8) == 0) {
    	 Net_Data->http_port = atoi (&read_buff[8]);    
    	 continue ;
    }	 
       
    if (memcmp(read_buff, "RtsPort=", 8) == 0) {
    	 Net_Data->rtsp_port = atoi (&read_buff[8]);    	 
    	 continue ;
    }
    
    if (memcmp(read_buff, "RtPort=", 7) == 0) {
    	 Net_Data->rtp_port = atoi (&read_buff[7]);    	 
    	 continue ;
    }
    	     
    if (memcmp(read_buff, "exSSLport=", 10) == 0) {
    	 Net_Data->extSSLport = atoi (&read_buff[10]);    	 
    	 continue ;
    }
    
    if (memcmp(read_buff, "SSLport=", 8) == 0) {
    	 Net_Data->ssl_port = atoi (&read_buff[8]);    	 
    	 continue ;
    }	     	    
 }	
     	   	
 fclose(fp);	
 return ;	
}	


void SyncExPortDataXML (int InType, int xml_slect, char *ExPName, int exPValue, char *pChPara)
{
   char ShellCommand [100] ;
   
   // InType = 0 , input parameters is integer
   // InType = 1 , input parameters is character string
   // xml_slect , choose xml file
   
   //Transfer port number
   memset(ShellCommand, '\0' , sizeof(ShellCommand));	
	
	
   if (InType == 0) {
      snprintf(ShellCommand, sizeof(ShellCommand), "/usr/sbin/WriteXMLDB %d %s %d", xml_slect, ExPName, exPValue);
      system(ShellCommand);
   } else  {
      snprintf(ShellCommand, sizeof(ShellCommand), "/usr/sbin/WriteXMLDB %d %s %s", xml_slect ,ExPName, pChPara);
      system(ShellCommand);
   }				
   
   return ;
}	
