/* $Id: upnpc.c,v 1.99 2013/02/06 12:56:41 nanard Exp $ */
/* Project : miniupnp
 * Author : Thomas Bernard
 * Copyright (c) 2005-2013 Thomas Bernard
 * This software is subject to the conditions detailed in the
 * LICENCE file provided in this distribution. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#ifdef _WIN32
#include <winsock2.h>
#define snprintf _snprintf
#else
/* for IPPROTO_TCP / IPPROTO_UDP */
#include <netinet/in.h>
#endif
#include "miniwget.h"
#include "miniupnpc.h"
#include "upnpcommands.h"
#include "upnperrors.h"

//Barry_20130225_add
#include <syslog.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include "xml_db.h"

/* protofix() checks if protocol is "UDP" or "TCP"
 * returns NULL if not */
const char * protofix(const char * proto)
{
	static const char proto_tcp[4] = { 'T', 'C', 'P', 0};
	static const char proto_udp[4] = { 'U', 'D', 'P', 0};
	int i, b;
	for(i=0, b=1; i<4; i++)
		b = b && (   (proto[i] == proto_tcp[i])
		          || (proto[i] == (proto_tcp[i] | 32)) );
	if(b)
		return proto_tcp;
	for(i=0, b=1; i<4; i++)
		b = b && (   (proto[i] == proto_udp[i])
		          || (proto[i] == (proto_udp[i] | 32)) );
	if(b)
		return proto_udp;
	return 0;
}

static void DisplayInfos(struct UPNPUrls * urls,
                         struct IGDdatas * data)
{
	char externalIPAddress[40];
	char connectionType[64];
	char status[64];
	char lastconnerr[64];
	unsigned int uptime;
	unsigned int brUp, brDown;
	time_t timenow, timestarted;
	int r;
	if(UPNP_GetConnectionTypeInfo(urls->controlURL,
	                              data->first.servicetype,
	                              connectionType) != UPNPCOMMAND_SUCCESS)
		printf("GetConnectionTypeInfo failed.\n");
	else
		printf("Connection Type : %s\n", connectionType);
	if(UPNP_GetStatusInfo(urls->controlURL, data->first.servicetype,
	                      status, &uptime, lastconnerr) != UPNPCOMMAND_SUCCESS)
		printf("GetStatusInfo failed.\n");
	else
		printf("Status : %s, uptime=%us, LastConnectionError : %s\n",
		       status, uptime, lastconnerr);
	timenow = time(NULL);
	timestarted = timenow - uptime;
	printf("  Time started : %s", ctime(&timestarted));
	if(UPNP_GetLinkLayerMaxBitRates(urls->controlURL_CIF, data->CIF.servicetype,
	                                &brDown, &brUp) != UPNPCOMMAND_SUCCESS) {
		printf("GetLinkLayerMaxBitRates failed.\n");
	} else {
		printf("MaxBitRateDown : %u bps", brDown);
		if(brDown >= 1000000) {
			printf(" (%u.%u Mbps)", brDown / 1000000, (brDown / 100000) % 10);
		} else if(brDown >= 1000) {
			printf(" (%u Kbps)", brDown / 1000);
		}
		printf("   MaxBitRateUp %u bps", brUp);
		if(brUp >= 1000000) {
			printf(" (%u.%u Mbps)", brUp / 1000000, (brUp / 100000) % 10);
		} else if(brUp >= 1000) {
			printf(" (%u Kbps)", brUp / 1000);
		}
		printf("\n");
	}
	
	r = UPNP_GetExternalIPAddress(urls->controlURL, data->first.servicetype, externalIPAddress);

	if(r != UPNPCOMMAND_SUCCESS) {
		printf("GetExternalIPAddress failed. (errorcode=%d)\n", r);
	} else {
		printf("ExternalIPAddress = %s\n", externalIPAddress);
	}
}

/* Test function
 * 1 - get connection type
 * 2 - get extenal ip address
 * 3 - Add port mapping
 * 4 - get this port mapping from the IGD */
static void SetRedirectAndTest(  struct UPNPUrls * urls,
                                 struct IGDdatas * data,
                                 const char * iaddr,
                                 const char * iport,
                                 const char * eport,
                                 const char * proto
                              )
{
	char intClient[40];
	char intPort[6];
	int r;

   //Barry_20130225_add
   MIPF_INFO tNetDBate ;	
   int eeport = 0;
   int iiport;
   int len = 0 ;
   char aNewEport[6] ;
   char PortUpData = 1 ;

   fprintf(stderr, "iaddr=[%s] iport=[%s] eport=[%s] proto=[%s]\n", iaddr,iport,eport,proto);

	if(!iaddr || !iport || !eport || !proto)
	{
		fprintf(stderr, "Wrong arguments\n");
		return;
	}
	proto = protofix(proto);
	if(!proto)
	{
		fprintf(stderr, "invalid protocol\n");
		return;
	}
	
   //Barry_20130225_Read DB Value
   getIpFindInfo (&tNetDBate);

   len = strlen(eport);
   strncpy(aNewEport, eport, len+1);
   aNewEport[len] = '\0' ;
   //
      
   do{
      
      r = UPNP_AddPortMapping(urls->controlURL, data->first.servicetype, aNewEport, iport, iaddr, 0, proto, 0);
      if (r!=UPNPCOMMAND_SUCCESS) {
         printf("AddPortMapping(%s, %s, %s) failed with code %d (%s)\n", eport, iport, iaddr, r, strupnperror(r));
         eeport=atoi(aNewEport)+1;
         sprintf(aNewEport,"%d",eeport);
         fprintf(stderr,"aNewEport=[%s]\n",aNewEport);
      }
   } while (r!=UPNPCOMMAND_SUCCESS);

   if(r!=UPNPCOMMAND_SUCCESS)
      printf("AddPortMapping(%s, %s, %s) failed with code %d (%s)\n", eport, iport, iaddr, r, strupnperror(r));
  
   eeport=atoi(aNewEport);
   iiport=atoi(iport);

   //Updata DB
   if (PortUpData) {
      if (iiport==tNetDBate.http_port) {
         SyncExPortDataXML(0, 0, "ddnsHttpPort", eeport, NULL);
         ///usr/sbin/WriteXMLDB %d %s %d", xml_slect, ExPName, exPValue
         syslog(LOG_INFO,"External HttpPort is upgrade.\n");
         fprintf(stderr,"External HttpPort is upgrade.\n");
      }

//Barry_20130226_comment
#if 0
      else if(iiport==tNetDBate.rtp_port) {
         SyncExPortDataXML(0, 0, "videoRtpPort", eeport, NULL);
         syslog(LOG_INFO,"External RtpPort is upgrade.\n");
         fprintf(stderr,"External RtpPort is upgrade.\n");
      }
#endif

      else if(iiport==tNetDBate.rtsp_port) {
         SyncExPortDataXML(0, 0, "ddnsRtspPort", eeport, NULL);
         syslog(LOG_INFO,"External Rtsp_port is upgrade.\n");
         fprintf(stderr,"External Rtsp_port is upgrade.\n");
      }else if(iiport==tNetDBate.ssl_port) {
         SyncExPortDataXML(0, 0, "ddnsHttpsPort", eeport, NULL);
         SyncExPortDataXML(0, 2, "exSSLport", eeport, NULL);
         syslog(LOG_INFO,"External SSL_port is upgrade.\n");
         fprintf(stderr,"External SSL_port is upgrade.\n");
      }
   }


   r = UPNP_GetSpecificPortMappingEntry(urls->controlURL, data->first.servicetype, eport, proto, intClient, intPort);
   if(r!=UPNPCOMMAND_SUCCESS) {
      syslog(LOG_ERR, "Add Port Mapping failed - Internal port = [%s]; external port = [%d]",iport ,eeport);
      syslog(LOG_ERR, "GetSpecificPortMappingEntry() failed with code %d (%s)\n", r, strupnperror(r));
   }
   
   if(intClient[0]) {
      fprintf(stderr, "External port:%d %s is redirected to Internal %s:%s\n", eeport, proto, intClient, intPort);
      syslog(LOG_INFO, "External port:%d %s is redirected to Internal %s:%s\n", eeport, proto, intClient, intPort);
   }
}

static void
RemoveRedirect(struct UPNPUrls * urls,
               struct IGDdatas * data,
			   const char * eport,
			   const char * proto)
{
	int r;
	if(!proto || !eport)
	{
		fprintf(stderr, "invalid arguments\n");
		return;
	}
	proto = protofix(proto);
	if(!proto)
	{
		fprintf(stderr, "protocol invalid\n");
		return;
	}
	r = UPNP_DeletePortMapping(urls->controlURL, data->first.servicetype, eport, proto, 0);
	printf("UPNP_DeletePortMapping() returned : %d\n", r);
}

static void ListRedirections(struct UPNPUrls * urls,
                             struct IGDdatas * data)
{
   int r;
   int i = 0;
   char index[6];
   char intClient[40];
   char intPort[6];
   char extPort[6];
   char protocol[4];
   char desc[80];
   char enabled[6];
   char rHost[64];
   char duration[16];


   printf("line=%d\n",__LINE__);
   
   do {
      snprintf(index, 6, "%d", i);
      rHost[0] = '\0'; enabled[0] = '\0';
      duration[0] = '\0'; desc[0] = '\0';
      extPort[0] = '\0'; intPort[0] = '\0'; intClient[0] = '\0';
      r = UPNP_GetGenericPortMappingEntry(   urls->controlURL,
                                             data->first.servicetype,
                                             index,
                                             extPort, intClient, intPort,
                                             protocol, desc, enabled,
                                             rHost, duration
                                         );
      if(r==0)
         printf("%2d %s %5s->%s:%-5s '%s' '%s' %s\n",
                  i, protocol, extPort, intClient, intPort,
                  desc, rHost, duration);
      else
         printf("GetGenericPortMappingEntry() returned %d (%s)\n", r, strupnperror(r));
      i++;
	} while(r==0);
}

/* sample upnp client program */
int main(int argc, char ** argv)
{
	char command = 0;
	char ** commandargv = 0;
	int commandargc = 0;
	struct UPNPDev * devlist = 0;
	char lanaddr[64];	/* my ip address on the LAN */
	int i;
	const char * rootdescurl = 0;
	const char * multicastif = 0;
	const char * minissdpdpath = 0;
	int retcode = 0;
	int error = 0;
	int ipv6 = 0;
	const char * description = 0;

   //Barry_20130227
   MIPF_INFO tNetDBate ;
   memset(&tNetDBate, 0, sizeof(tNetDBate));
   getIpFindInfo (&tNetDBate);
   
   //Default is disable
   //printf("FILE=%s, %d\n", __FILE__, __LINE__);
   SyncExPortDataXML(0, 2, "upnpPortForwarding", 0, NULL); 
   //

#ifdef _WIN32
	WSADATA wsaData;
	int nResult = WSAStartup(MAKEWORD(2,2), &wsaData);
	if(nResult != NO_ERROR)
	{
		fprintf(stderr, "WSAStartup() failed.\n");
		return -1;
	}
#endif

	/* command line processing */
	for(i=1; i<argc; i++)
	{
		if(argv[i][0] == '-')
		{
			if(argv[i][1] == 'u')
				rootdescurl = argv[++i];
			else if(argv[i][1] == 'm')
				multicastif = argv[++i];
			else if(argv[i][1] == 'p')
				minissdpdpath = argv[++i];
			else if(argv[i][1] == '6')
				ipv6 = 1;
			else if(argv[i][1] == 'e')
				description = argv[++i];
			else
			{
				command = argv[i][1];
				i++;
				commandargv = argv + i;
				commandargc = argc - i;
				break;
			}
		}
		else
		{
			fprintf(stderr, "option '%s' invalid\n", argv[i]);
		}
	}

	if(!command || (command == 'd' && argc<2))
	{
		fprintf(stderr, "Usage :\t%s [options] -a ip port external_port protocol [duration]\n\t\tAdd port redirection\n", argv[0]);
		fprintf(stderr, "       \t%s [options] -d external_port protocol [port2 protocol2] [...]\n\t\tDelete port redirection\n", argv[0]);
		fprintf(stderr, "       \t%s [options] -s\n\t\tGet Connection status\n", argv[0]);
		fprintf(stderr, "       \t%s [options] -l\n\t\tList redirections\n", argv[0]);
		
		return 1;
	}

	if( rootdescurl || (devlist = upnpDiscover(2000, multicastif, minissdpdpath,
	                             0/*sameport*/, ipv6, &error)))
	{
		struct UPNPDev * device;
		struct UPNPUrls urls;
		struct IGDdatas data;
		if(devlist)
		{
			printf("List of UPNP devices found on the network :\n");
			for(device = devlist; device; device = device->pNext)
			{
				printf(" desc: %s\n st: %s\n\n",
					   device->descURL, device->st);
			}
		}
		else
		{
			printf("upnpDiscover() error code=%d\n", error);
		}
		i = 1;
		if( (rootdescurl && UPNP_GetIGDFromUrl(rootdescurl, &urls, &data, lanaddr, sizeof(lanaddr)))
		  || (i = UPNP_GetValidIGD(devlist, &urls, &data, lanaddr, sizeof(lanaddr))))
		{
			switch(i) {
			case 1:
				printf("Found valid IGD : %s\n", urls.controlURL);
				break;
			case 2:
				printf("Found a (not connected?) IGD : %s\n", urls.controlURL);
				printf("Trying to continue anyway\n");
				break;
			case 3:
				printf("UPnP device found. Is it an IGD ? : %s\n", urls.controlURL);
				printf("Trying to continue anyway\n");
				break;
			default:
				printf("Found device (igd ?) : %s\n", urls.controlURL);
				printf("Trying to continue anyway\n");
			}
			printf("Local LAN ip address : %s\n", lanaddr);

			switch(command)
			{
            case 'a':
               SetRedirectAndTest(&urls, &data, lanaddr, commandargv[0], commandargv[1], commandargv[2]);
               SetRedirectAndTest(&urls, &data, lanaddr, commandargv[3], commandargv[4], commandargv[5]);
               SetRedirectAndTest(&urls, &data, lanaddr, commandargv[6], commandargv[7], commandargv[8]);
               SetRedirectAndTest(&urls, &data, lanaddr, commandargv[9], commandargv[10], commandargv[11]);
            break;
            
            case 'd':
               for(i=0; i<commandargc; i+=2)
               {
                  RemoveRedirect(&urls, &data, commandargv[i], commandargv[i+1]);
               }
            break;
            
            case 's':
               DisplayInfos(&urls, &data);
               SyncExPortDataXML(1, 2, "privateIp", 0, lanaddr);
            break;
            
            case 'l':
               ListRedirections(&urls, &data);
            break;
            
            default:
               fprintf(stderr, "Unknown switch -%c\n", command);
               retcode = 1;
         }
         
			FreeUPNPUrls(&urls);
		}
		else
		{
			fprintf(stderr, "No valid UPNP Internet Gateway Device found.\n");
			retcode = 1;
		}
		freeUPNPDevlist(devlist); devlist = 0;
		SyncExPortDataXML(0, 2, "upnpPortForwarding", 1, NULL); 
	}
	else
	{
		fprintf(stderr, "No IGD UPnP Device found on the network !\n");
		retcode = 1;
		SyncExPortDataXML(0, 2, "upnpPortForwarding", 0, NULL); //upnpc is failed;
	}
	return retcode;
}

