#ifndef ARCH_ROSSINI_SYSC64TIMER_H
#define ARCH_ROSSINI_SYSC64TIMER_H

#include "mach/hardware.h"
#include "rossini.h"

//#define ROSSINI_SYSC_CPU_BASE (IO_ADDRESS(ROSSINI_SYSC_MMR_BASE))
#define ROSSINI_SYSC_CNT_CTRL 0x18
#define ROSSINI_SYSC_CNT_LO_DATA 0x1C
#define ROSSINI_SYSC_CNT_HI_DATA 0x20

//interface
//#define VPL_SYSC_CPU_BASE ROSSINI_SYSC_CPU_BASE
#define VPL_SYSC_CNT_CTRL ROSSINI_SYSC_CNT_CTRL
#define VPL_SYSC_CNT_HI_DATA ROSSINI_SYSC_CNT_HI_DATA
#define VPL_SYSC_CNT_LO_DATA ROSSINI_SYSC_CNT_LO_DATA

#define CNT_TO_10MSEC 10000
#define LOW_PART_OVERFLOW_TIME (0xffffffff / CNT_TO_10MSEC)

#if (AHB_CLK == 200000000)
extern u64 usec_in_64timer ;
#elif ((AHB_CLK == 166666666) || (AHB_CLK == 133333333))
#define NANOSEC_PER_ABPCLK (1000000000 / APB_CLK)
#endif
extern u64 cyclenum_in_64timer ;

#endif	// __ASM_ARCH_ROSSINI_PORTING_H__
