/*
 *  Boa, an http server.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define LEN_REALM_LIST 256
#define REALM_LIST_SEPARATOR ''

/* Protection categories: anonymous, password. */
enum prot_category {
     anonymous_prot_category = 0,
     password_prot_category = 1,
     last_prot_category = 2
};

/* String in configuration file and numerical group association. */
struct realm_group {
     char *name;
     gid_t id;
     struct realm_group *next;
};

/*
 * Realm name and the protection space of the realm, password or anonymous
 * category, and the numerical group identifiers associated with the realm.
 */
struct realm {
     char *name;
     char *space;
     enum prot_category category;
     struct realm_group *groups;
     struct realm *next;
};

#ifndef DISABLE_DEBUG
void dump_realms(void);
#endif
struct realm *find_realm(const char *realm_name);
void set_user_realm_list(struct user *user_item);
