/*
 * Copyright (C) 2009 Maxim IC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _LINUX_QCCDEV_H
#define _LINUX_QCCDEV_H

#include <linux/types.h>

#if defined(CONFIG_CANYONLANDS) || defined(CONFIG_ARCH_FALCON)
#include <linux/falcon/qcc_bids.h>
#endif

#define DEFAULT_QCC_DEVICE  "/dev/qcc" 

/* size in in number of bytes, 1,2 or 4 */
struct qcc_access {
    uint8_t blockID;
    uint16_t addr;
    unsigned long data;
    uint8_t size;
};

enum qcc_cmds {
    QCC_NONE    = 0x00,
    QCC_READ    = 'R',
    QCC_WRITE   = 'W',
    QCC_POLL    = 'P',
    QCC_CHECK   = 'C',
    QCC_MODIFY  = 'M',
    QCC_WAIT    = 'D',
};

/* struct of a command table we can parse, write only */
struct qcc_cmd_def {
    enum qcc_cmds  cmd;
    uint8_t  blockID;
    uint16_t addr;
    uint8_t  size;
    uint32_t data;
    uint32_t mask;
};

struct qcc_write_block {
    struct qcc_cmd_def *cmds;
    int entries;
};

#define QCC_IOCTL_BASE     'Q'

#define QCCIOC_READ         _IOR(QCC_IOCTL_BASE, 0, struct qcc_access)
#define QCCIOC_WRITE        _IOR(QCC_IOCTL_BASE, 1, struct qcc_access)
#define QCCIOC_WRITE_BLOCK  _IOR(QCC_IOCTL_BASE, 2, struct qcc_write_block)

#endif
