/*
 *  This file Copyright (C) 2009 Maxim IC
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE   LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef _INCLUDE_LINUX_FALCON_QCC_BIDS_H
#define _INCLUDE_LINUX_FALCON_QCC_BIDS_H

#include <linux/falcon/qcc_chipctl_regs.h>
#include <linux/falcon/qcc_regs.h>

/*
 *  These define the Block Ids for each unit in the QCC
 */

/* XXX previously this info could be taken from /tools/pub/qmm/hsi/falcon/include/src/m6_qcc_bid.h
 * but these files don't seem to be updated for falcon, so... for now will take them from ewashington
 * tree until this gets figured out
 qu102 [37] % grep QCC_BID /home/ewashington/svnproject/falcon/chip/src/m6_qcc_bid.h | grep -v MASK |sort -k 3
 */
#define   QCC_BID_QDBG_SYS       0x01   // QMM Debug Unit (System QMM)
#define   QCC_BID_QDBG_VID       0x02   // QMM Debug Unit (Video QMM)
#define   QCC_BID_MBOX           0x03   // Inter-CPU Mailbox (System QMM & ARM/ExternalHost)
#define   QCC_BID_UART           0x04   // QMM UART
#define   QCC_BID_CHIPCTL        0x05   // QCC Chip Control Unit
#define   QCC_BID_SBC_MMU        0x07   // SBC's MMU
#define   QCC_BID_GPU            0x18   // Graphics Processing Unit
#define   QCC_BID_MMU0           0x20   // Memory Management Unit #0
#define   QCC_BID_PMU0           0x21   // Partition Management Unit #0
#define   QCC_BID_PMC0           0x22   // Physical Memory Control Unit #0
#define   QCC_BID_MMU1           0x24   // Memory Management Unit #1
#define   QCC_BID_PMU1           0x25   // Partition Management Unit #1
#define   QCC_BID_PMC1           0x26   // Physical Memory Control Unit #1
#define   QCC_BID_AII0           0x28   // Audio Input Unit #0
#define   QCC_BID_AII1           0x29   // Audio Input Unit #1
#define   QCC_BID_AII2           0x2A   // Audio Input Unit #2
#define   QCC_BID_AOI            0x2B   // Audio Output Unit
#define   QCC_BID_BITSIF_BASE    0x2C   // Bitstream Unit Base ( modulo 4 )
#define   QCC_BID_BITSIF_IN0     0x2D   // Bitstream Input Unit #0
#define   QCC_BID_BITSIF_IN1     0x2E   // Bitstream Input Unit #1
#define   QCC_BID_BITSIF_OUT2    0x2F   // Bitstream Output Unit #2
#define   QCC_BID_VIDEO          0x40   // Base address = same as QCC_BID_VPU0
#define   QCC_BID_VPP0           0x40   // Video Pre-Processing Unit #0
#define   QCC_BID_VIN0           0x41   // Video Input Unit #0
#define   QCC_BID_FBR0           0x42   // Frame Buffer Read Unit #0
#define   QCC_BID_VDW0           0x43   // VDW Unit #0
#define   QCC_BID_FBW            0x44   // Frame Buffer Write Unit
#define   QCC_BID_VIDMUX         0x45   // Video Mux Unit
#define   QCC_BID_CSC            0x46   // Color Space Converter
#define   QCC_BID_VPP1           0x48   // Video Pre-Processing Unit #0
#define   QCC_BID_VIN1           0x49   // Video Input Unit #0
#define   QCC_BID_FBR1           0x4A   // Frame Buffer Read Unit #0
#define   QCC_BID_VDW1           0x4B   // VDW Unit #0
#define   QCC_BID_VPU0           0x50   // Video Processing Unit #0 (Video Output)
#define   QCC_BID_VCK0           0x51   // Video Color Key Module #0
#define   QCC_BID_VPUG           0x52   // Video Processing Unit for VCK Graphics
#define   QCC_BID_VPU1           0x54   // Video Processing Unit #1 (Video Output)
#define   QCC_BID_VCK1           0x55   // Video Color Key Module #1
#define   QCC_BID_PME            0x58   // Pre-Motion Estimation Unit

/*
 *  These define the individual addresses for registers in BID 8
 *  the chip control unit
 */
/* taken from /tools/pub/qmm/hsi/falcon/include/src/m6_reg.h */
/*
   - XXX note to self, this is all going to change since I am going
   to generate all these defines and corresponding bit fields
   automaticcally using scripts this basically means all the code
   using these will be broke
   - many/most are in the kernel so are not a big deal, there may be
   a couple(unverfied) that our in the drivers somewhere that will
   need to be removed or we can #define the old name to the new name

   will keep all this for now since we can compile the kernel but
   that will change soon

*/
#if 1
#define	QCC_CHIPCTL_PLL0_CONTROL				0X10
#define	QCC_CHIPCTL_PLL1_CONTROL				0X14
#define	QCC_CHIPCTL_PLL2_CONTROL				0X18
#define	QCC_CHIPCTL_PLL3_CONTROL				0X1C
#define	QCC_CHIPCTL_SCALER0_CONTROL				0X20
#define	QCC_CHIPCTL_SCALER1_CONTROL				0X24
#define	QCC_CHIPCTL_SCALER2_CONTROL				0X28
#define	QCC_CHIPCTL_SCALER3_CONTROL				0X2C
#define	QCC_CHIPCTL_AVCCLK_CONTROL				0X30
#define	QCC_CHIPCTL_PMECLK_CONTROL				0X34
#define	QCC_CHIPCTL_QMMCLK_CONTROL				0X38
#define	QCC_CHIPCTL_VPP0CLK_CONTROL				0X3C
#define	QCC_CHIPCTL_VPP1CLK_CONTROL				0X40
#define	QCC_CHIPCTL_VPUCLK_CONTROL				0X44
#define	QCC_CHIPCTL_MPEGCLK_CONTROL				0X48
#define	QCC_CHIPCTL_JPEGCLK_CONTROL				0X4C
#define	QCC_CHIPCTL_V0PIXCLK_CONTROL			0X50
#define	QCC_CHIPCTL_V1PIXCLK_CONTROL			0X54
#define	QCC_CHIPCTL_V2PIXCLK_CONTROL			0X58
#define	QCC_CHIPCTL_PLL4_CONTROL				0X5C
#define	QCC_CHIPCTL_SCALER4_CONTROL				0X60
#define	QCC_CHIPCTL_V0CLK_CONTROL				0X64
#define	QCC_CHIPCTL_V1CLK_CONTROL				0X68
#define	QCC_CHIPCTL_V2CLK_CONTROL				0X6C
#define	QCC_CHIPCTL_UARTDBGCLK_CONTROL			0X70
#define	QCC_CHIPCTL_UART0CLK_CONTROL			0X74
#define	QCC_CHIPCTL_UART1CLK_CONTROL			0X78
#define	QCC_CHIPCTL_DIV4CLK_CONTROL				0X7C
#define	QCC_CHIPCTL_I2C0CLK_CONTROL				0X80
#define	QCC_CHIPCTL_I2C1CLK_CONTROL				0X84
#define	QCC_CHIPCTL_DIV2CLK_CONTROL				0X88
#define	QCC_CHIPCTL_DIV3CLK_CONTROL				0X8C
#define	QCC_CHIPCTL_TIMERCLK_CONTROL			0X90
#define	QCC_CHIPCTL_SDMMCCLK_CONTROL			0X94
#define	QCC_CHIPCTL_AUD0_CONTROL				0X98
#define	QCC_CHIPCTL_AUD1_CONTROL				0X9C
#define	QCC_CHIPCTL_BSCLK_CONTROL				0XA0
#define	QCC_CHIPCTL_AUD0CLK_CONTROL				0XA4
#define	QCC_CHIPCTL_AUD1CLK_CONTROL				0XA8
#define	QCC_CHIPCTL_CLKALT_CONFIG				0XAC
#define	QCC_CHIPCTL_VIN0CLK_CONTROL				0XB0
#define	QCC_CHIPCTL_VIN1CLK_CONTROL				0XB4
#define	QCC_CHIPCTL_VOUTCLK_CONTROL				0XB8
#define	QCC_CHIPCTL_ENETCLK_CONTROL				0XBC
#define	QCC_CHIPCTL_VIN0_CONTROL				0XE8
#define	QCC_CHIPCTL_VIN1_CONTROL				0XEC
#define	QCC_CHIPCTL_VOUT_CONTROL				0XF0
#define	QCC_CHIPCTL_SERIALIO_DRIVESTRENGTH0		0X100
#define	QCC_CHIPCTL_SERIALIO_DRIVESTRENGTH1		0X104
#define	QCC_CHIPCTL_SERIALIO_DRIVESTRENGTH2		0X108
#define	QCC_CHIPCTL_SERIALIO_DRIVESTRENGTH3		0X10C
#define QCC_CHIPCTL_PLL2CLK_CONTROL     0x88
#define QCC_CHIPCTL_PLL3CLK_CONTROL     0x8C
#define QCC_CHIPCTL_SSI0CLK_CONTROL     0x98
#define QCC_CHIPCTL_SSI1CLK_CONTROL     0x9C
#define QCC_CHIPCTL_VIDEOINVERT_CONTROL 0x60
#endif

#endif  /* _INCLUDE_LINUX_FALCON_QCC_BIDS_H */
