/*
 *  This file Copyright (C) 2007 Mobilygen Corp.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE	LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _CADPWM_H_
#define _CADPWM_H_

/*-------------------------------------------------------------------------*/

/* General */

/* 
 * AMBA component ID - This value is arbitrarily set,
 * we leave the low order byte for device ID,
 * and the high order byte for designer ID.
 */
#define CADPWM_ID				0x00198700
#define CADPWM_ID_MASK				0x00ffff00

struct cadpwm_block_data {
	const char *clock_id;
};

#define CADPWM_DUTY_CYCLE_RATIO 		1000UL
#define CADPWM_DUTY_CYCLE_RATIO_STRING 		"1000"

/*-------------------------------------------------------------------------*/

/* Driver API */

/* 
 * Pass NULL if you do not want to get all settings.
 */
void cadpwm_get(const char *block_id, char *enabled, 
	unsigned long *frequency, unsigned long *dutycycle);

/* 
 * Pass 0 in frequency or dutycycle if you do not 
 * want to change their current value.
 * If enable is set, block will be enabled 
 * AFTER any freq/dutycyle changes are made.
 */
void cadpwm_set(const char *block_id, char enabled, 
	unsigned long frequency, unsigned long dutycycle);

/*
 * Returns acceptable values for each setting 
 * (pass NULL if you do not want one value).
 */
void cadpwm_get_minmax(const char *block_id, unsigned long *min_frequency, 
	unsigned long *max_frequency, unsigned long *min_dutycycle, 
	unsigned long *max_dutycycle);

/*-------------------------------------------------------------------------*/

/* Component Registers */

#define CADPWM_IC_CONTROL			0x00
#define CADPWM_IC_PERIOD			0x04
#define CADPWM_IC_HIGHTIME			0x08
#define CADPWM_IC_ID				0x0c
#define CADPWM_IC_IR_ENABLE			0x10
#define CADPWM_IC_IR_DISABLE			0x14
#define CADPWM_IC_RIR_ENABLE			0x18
#define CADPWM_IC_RIR_STATUS			0x1c

/*-------------------------------------------------------------------------*/

/* Values and stuff */

#define CADPWM_PERIOD_MIN			2UL
#define CADPWM_PERIOD_MAX			4294967294UL

#define CADPWM_HIGHTIME_MIN			1UL
#define CADPWM_HIGHTIME_MAX			4294967293UL

/*-------------------------------------------------------------------------*/

#endif /* #ifndef _CADPWM_H_ */
