/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/

//
/// \defgroup StereoAudioInputCtrlObj Stereo Audio Input 
/// \{

/// \page sain Stereo Audio Input
/// \latexonly
/// \chapter{Stereo Audio Input}
/// \input{sain}
/// \endlatexonly
///
/// The SAIN status block contains information related to state and performance.
/// 
/// \latexonly
/// \input{structAIN__STATUS}
/// \endlatexonly


#ifndef __QSAIN_HH
#define __QSAIN_HH

#include "qglobal.h"

//////////////////////////////////////////////////////////////////////
//
// Commands
//
#define Q_SAIN_CMD_START                    1  
#define Q_SAIN_CMD_FLUSH                    2  
#define Q_SAIN_CMD_SET_PARAM                3
#define Q_SAIN_CMD_ACTIVATE_CFG             4

#define Q_SAIN_MAX_CMD                      5

// Define Channel type
#define Q_SAIN_CFP_CHANNEL_STEREO               0
#define Q_SAIN_CFP_CHANNEL_MONO_L               2
#define Q_SAIN_CFP_CHANNEL_MONO_R               3

///////////////////////////////////////////////////////////////////////
//
// Command Payloads
// 

typedef struct
{
    unsigned int param;
    int value;
} STRUCT_Q_SAIN_CMD_SET_PARAM;

//////////////////////////////////////////////////////////////////////
//
// Command Parameter Values
//

#define Q_SAIN_CMP_SOME_PARAMETER                    0

//////////////////////////////////////////////////////////////////////
//
// Events
//
#define SAIN_EVENT(ID) ((SAIN_CTRLOBJ_TYPE << 16) | ID)

/// \brief audio in on different platform
#define Q_SAIN_EV_PLATFORM_VERSION  SAIN_EVENT(1) 



//////////////////////////////////////////////////////////////////////
//
// Configuration parameters
//
//////////////////////////////////////////////////////////////////////
//
/// \brief this command specifies serial mode I2S or Left Justified. 
/// parameter's values are Q_SAIN_CFP_AUD_SERIAL_MODE_I2S or
//                          Q_SAIN_CFP_AUD_SERIAL_MODE_LEFT_JUSTIFIED  
#define Q_SAIN_CMP_AUD_SERIAL_MODE                   0
/// \brief this command specifies master clock is 256xFS or 512xFS 
#define Q_SAIN_CMP_AUD_MASTER_CLOCK                  1
/// \brief this command specifies audio sampling rate.
/// \param value audio sampling rate is HZ.
/// Some codecs require specific sample rates while for others it 
/// is flexible. For example : 
/// - AAC-LC , MPEG 1 and 2 layer 2 : flexible
/// - ER-AAC-LD - flexible, but the minimum available is 22.05Khz
/// - G711 - 8 Khz
/// - G722 - 16 Khz
/// - G726 - 8 Khz
/// - G728 - 8 Khz
#define Q_SAIN_CMP_AUD_SAMPLE_RATE                   2
/// \brief this command specifies the size of audio sample.
/// \param value size of audio sample is bits. 
#define Q_SAIN_CMP_AUD_SAMPLE_SIZE                   3
/// \brief Specify number of samples captured per audio frame per channel, which must correlate with the audio encoder's frame size requirements.
/// Some codecs require specific frame sizes, while
/// for other codecs the frame size is flexible.  For example:
///   - AAC-LC: 1024
///   - ER-AAC-LD: 512
///   - G.711: flexible, but must be even
///   - G.722: flexible, but must be even
///   - G.726: flexible, but must be even
///   - MPEG 1 and 2 Layer 2: 1152
#define Q_SAIN_CMP_AUD_FRAME_SIZE                    4
/// \brief this command specifies the channel numbers of audio input.
/// \param value of channel numbers is MONO_L, MONO_R or STEREO. 
#define Q_SAIN_CMP_AUD_CHANNEL_NUM                   5
/// \brief this command specifies the clock source of audio input/output ports.
/// audio clock may come from internal source (MG3500) or external source. 
#define Q_SAIN_CMP_AUD_CLOCK_SOURCE                  6
/// \brief this command specifies the drive phase
#define Q_SAIN_CMP_AUD_DRIVELRCK_SCKPHASE            7
/// \brief this command specifies the sample phase
#define Q_SAIN_CMP_AUD_SAMPLE_SCKPHASE               8
/// \brief this command specifies the audio bus clock
#define Q_SAIN_CMP_AUD_BUS_CLOCK                     9
/// \brief Set the starting PTS of the audio recording to be greater than zero
/// \param MSB of 64 bit start PTS
#define Q_SAIN_CMP_AUD_START_PTS_HIGH               10
/// \brief Set the starting PTS of the audio recording to be greater than zero
/// \param LSB of 64 bit start PTS
#define Q_SAIN_CMP_AUD_START_PTS_LOW                11
/// \brief Add an offset to all audio PTS values.  This has no effect on the video PTS or
///        on A/V sync, audio PTS for each captured frame simply has a higher value.  This
///        means that when the stream is played back, audio will be delayed relative to
///        video.  This can be used to correct for audio/video skew in the input.
/// \param Offset 32 bit PTS offset
#define Q_SAIN_CMP_AUD_PTS_OFFSET                   12

#define Q_SAIN_CMP_AUD_NTP_CLOCK_ENABLE             13
/// \brief Enable audio variable sample rate mode
/// \param enable 1 = enable, 0 = disable (default)
#define Q_SAIN_CMP_AUD_VARIABLE_SAMPLE_RATE         14

#define Q_SAIN_CMP_MAX                              15


////////////////////////////////////////////////////////////
// Configuration parameter values
//

// Generated from mediaware.h AUD_MASTER_CLOCK s/^/Q_SAIN_CFP_/
#define Q_SAIN_CFP_AUD_MASTER_CLOCK_256FS            0
#define Q_SAIN_CFP_AUD_MASTER_CLOCK_512FS            1

// Generated from mediaware.h AUD_SERIAL_MODE s/^/Q_SAIN_CFP_/
#define Q_SAIN_CFP_AUD_SERIAL_MODE_I2S               0
#define Q_SAIN_CFP_AUD_SERIAL_MODE_LEFT_JUSTIFIED    1
#define Q_SAIN_CFP_AUD_SERIAL_MODE_RIGHT_JUSTIFIED   2

// Generated from mediaware.h AUD_BUS_CLOCK s/^/Q_SAIN_CFP_/
#define Q_SAIN_CFP_AUD_BUS_CLOCK_32FS                0
#define Q_SAIN_CFP_AUD_BUS_CLOCK_64FS                1

/// \brief this parameter specifies audio clock comes from MG3500.
#define Q_SAIN_CFP_AUD_INTERNAL_CLK                  0
/// \brief this parameter specifies audio clock comes from the external source.
#define Q_SAIN_CFP_AUD_EXTERNAL_CLK                  1

//////////////////////////////////////////////////////////////////////
//
// Status block
//

typedef struct
{
#ifdef _WIN32
    int dummy;
#endif
} SAIN_STATUS;

#endif
