/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


/// \defgroup HostVideoOutputControlObject Host Video Output
/// \{

/// \page hvout Host Video Output
/// \latexonly
/// \chapter{Host Video Output}
/// \input{hvout}
/// \endlatexonly

#ifndef __QHVOUT_HH
#define __QHVOUT_HH

#include "qglobal.h"

//////////////////////////////////////////////////////////////////////
//
// Commands
//
#define Q_HVOUT_CMD_START                   1
#define Q_HVOUT_CMD_STOP                    2
#define Q_HVOUT_CMD_FLUSH                   3
#define Q_HVOUT_CMD_FRAME_RELEASE           4
#define Q_HVOUT_CMD_BIND_INPUT              5
#define Q_HVOUT_CMD_UNBIND_INPUT            6

#define Q_HVOUT_MAX_CMD                     7

///////////////////////////////////////////////////////////////////////
//
// Command Payloads
// 
typedef struct
{
    int objID;
    int portType;
} STRUCT_Q_HVOUT_CMD_BIND_INPUT;


//////////////////////////////////////////////////////////////////////
//
// Command Parameter Values
//


//////////////////////////////////////////////////////////////////////
//
// Events
//
#define HVOUT_EVENT(ID) ((HVOUT_CTRLOBJ_TYPE << 16) | ID)

#define Q_HVOUT_EV_FRAME_READY  HVOUT_EVENT(1)

typedef struct
{
    unsigned int        address;
    unsigned long long  videoPTS;
} STRUCT_Q_HVOUT_EV_FRAME_READY;


//////////////////////////////////////////////////////////////////////
//
// Configuration parameters
//


//////////////////////////////////////////////////////////////////////
//
// Configuration parameter values
//


//////////////////////////////////////////////////////////////////////
//
// Status block
//

typedef struct
{
#ifdef _WIN32
    int dummy;
#endif
} HVOUT_STATUS;

#endif
