/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


#ifndef __QHVCAP_HH
#define __QHVCAP_HH

#include "qglobal.h"

//////////////////////////////////////////////////////////////////////
//
// Commands
//

/// \brief This command starts the HVCAP block.
/// \param startFrameID The frame number of the first frame that needs to be captured
/// \return Code:  1 = Success, 0 = Failure
#define Q_HVCAP_CMD_START                   1
/// \brief This command flushes and releases all the unfinished frames
/// \return Code:  1 = Success, 0 = Failure
#define Q_HVCAP_CMD_FLUSH                   2
/// \brief This command notifies codec that the host is done writing a frame
/// \param frameID Frame number of the captured frame
/// \return Code:  1 = Success, 0 = Failure
#define Q_HVCAP_CMD_FRAME_WRITTEN           3
/// \brief The command sets up a configuration parameter, which will be activated
/// through the Q_HVCAP_CMD_ACTIVATE_CFG command.
/// \param param Parameter index
/// \param value Parameter value
/// \return Code:  1 = Success, 0 = Failure
#define Q_HVCAP_CMD_SET_PARAM               4
/// \brief This command enables all modified configuration parameters since the last
/// activate command.
/// \return Code:  1 = Success, 0 = Failure
#define Q_HVCAP_CMD_ACTIVATE_CFG            5
/// \brief This command stops the HVCAP block and reset its parameters.
/// \return Code:  1 = Success, 0 = Failure
#define Q_HVCAP_CMD_STOP                    6

#define Q_HVCAP_MAX_CMD                     7

///////////////////////////////////////////////////////////////////////
//
// Command Payloads
// 

typedef struct
{
    unsigned int startFrameID;
} STRUCT_Q_HVCAP_CMD_START;

typedef struct
{
    unsigned int param;
    int value;
} STRUCT_Q_HVCAP_CMD_SET_PARAM;

typedef struct
{
    unsigned int frameID;
} STRUCT_Q_HVCAP_CMD_FRAME_WRITTEN;


//////////////////////////////////////////////////////////////////////
//
// Command Parameter Values
//

#define Q_HVCAP_CMP_SOME_PARAMETER                    0

//////////////////////////////////////////////////////////////////////
//
// Events
//
#define HVCAP_EVENT(ID) ((HVCAP_CTRLOBJ_TYPE << 16) | ID)

#define Q_HVCAP_EV_FRAME_AVAILABLE  HVCAP_EVENT(1)
#define Q_HVCAP_EV_FLUSHED          HVCAP_EVENT(2)

typedef struct
{
    unsigned int        streamID;
    unsigned int        frameID;
    unsigned int        lumaAddr;
    unsigned int        chromaAddr;
} STRUCT_Q_HVCAP_EV_FRAME_AVAILABLE;

typedef struct
{
    unsigned int        streamID;
} STRUCT_Q_HVCAP_EV_FLUSHED;


//////////////////////////////////////////////////////////////////////
//
// Configuration parameters
//
// Generated from mediaware.h HVCAP_CFG s/HVCAP_CFG/Q_HVCAP_CMP/
/// \brief Capture frame width
/// \param value Integer number.
#define Q_HVCAP_CMP_FRAME_WIDTH                      0
/// \brief Capture frame height
/// \param value Integer number.
#define Q_HVCAP_CMP_FRAME_HEIGHT                     1
/// \brief Indicates whether the capture frame is interlaced
/// \param value 0 = progressive, 1 = interlaced
#define Q_HVCAP_CMP_FRAME_INTERLACED                 2
/// \brief Indicates whether the capture frame is of color format YUV420
/// \param value 0 = YUV422, 1= YUV420
#define Q_HVCAP_CMP_FRAME_IS420                      3
/// \brief Indicates the YUV samples arrangement in the input file
/// \param value 0 = interleaved, 1 = planar
#define Q_HVCAP_CMP_FRAME_ISPLANAR                   4


//////////////////////////////////////////////////////////////////////
//
// Configuration parameter values
//


#endif
