/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


#ifndef __QGLOBAL_HH
#define __QGLOBAL_HH

#define PROD_CONFIG_OFFSET   0x40
#define SYS_APP_PCFG         (PROD_CONFIG_OFFSET / 4)

//////////////////////////////////////////////////////////////////////
//
// Commands which are accepted by all interface objects
//
#define Q_CMD_OPCODE_GLOBAL_START           1024

#define Q_CMD_OPCODE_SUBSCRIBE_EVENT        1024
#define Q_CMD_OPCODE_UNSUBSCRIBE_EVENT      1025
#define Q_CMD_OPCODE_CONFIGURE              1026
#define Q_CMD_OPCODE_SET_NAME               1027

#define Q_CMD_OPCODE_GLOBAL_END             1027

#define MAX_COMMAND_ARGS                    (20)
#define MAX_COMMAND_RVALS                   (5)
#define MAX_EVENT_PAYLOAD                   (21)

#define SYSTEMCONTROL_CTRLOBJ_ID            1

#define SYSCTRL_CTRLOBJ_TYPE                1
#define LVPP_CTRLOBJ_TYPE                   2
#define NVPP_CTRLOBJ_TYPE                   3
#define AVOC_CTRLOBJ_TYPE                   4
#define AVCENC_CTRLOBJ_TYPE                 5
#define HVCAP_CTRLOBJ_TYPE                  6
#define HVOUT_CTRLOBJ_TYPE                  7
#define SAIN_CTRLOBJ_TYPE                   8
#define AVSN_CTRLOBJ_TYPE                   9
#define AVDEC_CTRLOBJ_TYPE                 10
#define AUDENC_CTRLOBJ_TYPE                11
#define HAOUT_CTRLOBJ_TYPE                 12
#define JPEGENC_CTRLOBJ_TYPE               13
#define ASPLIT_CTRLOBJ_TYPE                14
#define HACAP_CTRLOBJ_TYPE                 15
#define AUDFLTR_CTRLOBJ_TYPE               16

#define MAX_CTRLOBJ_ID                      (256)
#define MAX_EVENTS_PER_CTRLOBJ              (128)
#define MAX_CTRLOBJ_NAME_LEN                (MAX_COMMAND_ARGS*4)

//////////////////////////////////////////////////////////////////////
//
// Types
//

#define ENCODE_EVENT(OBJ, ID) ((OBJ << 16) | ID)

typedef int CONTROLOBJECT_ID;
typedef int EVENT_ID;
typedef int CONTROLOBJECT_STATE;

/// \brief Event structure dispatched by QMM firmware
///
/// \ingroup structs
///
/// This event structure is very close to the QVEvent class
/// and should continue to track its development.  The
/// difference between this type and QVEvent are the first
/// two arguments.  In QVEvent, the first field is DATA, 
/// and the second is the event type whereas the first
/// here is the event type and the second is the 
/// control object ID.
typedef struct
{
    CONTROLOBJECT_ID    controlObjectId;
    EVENT_ID            eventId;
    unsigned int        timestamp;
    unsigned int        payload[MAX_EVENT_PAYLOAD];
} EVENT;


/// \brief Command block in QMM address space
///
/// \ingroup structs
///
typedef struct
{
    CONTROLOBJECT_ID    controlObjectId;
    unsigned int        opcode;
    unsigned int        arguments[MAX_COMMAND_ARGS];
    int                 returnCode;
    unsigned int        returnValues[MAX_COMMAND_RVALS];   
} COMMAND;

typedef struct
{
    unsigned int sec;
    unsigned int usec;
} NTP_TIME;

/// \brief NTP block
typedef struct
{
    NTP_TIME ntpBlock0;
    NTP_TIME ntpBlock1;
    unsigned int ntpIndex;
} NTP_BLOCK;

#define COMMAND_CONTROL_OBJECT_ID_OFFSET (0)
#define COMMAND_OPCODE_OFFSET (4)
#define COMMAND_ARGUMENTS_OFFSET (8)
#define COMMAND_RETURN_CODE_OFFSET (32)
#define COMMAND_RETURN_VALUES_OFFSET (36)

/// \brief Global pointer block in QMM address space
///
/// \ingroup structs
///
typedef struct
{
    COMMAND                     *cmdBlock;
    EVENT                       *evBlock;
    void                        *systemControlStatus;
    void                        *meStatus;
    void                        *codecDebugLog;
    unsigned int                 evReadWritePtrs;
    NTP_BLOCK                   *ntpBlock;
    COMMAND                     *cmdBlockList;
} GLOBAL_POINTER_BLOCK;

#define COMMAND_BLOCK_OFFSET            (0)
#define EVENT_BLOCK_OFFSET              (4)
#define SYSTEM_CONTROL_STATUS_OFFSET    (8)
#define ME_GLOBAL_STATUS_OFFSET         (12)
#define EVENT_PTRS_OFFSET               (20)
#define NTP_BLOCK_OFFSET                (24)
#define COMMAND_BLOCK_LIST_OFFSET       (28)

#define PTR_TO_GLOBAL_POINTER_BLOCK (0xffc)


#define PRIVATE_LEVEL_2


#define PUBLIC_1
#define PUBLIC_2
#define PUBLIC_3

#define PRIVATE_LEVEL_3 
#define PUBLIC_4

#endif  /* __QGLOBAL_HH */

