/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


/// \defgroup AudioVideoOutputCompositorControlObject Audio Video Output Compositor
/// \{

/// \page avoc Audio Video Output Compositor
/// \latexonly
/// \chapter{Audio Video Output Compositor}
/// \input{avoc}
/// \endlatexonly
///

#ifndef __QAVOC_HH
#define __QAVOC_HH

#include "qglobal.h"

//////////////////////////////////////////////////////////////////////
//
// Commands
//

/// \brief This command starts the AVOC and places it in the RUN state.
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_START                             1

/// \brief This command stops the AVOC and places it in the IDLE state.
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_STOP                              2

/// \brief This command sets a double-buffered parameter.  The parameter
/// is activated through the Q_AVOC_CMD_ACTIVATE command.
/// \param param Parameter index
/// \param value Parameter value
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_SET_PARAM                         3

/// \brief This command is used to enable all double-buffered parameters
/// that have been set since the last activation.
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_ACTIVATE                          4

/// \brief This command creates a new video channel and returns the 
/// index of the channel. The index is used to set video channel parameters.
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_ADD_VIDEO_CHANNEL                 5

/// \brief This command deletes an existing video channel.
/// \param id Video channel ID
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_DEL_VIDEO_CHANNEL                 6

/// \brief This command creates a new audio channel and returns the 
/// index of the channel. The index is used to set audio channel parameters.
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_ADD_AUDIO_CHANNEL                 7

/// \brief This command deletes an existing audio channel.
/// \param id Audio channel ID
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_DEL_AUDIO_CHANNEL                 8

/// \brief This command sets a double-buffered configuration parameter for
/// a specific video channel.  
/// \param id Video channel ID
/// \param param Parameter index
/// \param value Parameter value
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_SET_VIDEO_CHANNEL_PARAM           9

/// \brief This command activates all double-buffered video channel
/// configuration parameters since the last activation.
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_ACTIVATE_VIDEO_CHANNEL_CONFIG    10

/// \brief This command sets a double-buffered configuration parameter for
/// a specific audio channel.  
/// \param id Audio channel ID
/// \param param Parameter index
/// \param value Parameter value
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_SET_AUDIO_CHANNEL_PARAM          11

/// \brief This command activates all double-buffered audio channel
/// configuration parameters since the last activation.
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_ACTIVATE_AUDIO_CHANNEL_CONFIG    12

/// \brief This command is not supported at this time
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_SET_TIMING_MASTER_VIDEO_CHANNEL  13

/// \brief This command sets a double-buffered OSD configuration parameter.
/// \param param Parameter index
/// \param value Parameter value
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_SET_OSD_PARAM                    14

/// \brief This command activates all double-buffered OSD
/// configuration parameters since the last activation.
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_ACTIVATE_OSD                     15

/// \brief This command sets up to 16 palette entries for one of the two OSD planes
/// \param plane Index of the OSD plane to configure (0 or 1)
/// \param index Starting palette index to set
/// \param length Number of palette entries to set
/// \param entries[16] Palette entries as RGBA from MSB to LSB with 8-bits for each component
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_SET_OSD_PALETTE                  16

/// \brief This command fills the render buffers with the specified yuv color. This must only
///        be called when the AVOC is in idle state and with all of its render buffers released.
/// \param yuv YUV color
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_FILL_RENDER_BUFFERS              17

/// \brief This command connects an AVSN object to the AVOC.
/// \param objID AVNS object id
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_AVSN_CONNECT                     18

/// \brief This command disconnects an AVSN object from the AVOC.
/// \param objID AVNS object id
/// \return Code:  1 = Success, 0 = Failure
#define Q_AVOC_CMD_AVSN_DISCONNECT                  19

#define Q_AVOC_MAX_CMD                              20

///////////////////////////////////////////////////////////////////////
//
// Command Payloads
// 

typedef struct
{
    /// \brief Parameter index to set
    unsigned int param;
    /// \brief Parameter value
    int value;
} STRUCT_Q_AVOC_CMD_SET_PARAM;

typedef struct
{
    unsigned int ch;
} STRUCT_Q_AVOC_CMD_DEL_VIDEO_CHANNEL;

typedef struct
{
    unsigned int ch;
} STRUCT_Q_AVOC_CMD_DEL_AUDIO_CHANNEL;

typedef struct
{
    unsigned int ch;
    unsigned int param;
    int value;
} STRUCT_Q_AVOC_CMD_SET_PARAM_VCH;

typedef struct
{
    unsigned int ch;
    unsigned int param;
    int value;
} STRUCT_Q_AVOC_CMD_SET_PARAM_ACH;

typedef struct
{
    unsigned int plane;
    unsigned int param;
    int value;
} STRUCT_Q_AVOC_CMD_SET_OSD_PARAM;

typedef struct
{
    unsigned int plane;
    unsigned int index;
    unsigned int length;
    unsigned int entries[16];
} STRUCT_Q_AVOC_CMD_SET_OSD_PALETTE;

typedef struct
{
    unsigned int yuv;
} STRUCT_Q_AVOC_CMD_FILL_RENDER_BUFFERS;

typedef struct
{
    unsigned int objID;
} STRUCT_Q_AVOC_CMD_AVSN;

//////////////////////////////////////////////////////////////////////
//
// Command Parameter Values
//
// Generated from mediaware.h OUT_VID_CFG s/OUT_VID_CFG/Q_AVOC_CMP_VIDEO_CHANNEL/
/// \brief This video channel parameter sets source of the video channel.
///        video output modes.
/// \param value handle to AVSN object or 0 to disable video channel.
///
#define Q_AVOC_CMP_VIDEO_CHANNEL_SOURCE              0
/// \brief This video channel parameter is not implemented.
#define Q_AVOC_CMP_VIDEO_CHANNEL_Z_DEPTH             1
/// \brief This video channel parameter sets the source picture width.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VIDEO_CHANNEL_SRC_WIDTH           2
/// \brief This video channel parameter sets the source picture height.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VIDEO_CHANNEL_SRC_HEIGHT          3
/// \brief This video channel parameter sets the source picture x offset.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VIDEO_CHANNEL_SRC_OFFSET_X        4
/// \brief This video channel parameter sets the source picture y offset.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VIDEO_CHANNEL_SRC_OFFSET_Y        5
/// \brief This video channel parameter sets the destination picture x offset.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VIDEO_CHANNEL_DST_OFFSET_X        6
/// \brief This video channel parameter sets the destination picture y offset.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VIDEO_CHANNEL_DST_OFFSET_Y        7
/// \brief This video channel parameter sets the destination picture width.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VIDEO_CHANNEL_DST_WIDTH           8
/// \brief This video channel parameter sets the destination picture height.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VIDEO_CHANNEL_DST_HEIGHT          9
/// \brief This video channel parameter is not implemented.
#define Q_AVOC_CMP_VIDEO_CHANNEL_DEINTERLACE        10
/// \brief This parameter enables the scaler to use one field of the source picture and scales
///        it to a progressive frame. For example you would use it for 720x480i to 352x288p.
///        This feature improves performance with minor losses in scaling quality.
///        This feature only works on interlaced source pictures with the AVOC in
///        video render mode.
/// \param value 0 = OFF (Both fields are used), 1 = Use top field, 2 = Use bottom field.
#define Q_AVOC_CMP_VIDEO_CHANNEL_SCALE_FIELD_MODE   11
/// \brief This parameter sets the video channel to be background color. Note this will incur
///        memory bandwidth usage on every frame rendered. The channel source width, height, x
///        and y must be set to 32, 16, 0 and 0 respectively for correct operation.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_VIDEO_CHANNEL_BG_COLOR_ENABLE    12
/// \brief This parameter forces the scaler to operate in progressive or interlace mode.
/// \param value 0 = Default, 1 = interlace, 2 = progressive.
///
#define Q_AVOC_CMP_VIDEO_CHANNEL_FORCE_RENDER_MODE  13

// Generated from mediaware.h OUT_AUD_CFG s/OUT_AUD_CFG/Q_AVOC_CMP_AUD_CHANNEL/
/// \brief Set the source for an audio output channel (an AudioVideoSynchronizerControlObject).
/// \param handle Handle to an AVSN object
#define Q_AVOC_CMP_AUD_CHANNEL_SOURCE                0
/// \brief Enable/disable the output of audio for this channel.  Only one channel can be enabled
///        at a time.
/// \param enable 1 == enable, 2 == disable
#define Q_AVOC_CMP_AUD_CHANNEL_ENABLE                1

// Generated from mediaware.h OUT_GFX_CFG s/OUT_GFX_CFG/Q_AVOC_CMP_OSD/
/// \brief This OSD plane parameter sets the modifers that control the blending of the OSD plane with the
///        other planes.
/// \param value [16:31] Reserved.\n
///              [8:15]  Color Modifier.\n
///              [0:7]   Alpha Modifier.\n
///
#define Q_AVOC_CMP_OSD_SRC_MODIFIER                  0
/// \brief This OSD plane parameter sets the color key for the OSD plane.
/// \param value [24:31] Color Key Y value.\n
///              [16:23] Color Key Cb value.\n
///              [8:15] Color Key Cr value.\n
///              [6:7] Color Key Mode. 0 = None, 1 = Screen, 2 = Display, 3 = Reserved.\n
///              [0:5] Reserved.\n
///
#define Q_AVOC_CMP_OSD_COLOR_KEY                     1
/// \brief This OSD plane parameter sets the display width of the OSD plane.
/// \param value Integer number.
///
#define Q_AVOC_CMP_OSD_WIDTH                         2
/// \brief This OSD plane parameter sets the display height of the OSD plane.
/// \param value Integer number.
///
#define Q_AVOC_CMP_OSD_HEIGHT                        3
/// \brief This OSD plane parameter sets the source picture width.
/// \param value Integer number.
///
#define Q_AVOC_CMP_OSD_SRC_WIDTH                     4
/// \brief This OSD plane parameter sets the source picture height.
/// \param value Integer number.
///
#define Q_AVOC_CMP_OSD_SRC_HEIGHT                    5
/// \brief This OSD plane parameter sets the display x offset of the OSD plane.
/// \param value Integer number.
///
#define Q_AVOC_CMP_OSD_X                             6
/// \brief This OSD plane parameter sets the display y offset of the OSD plane.
/// \param value Integer number.
///
#define Q_AVOC_CMP_OSD_Y                             7
/// \brief This OSD plane parameter sets the source picture x offset.
/// \param value Integer number.
///
#define Q_AVOC_CMP_OSD_SRC_X                         8
/// \brief This OSD plane parameter sets the source picture y offset.
/// \param value Integer number.
///
#define Q_AVOC_CMP_OSD_SRC_Y                         9
/// \brief This OSD plane parameter sets the horizontal zoom of the OSD plane.
/// \param value Horizontal zoom factor - 1.
///
#define Q_AVOC_CMP_OSD_ZOOM_H                       10
/// \brief This OSD plane parameter sets the vertical zoom of the OSD plane.
/// \param value Vertical zoom factor - 1.
///
#define Q_AVOC_CMP_OSD_ZOOM_V                       11
/// \brief This OSD plane parameter sets source picture of the OSD plane.
/// \param value memory segment address 0 to disable OSD plane.
///
#define Q_AVOC_CMP_OSD_SOURCE_FRAME                 12
/// \brief This OSD plane parameter sets the source picture format.
/// \param value  0 = 1bpp indexed.\n
///               1 = 1bpp grayscale.\n
///               2 = 2bpp indexed.\n
///               3 = 2bpp grayscale.\n
///               4 = 4bpp indexed.\n
///               5 = 4bpp grayscale.\n
///               6 = 8bpp indexed.\n
///               7 = 8bpp grayscale.\n
///              16 = 16bpp RGB  444.\n
///              17 = 16bpp RGBA 4444.\n
///              18 = 16bpp RGB  555.\n
///              19 = 16bpp RGBA 5551.\n
///              20 = 16bpp RGB  565.\n
///              21 = 16bpp RGBA 5641.\n
///              24 = 32bpp RGB  888.\n
///              25 = 32bpp RGBA 8888.\n
///
#define Q_AVOC_CMP_OSD_COLOR_FORMAT                 13
/// \brief This OSD plane parameter sets the ordering of the OSD plane in relation to the other planes.
/// \param value 0, 1 or 2 where 0 = Top most layer.
///
#define Q_AVOC_CMP_OSD_DISPLAY_DEPTH                14

//////////////////////////////////////////////////////////////////////
//
// Events
//
#define AVOC_EVENT(ID) ((AVOC_CTRLOBJ_TYPE << 16) | ID)

#define Q_AVOC_EV_VIDEO_FRAME_DISPLAYED AVOC_EVENT(1)

//////////////////////////////////////////////////////////////////////
//
// Configuration parameters
//
// Generated from mediaware.h OUT_CFG s/OUT_CFG/Q_AVOC_CMP/
/// \brief Select the serial mode of the audio output.
/// \param mode I2S, left justified, or right justified
#define Q_AVOC_CMP_AUD_SERIAL_MODE                   0
/// \brief Select the master clock of the audio output.
/// \param mclk 256Fs or 512Fs
#define Q_AVOC_CMP_AUD_MASTER_CLOCK                  1
/// \brief Select the SCK to LRCK ratio of the audio output.
/// \param ratio 32Fs or 64Fs
#define Q_AVOC_CMP_AUD_SCKTOLRCK_RATIO               2
/// \brief Select the drive SCK phase of the audio output.
/// \param phase integer value
#define Q_AVOC_CMP_AUD_DRIVE_SCKPHASE                3
/// \brief Select the LRCK drive SCK phase of the audio output.
/// \param phase integer value
#define Q_AVOC_CMP_AUD_SAMPLELRCK_SCKPHASE           4
/// \brief Select the sampling frequence for the audio output.
/// \param samplerate 16000, 24000, 32000, 44100, or 48000.
#define Q_AVOC_CMP_AUD_SAMPLE_RATE                   5
/// \brief Select the sample size for the audio output.
/// \param samplesize 16, 24, or 32.
#define Q_AVOC_CMP_AUD_SAMPLE_SIZE                   6
/// \brief This parameter sets the horizontal aspect ratio of the video plane.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_PIXEL_AR_X                  7
/// \brief This parameter sets the vertical aspect ratio of the video plane.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_PIXEL_AR_Y                  8
/// \brief This parameter enables or disables the video plane.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_VID_0_ENABLE                      9
/// \brief This parameter enables or disables the video plane hardware scaling.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_VID_0_SCALING_ENABLE             10
/// \brief This parameter sets video plane width.
/// \param value Integer number, must be even.
///
#define Q_AVOC_CMP_VID_0_DISPLAY_WIDTH              11
/// \brief This parameter sets video plane height.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_DISPLAY_HEIGHT             12
/// \brief This parameter sets video plane x position.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_DISPLAY_OFFSET_X           13
/// \brief This parameter sets video plane y position.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_DISPLAY_OFFSET_Y           14
/// \brief This parameter sets the ordering of the video plane in relation to the other planes.
/// \param value 0, 1 or 2 where 0 = Top most layer.
///
#define Q_AVOC_CMP_VID_0_DISPLAY_DEPTH              15
/// \brief This parameter sets the modifers that control the blending of the video plane with the
///        graphics planes.
/// \param value [16:31] Reserved.\n
///              [8:15]  Color Modifier.\n
///              [0:7]   Alpha Modifier.\n
///
#define Q_AVOC_CMP_VID_0_SRC_MODIFIER               16
/// \brief This parameter sets the color key for the video plane.
/// \param value [24:31] Color Key Y value.\n
///              [16:23] Color Key Cb value.\n
///              [8:15] Color Key Cr value.\n
///              [6:7] Color Key Mode. 0 = None, 1 = Screen, 2 = Display, 3 = Reserved.\n
///              [0:5] Reserved.\n
///
#define Q_AVOC_CMP_VID_0_COLOR_KEY                  17
/// \brief This parameter tells the video output whether it is connect to an external deinterlacer or not.
///        This only affects interlaced output modes. Enable for flat panel progressive displays and disable for interlaced CRT displays.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_EXTERNAL_DEINTERLACER            18
/// \brief This parameter enables or disables the video compositor rendering functionality.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_VID_0_COMP_ENABLE                19
/// \brief This parameter sets which video channel to display when the video compositor is off (in bypass mode).
/// \param value Valid video channel number.
///
#define Q_AVOC_CMP_VID_0_COMP_BYPASS_CHANNEL        20
/// \brief This parameter sets the video compositor render buffer width.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_COMP_WIDTH                 21
/// \brief This parameter sets the video compositor render buffer height.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_COMP_HEIGHT                22
/// \brief This parameter is deprecated.
///
#define Q_AVOC_CMP_VID_0_COMP_BG_COLOR              23
/// \brief This parameter sets the video output unit width.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VPU_OUTPUT_WIDTH                 24
/// \brief This parameter sets the video output unit height.
/// \param value Integer number, must be even for interlaced output modes.
///
#define Q_AVOC_CMP_VPU_OUTPUT_HEIGHT                25
/// \brief This parameter sets the video output unit vertical blanking.
/// \param value Integer number, must be odd for interlaced output modes. Programmed with
///              (Vertical Blanking - 1).
///
#define Q_AVOC_CMP_VPU_VBLANK_LINES                 26
/// \brief This parameter sets the video output unit horizontal blanking.
/// \param value Integer number, this value includes EAV/SAV codes. Programmed with
///              (Horizontal Blanking - 1).
///
#define Q_AVOC_CMP_VPU_HBLANK_CLOCKS                27
/// \brief This parameter sets the video output unit vertical active start.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VPU_VACT_START                   28
/// \brief This parameter sets the video output unit horizontal active start.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VPU_HACT_START                   29
/// \brief This parameter sets the video output unit vertical start offset when
///        OUT_CFG_VPU_EXTERNAL_SYNC is set to 1.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VPU_START_OFFSET_V               30
/// \brief This parameter sets the video output unit horizontal start offset when
///        OUT_CFG_VPU_EXTERNAL_SYNC is set to 1.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VPU_START_OFFSET_H               31
/// \brief This parameter sets the video output unit vertical sync pulse width.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VPU_VSYNC_WIDTH                  32
/// \brief This parameter sets the video output unit horizontal sync pulse width.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VPU_HSYNC_WIDTH                  33
/// \brief This parameter sets the video output unit RGB-YUV conversion matrices.
/// \param value 0 = standard CCIR601 matrices, 1 = ITU BT.709 matrices.
///
#define Q_AVOC_CMP_VPU_YUV_MATRIX                   34
/// \brief This parameter sets the video output unit field signal output mode.
/// \param value 0 = combined H/V blanking, 1 = internal field signal.
///
#define Q_AVOC_CMP_VPU_SELECT_FIELD                 35
/// \brief This parameter sets the video output unit blank polarity.
/// \param value 0 = active high, 1 = active low.
///
#define Q_AVOC_CMP_VPU_BLANK_POLARITY               36
/// \brief This parameter sets the video output unit vertical sync polarity.
/// \param value 0 = active high, 1 = active low.
///
#define Q_AVOC_CMP_VPU_VSYNC_POLARITY               37
/// \brief This parameter sets the video output unit horizontal sync polarity.
/// \param value 0 = active high, 1 = active low.
///
#define Q_AVOC_CMP_VPU_HSYNC_POLARITY               38
/// \brief This parameter sets the video output unit RGB dither enable.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_VPU_DITHER_ENABLE                39
/// \brief This parameter sets the video output unit even line select 2 in LCD mode.
/// \param value 0 = Red, 1 = Green, 3 = Blue.
///
#define Q_AVOC_CMP_VPU_ECS_2                        40
/// \brief This parameter sets the video output unit even line select 1 in LCD mode.
/// \param value 0 = Red, 1 = Green, 3 = Blue.
///
#define Q_AVOC_CMP_VPU_ECS_1                        41
/// \brief This parameter sets the video output unit even line select 0 in LCD mode.
/// \param value 0 = Red, 1 = Green, 3 = Blue.
///
#define Q_AVOC_CMP_VPU_ECS_0                        42
/// \brief This parameter sets the video output unit odd line select 2 in LCD mode.
/// \param value 0 = Red, 1 = Green, 3 = Blue.
///
#define Q_AVOC_CMP_VPU_OCS_2                        43
/// \brief This parameter sets the video output unit odd line select 1 in LCD mode.
/// \param value 0 = Red, 1 = Green, 3 = Blue.
///
#define Q_AVOC_CMP_VPU_OCS_1                        44
/// \brief This parameter sets the video output unit odd line select 0 in LCD mode.
/// \param value 0 = Red, 1 = Green, 3 = Blue.
///
#define Q_AVOC_CMP_VPU_OCS_0                        45
/// \brief This parameter sets the video output unit output format.
/// \param value 0 = YCbCr 8-bit CCIR656 4:2:2 output with multiplexed Y and C.\n
///              1 = YCbCr 16-bit SMPTE274/296 4:2:2 output with separate Y and C.\n
///              2 = YCbCr 24-bit 4:4:4 output with separate Y, Cb and Cr.\n
///              3 = RGB output with 1 clock/pixel.\n
///              4 = RGB output with 3 clock/pixel.\n
///              5 = 16 bit RGB 565.\n
///              6 = 18 bit RGB 666.\n
///              7 = 24 bit RGB.\n
///
#define Q_AVOC_CMP_VPU_FORMAT                       46
/// \brief This parameter sets the video output unit chroma filter mode.
/// \param value 0 = chroma filter enable, 1 = chroma filter disable.
///
#define Q_AVOC_CMP_VPU_FILTER_BYPASS                47
/// \brief This parameter sets the video output unit EAV/SAV code generation.
/// \param value 0 = EAV/SAV codes enable, 1 = EAV/SAV codes disable.
///
#define Q_AVOC_CMP_VPU_CODE_DISABLE                 48
/// \brief This parameter sets the video output unit in sync mode.
/// \param value 0 = Master, 1 = Slave.
///
#define Q_AVOC_CMP_VPU_EXTERNAL_SYNC                49
/// \brief This parameter sets the video output unit progressive interface enable.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_VPU_PROGRESSIVE_IF               50
/// \brief This parameter sets the number of output ticks per video output interrupt.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_OUTPUT_TICKS                 51
/// \brief This parameter sets the background color of the video output unit.
/// \param value [24:31] Y component of color.\n
///              [16:23] Cb component of color.\n
///              [8:15]  Cr component of color.\n
///              [0:7]   Reserved.\n
///
#define Q_AVOC_CMP_VPU_BG_COLOR                     52
/// \brief This parameter must be set to 1 for 1080i output and 0 for other modes.
/// \param value 1 for 1080i output, 0 for other modes.
///
#define Q_AVOC_CMP_VPU_EXTEND_FIELD                 53
/// \brief This parameter allows the video compositor to do fractional rendering. If the output
///        frame rate is 60 fps a divider of 1 will set the video compositor to render at 60 fps.
///        If the divider is set to 2 the video compositor will render at 30 fps.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_COMP_RATE_DIVIDER          54
/// \brief This parameter sets the horizontal aspect ratio of the video compositor buffer.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_COMP_PIXEL_AR_X            55
/// \brief This parameter sets the vertical aspect ratio of the video compositor buffer.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_COMP_PIXEL_AR_Y            56
/// \brief This parameter sets video compositor output field order. This only affects interlaced
///        video output modes. This also affects the field order of the frames sent to the output
///        port if they are interlaced.
/// \param value 1 = Bottom field first, 0 = Top field first.
///
#define Q_AVOC_CMP_VID_0_COMP_BFF                   57
/// \brief This parameter sets video compositor output port enable. When enabled the composited
///        frames will be sent. This allows the composited frames to be processed and encoded.
/// \param value 1 = Enable, 0 = Disable.
///
#define Q_AVOC_CMP_VID_0_COMP_OUTPUT_PORT_ENABLE    58
/// \brief This parameter can be used to adjust the sets video display latency. Setting it to
///        a low value will result in a maximum display latency of 1 frame/field time. Setting
///        to a larger value will decrease the display latency. A value too large will cause
///        the system to be unstable. The value should be even.
/// \param value Min = 8, Max = Total output lines - ISR processing time.
///
#define Q_AVOC_CMP_VID_ISR_LATENCY_OFFSET_LINES     59
/// \brief This parameter sets the channel id feature to be enabled.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_VID_CHANNEL_ID_ENABLE            60
/// \brief This parameter sets the channel id interleave type.
/// \param value Refer to channel id documentation.
///
#define Q_AVOC_CMP_VID_CHANNEL_ID_INTERLEAVE_TYPE   61
/// \brief This parameter enables or disables compositor interleave video output.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_VID_0_COMP_INTERLEAVE_OUTPUT_ENABLE  62
/// \brief This parameter sets the maximum number of channels in compositor interleave video output mode.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_COMP_INTERLEAVE_OUTPUT_CH_MAX  63
/// \brief This parameter enables or disables compositor to use a video channel as the background
///        frame buffer. Use OUT_CFG_VID_0_COMP_BYPASS_CHANNEL to set background channel.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_VID_0_COMP_USE_VIDEO_BG          64
/// \brief This parameter sets the video channel fast scale mode. This is needed when the pixel
///  clock is very high.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_VID_0_FAST_SCALE_MODE            65
/// \brief This parameter sets the compositor front to back rendering mode.
/// \param value 0 = Disable, 1 = Enable.
///
#define Q_AVOC_CMP_VID_0_COMP_F2B_MODE              66
/// \brief This parameter sets the render threshold in compositor front to back rendering mode.
///        The value should be set on a case by case basis.
/// \param value Integer number.
///
#define Q_AVOC_CMP_VID_0_COMP_F2B_RENDER_THRESHOLD  67


//////////////////////////////////////////////////////////////////////
//
// Configuration parameter values
//
#define Q_AVOC_CFP_AUD_MONO_L                        0
#define Q_AVOC_CFP_AUD_MONO_R                        1
#define Q_AVOC_CFP_AUD_STEREO                        2

// Generated from mediaware.h AUD_MASTER_CLOCK s/^/Q_AVOC_CFP_/
#define Q_AVOC_CFP_AUD_MASTER_CLOCK_256FS            0
#define Q_AVOC_CFP_AUD_MASTER_CLOCK_512FS            1

// Generated from mediaware.h AUD_SERIAL_MODE s/^/Q_AVOC_CFP_/
#define Q_AVOC_CFP_AUD_SERIAL_MODE_I2S               0
#define Q_AVOC_CFP_AUD_SERIAL_MODE_LEFT_JUSTIFIED    1
#define Q_AVOC_CFP_AUD_SERIAL_MODE_RIGHT_JUSTIFIED   2

#endif

/// \}
