/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


/// \defgroup AudioFilter Audio PCM Processing Filter
/// \{

/// \page audfltr Audio PCM Processing Filter
/// \latexonly
/// \chapter{Audio PCM Processing Filter}
/// \input{audfltr}
/// \endlatexonly
///
/// \section audfltrstatus Status Block
///
/// The Audio Filter status block contains the current status and performance.
/// \latexonly
/// \input{structAUDFLTR__STATUS}
/// \endlatexonly

#ifndef __QAUDFLTR_H
#define __QAUDFLTR_H

//////////////////////////////////////////////////////////////////////
//
// Commands
//

/// \brief This command adds a new input port to the audio filter. Audio filter
///        supports multiple input ports. This command returns a new input port ID
///        that the application should then use to bind with an input source 
///        object by using the Q_AUDFLTR_CMD_SET_INPUT_PORT_SOURCE command.
/// \return input port ID
#define Q_AUDFLTR_CMD_ADD_INPUT_PORT 1

/// \brief This command sets an allocated input port to a specified source object. SAIN
///        and AVDEC objects are supported. Multiple and different types of source
///        objects can be added to a single audio filter object. 
/// \param ch The input port ID value returned by the Q_AUDFLTR_CMD_ADD_INPUT_PORT command
/// \param src The source object
#define Q_AUDFLTR_CMD_SET_INPUT_PORT_SOURCE 2

/// \brief This command sets a value in the filter's configuration array. The configuration
///        is stored in double buffered array of 32 bit parameters, listed in the 
///        Q_AUDFLTR_CMP_ defines. This API sets entries in the inactive array. They will
///        have no effect until the Q_AUDFLTR_CMD_ACTIVATE_CFG command is sent. This allows
///        many parameters to be set sequentially but take effect at the same time.
#define Q_AUDFLTR_CMD_SET_PARAM 3

/// \brief Activate any changed settings in the configuration array.  
#define Q_AUDFLTR_CMD_ACTIVATE_CFG 4

/// \brief Begin filtering using the currently set and activated parameters.
#define Q_AUDFLTR_CMD_START 5

/// \brief Stop filtering.
#define Q_AUDFLTR_CMD_STOP 6

/// \brief Setup the output port's threshold.
/// \param port The output port ID.
/// \param threshold The output port's threshold
#define Q_AUDFLTR_CMD_SET_OUTPUT_PORT 7

#define Q_AUDFLTR_MAX_CMD 8

///////////////////////////////////////////////////////////////////////
//
// Command Payloads
//
typedef struct {
} STRUCT_Q_AUDFLTR_CMD_ADD_INPUT_PORT;

typedef struct {
    int inPort;
    int objId;
    int threshold;
} STRUCT_Q_AUDFLTR_CMD_SET_INPUT_PORT_SOURCE;

typedef struct {
    unsigned int param;
    int value;
} STRUCT_Q_AUDFLTR_CMD_SET_PARAM;

typedef struct {
    int port;
    int threshold;
} STRUCT_Q_AUDFLTR_CMD_SET_OUTPUT_PORT;

//////////////////////////////////////////////////////////////////////
//
// Command Parameter Values
//
// Generated from mediaware.h AUDIO_FILTER_TYPE s/AUDIO_FILTER/Q_AUDFLTR_CFP/
/// \brief The NULL filter trashes all input audio frames. Mainly used for testing.
///
#define Q_AUDFLTR_CFP_TYPE_NULL                      0
/// \brief The All-Pass filter copies all input audio frames from the input
///        ports to the output ports. Mainly used for testing.
///
#define Q_AUDFLTR_CFP_TYPE_ALLPASS                   1
/// \brief The Rate-Converstion filter does audio resampling. It supports both
///        up-sampling and down-sampling. 
///
#define Q_AUDFLTR_CFP_TYPE_RATECONVERSION            2
/// \brief The Slippage Control filter is created when AVSN needs to do audio resampling.
///        It is inserted between an audio decoder and an AVSN object.
///
#define Q_AUDFLTR_CFP_TYPE_SLIPPAGECONTROL           3
/// \brief Reserved.
///
#define Q_AUDFLTR_CFP_TYPE_NUMS                      4

//////////////////////////////////////////////////////////////////////
//
// Configuration parameters
//
// Generated from mediaware.h AUDFLTR_CFG s/AUDFLTR_CFG/Q_AUDFLTR_CMP/
/// \brief This parameter sets the max number of input ports of the audio filter.
///
#define Q_AUDFLTR_CMP_MAX_INPUT_PORTS                0
/// \brief This parameter sets the desired sampling frequency of the output of the rate converter.
///
#define Q_AUDFLTR_CMP_RATE_CONV_OUT_FREQ             1
/// \brief This parameter sets the number of samples per frame in the output of the rate converter.
///
#define Q_AUDFLTR_CMP_RATE_CONV_OUT_FRAME_NUM_SAMPLES   2
/// \brief This parameter sets the sampling frequency for the incoming pcm data.
///
#define Q_AUDFLTR_CMP_RATE_CONV_IN_FREQ              3
/// \brief This parameter sets the number of channels.
///
#define Q_AUDFLTR_CMP_RATE_CONV_NUM_CHANNELS         4
/// \brief This parameter sets the number of samples per frame in the input to the rate converter.
///
#define Q_AUDFLTR_CMP_RATE_CONV_IN_FRAME_NUM_SAMPLES   5
#define Q_AUDFLTR_CMP_SLIPPAGE_RATIO                 6

/// \}

#endif




