/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


/// \defgroup MultiChannelAudioSplitter Multi-channel Audio Splitter
/// \{

/// \page asplit Multi-channel Audio Splitter
/// \latexonly
/// \chapter{Multi-channel Audio Splitter}
/// \input{asplit}
/// \endlatexonly
///

#ifndef __QASPLIT_HH
#define __QASPLIT_HH

#include "qglobal.h"

//////////////////////////////////////////////////////////////////////
//
// Commands
//

/// \brief This command is used to set a double-buffered parameter.  Note at this time
/// the object has no parameters and this command is for future expansion.
#define Q_ASPLIT_CMD_SET_PARAM               1
/// \brief This command is used to activate all pending parameter sets.  Note at this time
/// the object has no parameters and this command is for future expansion.
#define Q_ASPLIT_CMD_ACTIVATE_CFG            2
/// \brief This command is used to bind the object to an upstream object that can produce
/// a raw PCM stream such as a StereoAudioInput object.
#define Q_ASPLIT_CMD_BIND_AUDIO_INPUT        3
/// \brief This command is used to unbind the object from the upstream producer.
#define Q_ASPLIT_CMD_UNBIND_AUDIO_INPUT      4

#define Q_ASPLIT_MAX_CMD                     5

///////////////////////////////////////////////////////////////////////
//
// Command Payloads
// 

typedef struct
{
    unsigned int param;
    int value;
} STRUCT_Q_ASPLIT_CMD_SET_PARAM;

typedef struct
{
    int objId;
} STRUCT_Q_ASPLIT_CMD_BIND_AUDIO_INPUT;


//////////////////////////////////////////////////////////////////////
//
// Command Parameter Values
//
// Generated from mediaware.h AUD_SPLIT_MODE s/AUD_SPLIT/Q_ASPLIT_CFP/
#define Q_ASPLIT_CFP_MODE_16BIT_IN_16BIT_OUT         0
#define Q_ASPLIT_CFP_MODE_8BIT_IN_8BIT_OUT           1
#define Q_ASPLIT_CFP_MODE_8BIT_IN_16BIT_OUT          2
#define Q_ASPLIT_CFP_MODE_12BIT_IN_16BIT_OUT         3


//////////////////////////////////////////////////////////////////////
//
// Configuration parameters
//


//////////////////////////////////////////////////////////////////////
//
// Configuration parameter values
//


/// \}
#endif
