/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


#ifndef __HVOUT_FRAME_H
#define __HVOUT_FRAME_H

typedef struct
{
/// \brief Accumulates Luma motion between entire pictures one frame time apart
    unsigned int GPictYMot;
/// \brief Accumulates Chroma motion between entire pictures one frame time apart
    unsigned int GPictCMot;
/// \brief Reports maximum Luma motion of one pixel in an entire picture
    unsigned int GPictYMotMax;
/// \brief Reports maximum Chroma motion of one pixel in an entire picture
    unsigned int GPictCMotMax;
/// \brief Reports total sum of all Luma pixels in the entire
    unsigned int GPictYSum;
/// \brief Reports total sum of all Chroma pixels in the entire
    unsigned int GPictCSum;
/// \brief Reports sum of horizontal high frequency Luma information for the entire picture
    unsigned int GPictYHorzHighFreq;
/// \brief Reports sum of vertical high frequency Luma information for the entire picture
    unsigned int GPictYVertHighFreq;
/// \brief Reports sum of vertical high frequency Chroma information for the entire picture
    unsigned int GPictCHighFreq;
/// \brief Counts how many macroblocks had any Luma high frequency information. 
///  The hardware averages horizontal and vertical Luma high frequencies for each macroblock.
///  This value reflects the size of the non-zero two-dimensional high frequency information.
    unsigned int GPictYHighFreqSize;
/// \brief Counts how many macroblocks had any Chroma high frequency information. 
///  The hardware detects chroma high frequency for each macroblock.
///  This value reflects the size of the non-zero high frequency information.
    unsigned int GPictCHighFreqSize;
/// \brief Counts how many macroblocks had any Luma spatial edge information. 
/// The only macroblocks not counted are those with null strength information.
/// This register reflects the size of the spatial Luma edge content of the picture.
    unsigned int GPictYEdgeSize;
/// \brief Counts how many macroblocks had any Luma Motion edge information.
/// The only macroblocks not counted are those without Luma Motion direction and strength information. 
/// This register reflects the size of the temporal Luma edge content of the picture.
    unsigned int GPictMEdgeSize;
/// \brief Provides the sum of MB averages for all macroblock luma edge strengths in the picture. 
    unsigned int GPictEdgeStrengthMBSum;
/// \brief Provides the sum of MB averages for all macroblock luma motion edge strengths in the picture. 
    unsigned int GPictMotEdgeStrengthMBSum;
/// \brief Total sum of pixels classified as having Color[0-3].
    unsigned int GPictColorSum[4];
/// \brief Counts how many macroblocks had any Color[0-3] information. 
/// The only macroblocks not counted are those without Color[0-3] information. 
/// This register reflects the size of areas of the picture in Color[0-3].
    unsigned int GPictColorSize[4];
/// \brief Keeps the sum of similarity values for Region[0-7] over the entire picture.
/// The similarity values denote membership of a macroblock to a particular region. 
/// This register reflects the strength of a region[0-7] qualified by a set of features.
    unsigned int GPictRegionStrength[8];
/// \brief Counts how many macroblocks belong to Region[0-7].
/// This register reflects the size of a region qualified by a set of features.
    unsigned int GPictRegionSize[8];
/// \brief Reports the number of macroblocks in Region[0-7] that are dominant with respect to the other regions. 
/// Region 7 is not included when programmed for MBAFF.
/// A dominant macroblock in a region is defined as the one that has the highest similarity value for said region, 
/// i.e., it is more strongly associated to its neighbors in the current region than in the other regions.
/// This register reflects the size of a region qualified by a non-overlapping set of features that are dominant with respect to the other regions.
/// If the hardware detects a tie in similarity values among the regions, the macroblock is added to the size of the 
/// region with the lowest index, except when all similarity values are ZERO (i.e. the macroblock does not belong to any region).
    unsigned int GPictRegionSizeDom[8];
} FieldStatRegs;

typedef struct
{
    /// \brief The address in the memory where the PME vectors are stored. The address is an offset in bytes from the starting location of the codec partition.
    /// The PME motion vectors can be generated for the encoder, digital image stabilization or object tracking. The vectors generated for these tasks are stored at 
    /// offsets of PMEVectorSize starting at location PMEVectorAddress.
    unsigned int    PMEVectorAddress;
    unsigned int    PMEVectorPartBase;
    unsigned int    PMEVectorOffset;
    /// \brief The size of the motion vectors for each picture.
    unsigned int    PMEVectorSize;
    /// \brief This flag indicates whether the PME vectors were generated from the encoder, DIS or the Object Tracking module.  
    /// 0: Vectors are not valid.  
    /// 1: Vectors are generated from the encoder.  
    /// 2: Vectors are generated from the Object Tracking Module.  
    /// 3: Vectors are generated from the Object Tracking Module, but are vector median filtered. 
    unsigned int    PMEVectorType;
    /// \brief The macroblock width of the picture on which PME was performed. The macroblock size is defined in 8x8 blocks.
    /// The actual width of the picture in pixels is performed by multiplying mbWidth by 8.
    unsigned int    mbWidth;
    /// \brief The macroblock height of the picture on which PME was performed. The macroblock size is defined in 8x8 blocks.
    /// The actual height of the picture in pixels is performed by multiplying mbHeight by 8.
    unsigned int    mbHeight;
    unsigned int    PictStr;
    /// \brief The resultsMV indicates the type of sub-macroblocks the motion estimation has been performed for.
    ///    0=8x8.     		The results are generated for only 8x8 macroblocks.  
    ///    1=8x8,8x4. 		The results are generated for 8x8 and 8x4 macroblocks.  
    ///    2=4x4.     		The results are generated for only 4x4 macroblocks.   
    ///    3=8x8,8x4,4x8,4x4	The results are generated for 8x8, 8x4, 4x8 and 4x4 MB's.	
    unsigned int    ResultsMV;
    /// \brief The flag MCost indicates whether the motion cost is saved along with the motion vectors.
    unsigned int    MCost;
    /// \brief The total num of references used for motion estimation.
    unsigned int    NumRef;
    /// \brief This indicates the reference frame from List 0 used for motion estimation. The value represents a delta in the Picture Order Count.
    unsigned int    Refid0;
    /// \brief This indicates the reference frame from List 1 used for motion estimation. The value represents a delta in the Picture Order Count.
    unsigned int    Refid1;
} PMEVecTag;

typedef struct
{
    /// \brief The captured width of the video sequence out of the video pre-processor. The video sequence is padded to a
    /// multiple of 16 in case the dimensions are not a multiple of 16. 
    /// The encoding width of the sequence might differ from the captured width. The width of the captured
    /// sequence is used to figure out the stride for statistics generation, width of the PME downscaled image etc.
    unsigned int    width;
    /// \brief The captured height of the video sequence out of the video pre-processor. 
    /// The encoding height of the sequence might differ from the captured height. The height of the captured
    /// sequence is used to figure out the stride for statistics generation, height of the PME downscaled image etc.
    unsigned int    height;
    /// \brief This address provides the location of the luma plane of the captured video frame. The address is an offset in bytes from the 
    /// starting location of the codec partition.
    unsigned int    lumaAddress;
    /// \brief This address provides the location of the chroma plane of the captured video frame. The address is an offset in bytes from the 
    /// starting location of the codec partition.
    unsigned int    chromaAddress;

    /// \brief The width of the downscaled luma frame use for Pre Motion Estimation(PME).
    unsigned int    widthPME;
    /// \brief The height of the downscaled luma frame use for Pre Motion Estimation(PME).
    unsigned int    heightPME;
    /// \brief This address provides the location of the luma plane of the downscaled image for PME. The address is an offset in bytes from the 
    /// location of the codec partition.
    unsigned int    lumaAddressPME;

    /// \brief This flag indicates whether the processing in the VPP was done in interlaced mode or progressive mode.
    unsigned int    interlaced;
    /// \brief The pointer to the structure containing the global statistics for the top field.
    FieldStatRegs * globalStatTop;
    /// \brief The pointer to the structure containing the global statistics for the bottom field.
    FieldStatRegs * globalStatBot;
    /// \brief This address provides the location of the macroblock statistics in the memory. The address is an offset in bytes from the starting
    /// of the codec partition.
    unsigned int    statAddress;
    /// \brief This address provides the location of the region statistics in the memory. address is an offset in bytes from the starting
    /// of the codec partition.
    unsigned int    regionAddress;

    /// \brief The address in the memory where the PME vectors are stored. The address is an offset in bytes from the starting location of the codec partition.
    /// The PME motion vectors can be generated for the encoder, digital image stabilization or object tracking. The vectors generated for these tasks are stored at 
    /// offsets of PMEVectorSize starting at location PMEVectorAddress.
    unsigned int    PMEVectorAddress;
    /// \brief The size of the motion vectors for each picture.
    unsigned int    PMEVectorSize;
    /// \brief The tags describe the format of the PME motion vectors.
    PMEVecTag       PMEVectorTag[4];

    /// \brief The address in the memory where the MBAFF decisions as calculated by the PME are stored.
    ///  The address is an offset in bytes from the starting location of the codec partition.
    unsigned int    PMEMBAFFAddress;
    /// \brief The size of the MBAFF decisions in the memory. The address is an offset in bytes from the 
    unsigned int    PMEMBAFFSize;
    
    /// \brief The encoding width of the video frame. The encoding width is the final width of the picture that needs to be rendered.
    unsigned int    FrameCropW;
    /// \brief The encoding height of the video frame. The encoding height is the final height of the picture that needs to be rendered.
    unsigned int    FrameCropH;
    /// \brief The top left x coordinate of the crop rectangle in the video frame captured using the video pre-processor. 
    unsigned int    FrameCropX;
    /// \brief The top left y coordinate of the crop rectangle in the video frame captured using the video pre-processor. 
    unsigned int    FrameCropY;
    
    /// \brief The upper 32 bits of the PTS of the current frame
    unsigned int    VideoPTSHi;
    /// \brief The lower 32 bits of the PTS of the current frame
    unsigned int    VideoPTSLo;

    unsigned int    debugCaptureAddress;
    unsigned int    debugCaptureSize;
    unsigned int    debugCaptureBufferSize;
} HVOutFrame;

#endif // __HVOUT_FRAME_H
