#!/bin/sh

DEV=$1
DEVFILE=/dev/${DEV}

echo -ne "un-mounting device ${DEV} ... ";

# First check if the device is mounted.
# If it is we mount it in the mount point specified there
if [ "X$(mount | grep -c ${DEVFILE})" != "X0" ]; then
    MOUNT_POINT=$(mount | grep ${DEVFILE} | sed -e 's|${DEVFILE}[ \t]*on[ \t]*\([^ \t]*\)[ \t]*.*|\1|');
    /bin/umount ${DEVFILE};
    if [ "X$?" != "X0" ]; then 
        echo -ne "error, could not un-mount device\n";
        exit 1; 
    fi
    if [ "X$(grep -c ${DEVFILE} /etc/fstab)" = "X0" ]; then
        rm -r ${MOUNT_POINT};
        if [ "X$?" != "X0" ]; then 
            echo -ne "error, could not remove mountpoint\n";
            exit 2; 
        fi
    fi
fi            

echo -ne "done\n";
exit 0;
