#!/bin/sh

# Mount /proc, needed by modprobe
if [ ! -d /proc ]; then
	/bin/mkdir -p /proc;
	# If it fails, mount will fail
fi
/bin/mount none /proc -t proc;
if [ "X$?" != "X0" ]; then
	echo "WARNING: failed to mount /proc, the system may not work properly because of it.";
fi
# Mount sys
if [ ! -d /sys ]; then
	/bin/mkdir -p /sys;
	# If it fails, mount will fail
fi
/bin/mount none /sys -t sysfs;
if [ "X$?" != "X0" ]; then
	echo "WARNING: failed to mount /sys, the system may not work properly because of it.";
fi
