/**spi.h
 * Header for an SPI library based on Mobilygen GPIO driver for Linux
 */
 
/*******************************************************************************
* 
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
* 
* Copyright 2005 Mobilygen Corporation.
* All rights reserved.
* 
* QuArc is a registered trademark of Mobilygen Corporation.
* 
*******************************************************************************/

#include <stdio.h>

#ifndef __SPI_H
#define __SPI_H

#define SPI_SUCCESS         0       /* ok */
#define SPI_ERR_BADPARAM    (-1)    /* bad parameter sent to the API or in bus config */
#define SPI_ERR_NODEV       (-2)    /* device can't be accessed */
#define SPI_ERR_BUSY        (-3)    /* device already in use */
#define SPI_ERR_MEM         (-4)    /* not enough memory */
#define SPI_ERR_IO          (-5)    /* IO error */
#define SPI_ERR_HANDLE      (-6)    /* Bad handle */

/* No one should modify a handle or what is inside */
typedef int spi_handle_t;

#ifdef    __cplusplus
extern "C" {
#endif /* __cplusplus */

/**spi_open
 * Return a handler to the SPI library
 * MUST be called before any other API
 * \param   device  Device to open ("/dev/...")
 * \return  handle that caller should use with other libspi APIs if >0, error otherwise
 * \note    A device can't be opened twice at the same time
 */
spi_handle_t spi_open(char * device);
 
/**spi_write
 * Write to the device
 * \param   handle  spi_open return value
 * \param   data    bitstream to send to device 1 bit per bits
 * \param   nBits   total number of bits to send
 * \return Number of bits wrote
 */
int spi_write(spi_handle_t handle,const char *data,int nBits);
 
 /**spi_read
 * Read the device
 * \param   handle  spi_open return value
 * \param   data    bitstream to receive from device 1 bit per bits
 * \param   nBits   total number of bits to receive
 * \return Number of bits received
 */
int spi_read(spi_handle_t handle,char *data,int nBits);

/**spi_access
 * Full duplex access
 */
int spi_access(spi_handle_t handle, const char *wdata, char *data, int nBits);
 
 /**spi_set_speed
 * Sets transfer speed in Hz
 */
int spi_set_speed(spi_handle_t handle, unsigned long hz);
 
/**spi_close
 * Close device and free allocated ressources
 * \param   handle  spi_open return value
 * \return SPI_SUCCESS if ok
 */
int spi_close(spi_handle_t handle);

#ifdef    __cplusplus
}
#endif /* __cplusplus */

#endif /* ifndef __SPI_H */
