/*
 * Copyright (C) 2009 Maxim IC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _LIBQCC_H
#define _LIBQCC_H

/* need these before including qccdev.h */
typedef unsigned char   uint8_t;
typedef unsigned short  uint16_t;
typedef unsigned int    uint32_t;

#include <linux/qccdev.h>

#define QCC_SUCCESS     (0)    /* success */
#define QCC_ERR_OPEN    (-1)   /* cannot open device */
#define QCC_ERR_WRITE   (-2)   
#define QCC_ERR_READ    (-3)   

extern int qcc_open(void); 
extern void qcc_close(int fd); 
extern int qcc_write(int rd, 
		uint8_t bid, uint16_t offset, uint32_t data, uint8_t size);
extern int qcc_read(int fd, 
		uint8_t bid, uint16_t offset, uint32_t *data, uint8_t size);
extern int qcc_write_block(int fd,
		struct qcc_cmd_def *cmds, int count);

#endif /* ifndef _LIBQCC_H */
