/*
 * arch/arm/plat-mgx/include/mach/mobi_clock.h
 *
 * Copyright (C) 2006 Mobilygen Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ARCH_ARM_PLAT_MGX_CLOCK_API_H
#define __ARCH_ARM_PLAT_MGX_CLOCK_API_H

#include <mach/clock_ids.h>

/**
 * \brief mobi_clock_get_rate:
 * 	Get the current output frequency of a clock
 *
 * \param clk_id  : id of the clock that an app is interested in.
 *
 * \retval zero   - if unable to determine frequency or invalid clk_id is given
 * \retval "freq" - a number greater than zero that is the
 * 		    frequency of the clock.
 *
 * \remark
 * 	Just to be clear, a return value of 0 is an indication
 * that something when wrong when trying to determing the
 * frequency of the clock.
 */
unsigned long mobi_clock_get_rate(clock_id_t clk_id);

/**
 * \brief mobi_clock_set_rate
 * 	Set the frequency of a clock.
 *
 * \param clk_id  : id of the clock that an app is interested in.
 * \param freq    : new frequency for the the clock
 *
 * \retval -EINVAL  - if invalid clk_id is given
 * \retval -EIO	   - if an error was encounted programming new freqency
 * \return Zero	   - upon success
 *
 * \remark
 * 	Passing in a frequency of '0' will disable the clock.
 */
int32_t mobi_clock_set_rate(clock_id_t clk_id, unsigned long freq);

#ifdef CONFIG_ARCH_FALCON
/**
 * \brief mobi_gated_clock_enable
 * 	 Enable a gated clock
 *
 * \param clk_id  : id of the gated clock to enable
 *
 * \retval -EINVAL  - if invalid gclk_id is given
 * \retval -EIO	   - if an error was encounted programming new state
 * \return Zero	   - upon success
 *
 */
int32_t mobi_gated_clock_enable(gated_clock_id_t gclk_id);

/**
 * \brief mobi_gated_clock_disable
 * 	 Disable a gated clock
 *
 * \param clk_id  : id of the gated clock to disable
 *
 * \retval -EINVAL  - if invalid gclk_id is given
 * \retval -EIO	   - if an error was encounted programming new state
 * \return Zero	   - upon success
 *
 */
int32_t mobi_gated_clock_disable(gated_clock_id_t gclk_id);

/**
 * \brief mobi_gated_clock_state
 * 	 State a gated clock
 *
 * \param clk_id  : id of the gated clock to query
 *
 * \retval -EINVAL  - if invalid gclk_id is given
 * \retval -EIO	   - if an error was encounted querying
 * \return One	   - if clock is enabled
 * \return Zero	   - if clock is disabled
 *
 */
int32_t mobi_gated_clock_state(gated_clock_id_t gclk_id);

#endif
#endif
