/*
 *  linux/include/asm-arm/arch-merlin/uncompress.h
 *
 *  Copyright (C) 2006 Mobilygen Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_UNCOMPRESS_H
#define __ASM_ARCH_UNCOMPRESS_H

#include <asm/io.h>
#include <mach/hardware.h>
#include <mach/dw_uart_regs.h>
/*
 * The following code assumes the serial port has already been
 * initialized by the bootloader.  
 *
 * This does not append a newline
 */
static inline void putc(int c)
{
	void __iomem *uart = (void __iomem *) UARTDBG_BASE;

	while (!(__raw_readl(uart + MOBI_UART0_LSR_OFFSET) & MOBI_UART0_LSR_THRE_MASK))
		barrier();

	__raw_writel(c, uart + MOBI_UART0_THR_OFFSET);

}

static inline void flush(void)
{
	void __iomem *uart = (void __iomem *) UARTDBG_BASE;

	/* wait for transmission to complete */
	while (!(__raw_readl(uart + MOBI_UART0_LSR_OFFSET) & MOBI_UART0_LSR_THRE_MASK))
		barrier();
}

/*
 * nothing to do
 */
#define arch_decomp_setup()
#define arch_decomp_wdog()

#endif
