#ifndef MOBI_IOCTRL_H
#define MOBI_IOCTRL_H

#include <linux/types.h>

typedef enum {
	IOCTRL_GRP_SERIAL 	= 0,
	IOCTRL_GRP_SPI		= 1,
	IOCTRL_GRP_V01		= 2,
	IOCTRL_GRP_V23		= 3,
	IOCTRL_GRP_VIDEO0	= 4,
	IOCTRL_GRP_VIDEO1	= 5,
	IOCTRL_GRP_VIDEO2	= 6,
	IOCTRL_GRP_VIDEO3	= 7,
	IOCTRL_GRP_HOSTIF	= 8,
	IOCTRL_GRP_ETHERNET	= 9,
	IOCTRL_GRP_AUDIO	= 10,
	IOCTRL_GRP_SDMMC	= 11,
	IOCTRL_GRP_END
} ioctrl_groups_t;

typedef enum {
	IOCTRL_FUNC_DBG_UART	= 0,
	IOCTRL_FUNC_I2C_CFG	= 1,
	IOCTRL_FUNC_V23_MOSI	= 2,
	IOCTRL_FUNC_V23_MCLK	= 3,
	IOCTRL_FUNC_V01_MOSI	= 4,
	IOCTRL_FUNC_V01_MCLK	= 5,
	IOCTRL_FUNC_SPI_MOSI	= 6,
	IOCTRL_FUNC_SPI_MCLK	= 7,
	IOCTRL_FUNC_SPI_MSS0	= 8,
	IOCTRL_FUNC_SPI_MSS1	= 9,
	IOCTRL_FUNC_SPI_MASTER	= 10,
	IOCTRL_FUNC_END
} ioctrl_func_t;

typedef enum {
	/* FUNC_DBG_UART */
	IOCTRL_FUNC_ACTIVE_ARMDBG	= 0,
	IOCTRL_FUNC_ACTIVE_QMMDBG	= 1,

	/* FUNC_I2C_CFG */
	IOCTRL_FUNC_ACTIVE_I2CV01	= 0,
	IOCTRL_FUNC_ACTIVE_I2CV23	= 1,

	/* FUNC - V23_MOSI, V01_MOSI */
	IOCTRL_FUNC_ACTIVE_VXXMOSI	= 0,
	IOCTRL_FUNC_ACTIVE_SDA		= 1,

	/* FUNC - V23_MCLK, V01_MCLK */
	IOCTRL_FUNC_ACTIVE_VXXMCLK	= 0,
	IOCTRL_FUNC_ACTIVE_SCL		= 1,

	/* FUNC - SPI_MOSI */
	IOCTRL_FUNC_ACTIVE_SPIMOSI	= 0,
	IOCTRL_FUNC_ACTIVE_BS_DATA	= 1,

	/* FUNC - SPI_MCLK */
	IOCTRL_FUNC_ACTIVE_SPIMCLK	= 0,
	IOCTRL_FUNC_ACTIVE_BS_CLK	= 1,

	/* FUNC - SPI_MSS0 */
	IOCTRL_FUNC_ACTIVE_MSS0		= 0,
	IOCTRL_FUNC_ACTIVE_BS_ENABLE	= 1,

	/* FUNC - SPI_MSS1 */
	IOCTRL_FUNC_ACTIVE_MSS1		= 0,
	IOCTRL_FUNC_ACTIVE_BS_REQ	= 1,

	/* FUNC - SPI_MSS1 */
	IOCTRL_FUNC_ACTIVE_SPISLAVE	= 0,
	IOCTRL_FUNC_ACTIVE_SPIMASTER	= 1,

} ioctrl_func_active_t;

typedef enum {
	IOCTRL_SLEWRATE_SLOW		= 0,
	IOCTRL_SLEWRATE_DEFAULT		= 1,
	IOCTRL_SLEWRATE_FASTER		= 2,
	IOCTRL_SLEWRATE_FASTEST		= 3,
} ioctrl_slewrate_t;

typedef enum {
	IOCTRL_DRIVESTRENGTH_2ma	= 1,
	IOCTRL_DRIVESTRENGTH_4ma	= 2,
	IOCTRL_DRIVESTRENGTH_6ma	= 3,
	IOCTRL_DRIVESTRENGTH_8ma	= 4,
	IOCTRL_DRIVESTRENGTH_10ma	= 5,
	IOCTRL_DRIVESTRENGTH_12ma	= 6,
	IOCTRL_DRIVESTRENGTH_DEFAULT	= 2,
} ioctrl_drivestrength_t;

typedef enum {
	IOCTRL_GPIO_CONTROL_FUNCTION	= 0,
	IOCTRL_GPIO_CONTROL_PULLUP	= 1,
	IOCTRL_GPIO_CONTROL_PULLDOWN	= 2,
} ioctrl_gpiocontrol_t;

typedef enum {
	IOCTRL_GPIO_FUNCTION_PRIMARY	= 0,
	IOCTRL_GPIO_FUNCTION_GPIO	= 1,
} ioctrl_gpioselect_t;

typedef enum {
	IOCTRL_GPIO_PULLUP_DISABLED	= 0,
	IOCTRL_GPIO_PULLUP_ENABLED	= 1,
} ioctrl_gpiopullup_t;

typedef enum {
	IOCTRL_GPIO_PULLDOWN_DISABLED	= 0,
	IOCTRL_GPIO_PULLDOWN_ENABLED	= 1,
} ioctrl_gpiopulldown_t;

/* Macro stuff. */

struct ioctrl_macro_func_s {
	ioctrl_func_t 		func;
	ioctrl_func_active_t 	active;
};
#define IOCTRL_DECLARE_MACRO_FUNC(func_, active_) \
{ .func = func_, .active = active_ },
#define IOCTRL_DECLARE_MACRO_FUNC_END() { .func = IOCTRL_FUNC_END }

struct ioctrl_macro_gpio_s {
	const char		*name;
	uint32_t		gpio;
	ioctrl_gpioselect_t	sel;
	ioctrl_gpiopullup_t 	pu;
	ioctrl_gpiopulldown_t	pd;
};
#define IOCTRL_DECLARE_MACRO_GPIO_U(gpio_, sel_) \
{ .name = #gpio_, .gpio = gpio_, .sel = sel_, \
	.pu = IOCTRL_GPIO_PULLUP_ENABLED, .pd = IOCTRL_GPIO_PULLDOWN_DISABLED },
#define IOCTRL_DECLARE_MACRO_GPIO_D(gpio_, sel_) \
{ .name = #gpio_, .gpio = gpio_, .sel = sel_, \
	.pu = IOCTRL_GPIO_PULLUP_DISABLED, .pd = IOCTRL_GPIO_PULLDOWN_ENABLED },
#define IOCTRL_DECLARE_MACRO_GPIO_N(gpio_, sel_) \
{ .name = #gpio_, .gpio = gpio_, .sel = sel_, \
	.pu = IOCTRL_GPIO_PULLUP_DISABLED, .pd = IOCTRL_GPIO_PULLDOWN_DISABLED },
#define IOCTRL_DECLARE_MACRO_GPIO_END() { .gpio = -1 }

struct ioctrl_macro_s {
	const char 				*name;
	const struct 	ioctrl_macro_func_s	*func;
	const struct 	ioctrl_macro_gpio_s	*gpio;
};

/* API */
int mobi_ioctrl_get_gpio_bank_size(uint8_t bank);
int mobi_ioctrl_get_gpio_bankindex(uint32_t gpio, uint8_t *bank);

void mobi_ioctrl_set_macros(const struct ioctrl_macro_s *macros);
const struct ioctrl_macro_s *mobi_ioctrl_get_macro(const char *name);
int mobi_ioctrl_apply_macro(const struct ioctrl_macro_s *macro);
int mobi_ioctrl_macro_is_active(const struct ioctrl_macro_s *macro);

int mobi_ioctrl_get_gpio(uint32_t gpio, ioctrl_gpiocontrol_t ctrl);
int mobi_ioctrl_set_gpio(uint32_t gpio, ioctrl_gpiocontrol_t ctrl, uint8_t state);

int mobi_ioctrl_get_function(ioctrl_func_t func);
int mobi_ioctrl_set_function(ioctrl_func_t func, ioctrl_func_active_t active);

int mobi_ioctrl_set_slewrate(ioctrl_groups_t padgrp, ioctrl_slewrate_t slewrate);
int mobi_ioctrl_set_drivestrength(ioctrl_groups_t padgrp, ioctrl_drivestrength_t drivestrength);

#endif  /* MOBI_IOCTRL_H */
