#ifndef MG3500_DEVICES_H
#define MG3500_DEVICES_H

#include <linux/dw_watchdog_device.h>
#include <linux/dw_sdmmc_device.h>
#include <linux/dw_otg_device.h>
#include <linux/dw_gmac_device.h>
#include <linux/aumb3000_nand_device.h>
#include <linux/aumb4000_ide_device.h>
#include <linux/mobi_mhif_device.h>
#include <linux/i2c/dwapbi2c.h>
#include <linux/spi/dwapbssi.h>
#include <linux/cadpwm.h>
#include <linux/dwapbgpio.h>

#include <mach/mobi_hmux.h>

enum board_device_types {
	BOARD_DEVICE_NAND,
	BOARD_DEVICE_WATCHDOG,
	BOARD_DEVICE_SDMMC,
	BOARD_DEVICE_GMAC,
	BOARD_DEVICE_USB,
	BOARD_DEVICE_MHIF,
	BOARD_DEVICE_GPIO,
	BOARD_DEVICE_I2C,
	BOARD_DEVICE_SPI,
	BOARD_DEVICE_PWM,
	BOARD_DEVICE_PATA,
};

static char __attribute__((unused)) *board_device_types_names[] = {
	"NAND",
	"WATCHDOG",
	"SDMMC",
	"GMAC",
	"USB",
	"MHIF",
	"GPIO",
	"I2C",
	"SPI",
	"PWM",
	"PATA",
};

struct board_device_desc {
	enum board_device_types device;
	uint8_t devid;
	void *platform_data;
};

/* define chip_select and chip_enable for hmux config */
struct hmux_cfg {
	uint32_t ce;
	uint32_t cs;
};

/* contains all the config data for nand on a mg3500 */
struct nand_board_config_t {

	/* IP specific data passed to device driver */
	struct aumb3000_nand_device_data_t device_data;

	/* board/platform specific params */
	struct hmux_cfg hmux;
	uint8_t rsvd;
};

struct pata_board_config_t {
    
	/* IP specific data passed to device driver */
	struct aumb4000_device_data_t device_data;

	/* board/platform specific params */
	struct hmux_cfg hmux0;
	struct hmux_cfg hmux1;
};

struct sdmmc_board_config_t {
	struct dwc_sdmmc_device_data_t device_data;

	/* board specific data not passed to driver */
	uint8_t rsvd;
};

/* these devices follow a slighty cleaner model 
 * struct *_driver_data_t contains parameters that are only 
 * used in the device driver
 * other fields in the config_t struct are parameters that
 * can/might be used to program board/architecture specific
 * requirements, for example, the hmux chip selects.  the
 * params do not get passed onto the driver(currently this 
 * data is not in a seperate structure)
 */
struct mhif_board_config_t {

	struct mhif_driver_data_t mhif_data;

	/* 
	 * if device is larger than 0x800000 then we have
	 * to use a chip select as an address line since the
	 * mhif has a restriction that we can't use bit 24 
	 */
	struct hmux_cfg ce12_hmux;
	struct hmux_cfg ce13_hmux;

	/* board/platform specific params */
	int nor_attached;	
};

struct wdt_board_config_t {
	struct dw_wdt_driver_data_t wdt_data;
	/* board/platform specific params */
	uint8_t rsvd;
};

struct gmac_board_config_t {
	struct dw_gmac_driver_data_t gmac_data;
	/* board/platform specific params */
	uint8_t rsvd;
};

struct usb_board_config_t {
	struct dw_otg_driver_data_t otg_data;
	/* board/platform specific params */
	uint8_t rsvd;
};

int arch_add_board_devices(struct board_device_desc *board_devices, int num_devices);

#endif  /* MG3500_DEVICES_H */
