/*
 *  linux/include/asm-arm/arch-merlin/dma.h
 *
 *  Copyright (C) 2006 Mobilygen Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_DMA_H
#define __ASM_ARCH_DMA_H

#include <linux/dma-mapping.h>
#include <mach/platform.h>
#include <mach/mobi_dma.h>
#include <mach/dw_dmac_regs.h>

#define DMA_PROC_DIR          "drivers/dma"

#define DMA_NODE_IS_SRC		0x1
#define DMA_NODE_IS_DST		0x2

#define DMA_NODE_TYPE_MEM	0
#define DMA_NODE_TYPE_PER	1
#define DMA_NODE_TYPE_MHIF	2
#define DMA_NODE_TYPE_PERNOFC	3

// transfer type 
#define DMA_TRANS_TYPE_M2M	0
#define DMA_TRANS_TYPE_M2P	1
#define DMA_TRANS_TYPE_P2M	2
#define DMA_TRANS_TYPE_P2P	3

// flow control, can be determined if length of block is known
#define DMA_FC_DMAC		0   // m2m, m2p, p2m, p2p
#define DMA_FC_PER		1   // m2p, p2m
#define DMA_FC_SRCP		2   // source peripheral
#define DMA_FC_DSTP		3   // dest peripheral

/* ttfc field in ctl reg */
#define DMA_TTFC_M2M_DMAC	0x0
#define DMA_TTFC_M2P_DMAC	0x1
#define DMA_TTFC_P2M_DMAC	0x2
#define DMA_TTFC_P2P_DMAC	0x3
#define DMA_TTFC_P2M_PER	0x4
#define DMA_TTFC_P2P_SRCPER	0x5
#define DMA_TTFC_M2P_PER	0x6
#define DMA_TTFC_P2P_DSTPER	0x7

/* sinc & dinc in ctl reg */
#define DMA_ADDRADJ_INC 	0x0
#define DMA_ADDRADJ_DEC 	0x1
#define DMA_ADDRADJ_NONE 	0x2

/* msize field in ctl register */
#define DMA_BURST_SIZE_1	0x0
#define DMA_BURST_SIZE_4	0x1
#define DMA_BURST_SIZE_8	0x2
#define DMA_BURST_SIZE_16	0x3
#define DMA_BURST_SIZE_32	0x4
#define DMA_BURST_SIZE_64	0x5
#define DMA_BURST_SIZE_128	0x6
#define DMA_BURST_SIZE_256	0x7

#define DMA_HW_HANDSHAKING	0x0
#define DMA_SW_HANDSHAKING	0x1

#define DMA_TRWIDTH_8		0x0
#define DMA_TRWIDTH_16		0x1
#define DMA_TRWIDTH_32		0x2

#define DMAC_AHB_MASTER_1	0
#define DMAC_AHB_MASTER_2	1
#define DMAC_AHB_MASTER_3	2

#define DMAC_MUX0_MASK		0x1	// handshake #5
#define DMAC_MUX1_MASK		0x2	// handshake #6
#define DMAC_MUX2_MASK		0x4	// handshake #7
#define DMAC_MUX3_MASK		0x8	// handshake #8

/* see MMU Bridge microarchitecture document, pg 13 */
#define DMA_ENDIANESS_SWAP_MODE0	0x0	/* B3B2B1B0 -> B3B2B1B0 */
#define DMA_ENDIANESS_SWAP_MODE1	0x1	/* B3B2B1B0 -> B2B3B0B1 */
#define DMA_ENDIANESS_SWAP_MODE2	0x2	/* B3B2B1B0 -> B1B0B3B2 */
#define DMA_ENDIANESS_SWAP_MODE3	0x3	/* B3B2B1B0 -> B0B1B2B3 */
#define DMA_ENDIANESS_SWAP_NONE		0x0
#define MMU_BRIDGE_ENDIAN_SWAP_MASK	0x30000000
#define MMU_BRIDGE_ENDIAN_SWAP_SHIFT_L	28

#define DMAC_CHANNEL_NEEDS_MASTER_LOCK 		0x1
#define DMAC_CHANNEL_HAS_MASTER_LOCK 		0x2
#define DMAC_CHANNEL_USING_MASTER_1 		0x4
#define DMAC_CHANNEL_USING_MASTER_2 		0x8
#define DMAC_CHANNEL_USING_MASTER_MASK 		0xC

#define DMAC_CHANNEL_0		0
#define DMAC_CHANNEL_1		1
#define DMAC_CHANNEL_2		2
#define DMAC_CHANNEL_3		3

#define DMA_BUS_LOCK_TRANSFER 		0x0
#define DMA_BUS_LOCK_BLOCK		0x1
#define DMA_BUS_LOCK_TRANSACTION	0x2

// offsets in LLI block descriptor 
#define LLI_SAR_OFFSET		0x00
#define LLI_DAR_OFFSET		0x04
#define LLI_LLP_OFFSET		0x08
#define LLI_CTLL_OFFSET		0x0c
#define LLI_CTLH_OFFSET		0x10
#define LLI_BLOCK_DESCRIPTOR_SIZE	(5*sizeof(int32_t))

#define LLI_ALIGNMENT_MASK	0x3
#define LLI_ALIGNMENT_R		0x2

/* the number of dma channels available to the DMAC is a config
 * option, this way we could could reservere one if we really 
 * need to do something special(like enet chksum)
 */
#define MAX_DMAC_CHANNELS	CONFIG_MAX_DMAC_CHANNELS

#define MAX_DMA_BLOCK_SIZE 	4092

struct dmac_ctl_reg {
	uint32_t inten		: 1;
	uint32_t dtrwidth	: 3;
	uint32_t strwidth	: 3;
	uint32_t dinc		: 2;
	uint32_t sinc		: 2;
	uint32_t dmsize		: 3;
	uint32_t smsize		: 3;
	uint32_t gatheren	: 1;
	uint32_t scatteren	: 1;
	uint32_t ttfc		: 3;
	uint32_t dms		: 2;
	uint32_t sms		: 2;
	uint32_t llpdsten	: 1;
	uint32_t llpsrcen	: 1;
	uint32_t blockts	: 13;
	uint32_t done		: 1;
};

struct dmac_cfg_reg {
	uint32_t ch_prio	: 3;
	uint32_t ch_susp	: 1;
	uint32_t fifo_empty	: 1;
	uint32_t dhs_sel	: 1;
	uint32_t shs_sel	: 1;
	uint32_t lockch_level	: 2;
	uint32_t lockbus_level	: 2;
	uint32_t lockch		: 1;
	uint32_t lockbus	: 1;
	uint32_t dhs_pol	: 1;
	uint32_t shs_pol	: 1;
	uint32_t max_abrst	: 10;
	uint32_t sreload	: 1;
	uint32_t dreload	: 1;
	uint32_t fc_mode	: 1;
	uint32_t fifo_mode	: 1;
	uint32_t protctl	: 3;
	uint32_t ds_upd_en	: 1;
	uint32_t ss_upd_en	: 1;
	uint32_t src_per	: 4;
	uint32_t dst_per	: 4;
};

struct dmach_intr {
	struct dmach_intr	*next;
	mobi_dma_event		event;
};

#define EVENTQ_SIZE	32
struct dma_eventq {
	int num;
	int push_idx;
	int pop_idx;
	uint32_t events[EVENTQ_SIZE];
};

struct mobi_dma_channel {
	char name[40];
	int8_t	channel;
	int8_t	enabled;
	uint32_t options;
	void (*handler)(mobi_dma_handle, uint32_t, void*);
	void *data;
	struct dma_eventq eventq;
 
	/* the lli for multi block will be done the DTCM */
	void __iomem *lli_iomap;
	uint32_t lli_phys;
	uint32_t lli_size;
	int32_t max_blk_size;

	int blk_count;

	struct mobi_dma_list *mlist;
	uint32_t list_entries;

	uint32_t dma_length;
	uint8_t  masterbus;
	uint32_t transtype;
	uint32_t flowctrl;
	int8_t   datawidth;

	int8_t   error;

	uint32_t src_addr;
	uint32_t src_node_type;
	uint32_t src_flags;
	int32_t  src_dmacmux_device;
	uint32_t src_endianess;
	struct sg_params src_sgparams;

	uint32_t dst_addr;
	uint32_t dst_node_type;
	uint32_t dst_flags;
	int32_t  dst_dmacmux_device;
	uint32_t dst_endianess;
	struct sg_params dst_sgparams;

	/* endian bit mask ored in when want mmu to do endian swapping */
	uint8_t  endian_swap;

	/* apply to over xfer, like data_width and sg_enable */
	uint32_t xfer_flags;

	/* shadow regs */
	struct dmac_ctl_reg ctl;
	struct dmac_cfg_reg cfg;

	spinlock_t lock;
	struct work_struct intr_wq;
};
#endif
