#ifndef AUMB3000_NAND_DEVICE_H
#define AUMB3000_NAND_DEVICE_H

#define AUMB3000_NANDREG_AMBA_NAME   		"aumb3000-nandreg"
#define AUMB3000_NANDREG_AMBA_DEVID			0x00041110
#define AUMB3000_NANDREG_AMBA_DEVID_MASK	0x000fffff

#define AUMB3000_NANDDATA_AMBA_NAME  		"aumb3000-nanddata"
#define AUMB3000_NANDDATA_AMBA_DEVID		0x00041112
#define AUMB3000_NANDDATA_AMBA_DEVID_MASK	0x000fffff

#define NUMBER_NAND_TIMING_PARAMS	23
enum {
	/* timing register 0 */
	NAND_TIMING_TDS = 0, /* LSB */
	NAND_TIMING_TCS,
	NAND_TIMING_TALS,
	NAND_TIMING_TCLS,    /* MSB */
	/* timing register 1 */
	NAND_TIMING_TDH,
	NAND_TIMING_TCH,
	NAND_TIMING_TALH,
	NAND_TIMING_TCLH,
	/* timing register 2 */
	NAND_TIMING_TRR,
	NAND_TIMING_TWB,
	NAND_TIMING_TWH,
	NAND_TIMING_TWP,
	/* timing register 3 */
	NAND_TIMING_TCEH,
	NAND_TIMING_TRB,
	NAND_TIMING_TREH,
	NAND_TIMING_TRP,
	/* timing register 4 */
	NAND_TIMING_TIR,
	NAND_TIMING_TWHR,
	NAND_TIMING_TCLR,
	NAND_TIMING_TRDELAY,
	/* timing register 5 */
	NAND_TIMING_TAR,
	NAND_TIMING_TRHZ,
	NAND_TIMING_TWW /* 22 */
};

/* timing register 0 */
#define NAND_TIMING_TDS_SET			0x00000001
#define NAND_TIMING_TCS_SET			0x00000002
#define NAND_TIMING_TALS_SET		0x00000004
#define NAND_TIMING_TCLS_SET		0x00000008
/* timing register 1 */
#define NAND_TIMING_TDH_SET			0x00000010
#define NAND_TIMING_TCH_SET			0x00000020
#define NAND_TIMING_TALH_SET		0x00000040
#define NAND_TIMING_TCLH_SET		0x00000080
/* timing register 2 */
#define NAND_TIMING_TRR_SET			0x00000100
#define NAND_TIMING_TWB_SET			0x00000200
#define NAND_TIMING_TWH_SET			0x00000400
#define NAND_TIMING_TWP_SET			0x00000800
/* timing register 3 */
#define NAND_TIMING_TCEH_SET		0x00001000
#define NAND_TIMING_TRB_SET			0x00002000
#define NAND_TIMING_TREH_SET		0x00004000
#define NAND_TIMING_TRP_SET			0x00008000
/* timing register 4 */
#define NAND_TIMING_TIR_SET			0x00010000
#define NAND_TIMING_TWHR_SET		0x00020000
#define NAND_TIMING_TCLR_SET		0x00040000
#define NAND_TIMING_TRDELAY_SET		0x00080000
/* timing register 5 */
#define NAND_TIMING_TAR_SET			0x00100000
#define NAND_TIMING_TRHZ_SET		0x00200000
#define NAND_TIMING_TWW_SET			0x00400000

struct aumb3000_nand_device_data_t {

    unsigned char chips_per_bank;
    unsigned char banks_per_system;
    unsigned char databus_16bit;
    unsigned char use_dma;
	char clk_name[32];

	unsigned char board_timings[NUMBER_NAND_TIMING_PARAMS];
	unsigned int board_set_timing_bitmask;
};

#endif  /* AUMB3000_NAND_DEVICE_H */
