/*
* linux/include/asm-arm/arch-merlin/mobi_codec_reset.h
*
* Copyright (C) Mobilygen Corp
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_MOBI_CODEC_RESET_H
#define	__ASM_ARCH_MOBI_CODEC_RESET_H

struct codec_reset_device {
	const char *name;
	int (*suspend)(void*);
	int (*resume)(void*);
	void *data;
};

int32_t codec_reset_suspend_devices(void);
int32_t codec_reset_resume_devices(void);
int32_t codec_reset_device_register(struct codec_reset_device*);
int32_t codec_reset_device_unregister(struct codec_reset_device*);
/* call this to reset the codec ! */
int32_t mobi_codec_reset(void);

#endif	/* #ifndef __ASM_ARCH_MOBI_CODEC_RESET_H */
