#ifndef _GPIO_REG_H_
#define _GPIO_REG_H_

#include <linux/linux24-compat.h>

#define MERLIN_GPIO_0_BASE     0x88202800
#define MERLIN_GPIO_1_BASE     0x88202c00
#define MERLIN_GPIO_2_BASE     0x88203000

/*DW_APB_GPIO registers*/
/*register name    offset*/
#define MERLIN_GPIO_SWPORTA_DR        0x00
#define MERLIN_GPIO_SWPORTA_DDR       0x04
#define MERLIN_GPIO_PORTA_CTL         0x08
#define MERLIN_GPIO_INTEN             0x30
#define MERLIN_GPIO_INTMASK           0x34
#define MERLIN_GPIO_INTTYPE_LEVEL     0x38
#define MERLIN_GPIO_INT_POLARITY      0x3c
#define MERLIN_GPIO_INTSTATUS         0x40
#define MERLIN_GPIO_RAWINTSTATUS      0x44
#define MERLIN_GPIO_DEBOUNCE          0x48
#define MERLIN_GPIO_PORTA_EOI         0x4c
#define MERLIN_GPIO_EXT_PORTA         0x50
#define MERLIN_GPIO_LS_SYNC           0x60
#define MERLIN_GPIO_ID_CODE           0x64
#define MERLIN_GPIO_COMP_VERSION      0x6c

#define merlin_readw(reg)       ioread16(reg)
#define merlin_writew(val,reg)  iowrite16(val,reg)
#define merlin_readl(reg)       ioread32(reg)
#define merlin_writel(val,reg)  iowrite32(val,reg)
#define merlin_readb(reg)       ioread8(reg)
#define merlin_writeb(val,reg)  iowrite8(val,reg)

#endif
