/*
 * include/asm-arm/arch-falcon/io.h
 *
 *  Copyright (C) 2009 Maxim IC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_IO_H
#define __ASM_ARCH_IO_H

#include <asm/io.h>

#define IO_SPACE_LIMIT		0xFFFFFFFF

#define IO_PHYS			0x80000000
#define IO_PA_OFFSET		0x70000000
#define IO_VIRT			0xf0000000

/* macro to get at IO space when running virtually */
#define io_p2v(pa)		((pa) + IO_PA_OFFSET)
#define io_v2p(va)		((va) - IO_PA_OFFSET)

#define __io(a)			((void __iomem *)(a))
#define __mem_pci(a)		(a)


#endif
