///
///	@file 	AudioHandler.h
/// @brief 	Header for AudioHandler
//	@copy	default
//	
//	Copyright (c) Mbedthis Software LLC, 2003-2007. All Rights Reserved.
//	
//	This software is distributed under commercial and open source licenses.
//	You may use the GPL open source license described below or you may acquire 
//	a commercial license from Mbedthis Software. You agree to be fully bound 
//	by the terms of either license. Consult the LICENSE.TXT distributed with 
//	this software for full details.
//	
//	This software is open source; you can redistribute it and/or modify it 
//	under the terms of the GNU General Public License as published by the 
//	Free Software Foundation; either version 2 of the License, or (at your 
//	option) any later version. See the GNU General Public License for more 
//	details at: http://www.mbedthis.com/downloads/gplLicense.html
//	
//	This program is distributed WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
//	
//	This GPL license does NOT permit incorporating this software into 
//	proprietary programs. If you are unable to comply with the GPL, you must
//	acquire a commercial license to use this software. Commercial licenses 
//	for this software and support services are available from Mbedthis 
//	Software at http://www.mbedthis.com 
//	
//	@end
////////////////////////////////// Includes ////////////////////////////////////

#ifndef _h_AUDIO_MODULE
#define _h_AUDIO_MODULE 1

#include	"appweb/appweb.h"

/////////////////////////////// Forward Definitions ////////////////////////////

//#if BLD_FEATURE_AUDIO_MODULE
class	MaAudioModule;
class	MaAudioHandler;
class	MaAudioHandlerService;
class	MaAudioCmd;

extern "C" {
	extern int mprAudioInit(void *handle);
}

////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// AudioCmd //////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

class MaAudioCmd : public MprCmd {
  private:
	//  MprCmdFiles	  files;			  // Stdin, stdout for the command

  public:
					MaAudioCmd();
					~MaAudioCmd();
	int 			makeStdio();
};


////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// AudioModule //////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

class MaAudioModule : public MaModule {
  private:
	MaAudioHandlerService	
					*audioHandlerService;
  public:
					MaAudioModule(void *handle);
					~MaAudioModule();
};

////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// AudioHandler /////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

class MaAudioHandlerService : public MaHandlerService {
  private:
	MprLogModule	*log;
	MaAudioHandler	*AudioHandler;

  public:
					MaAudioHandlerService();
					~MaAudioHandlerService();
	MaHandler		*newHandler(MaServer *server, MaHost *host, char *ex);
};

//
//	AudioFlags
//
#define MPR_Audio_NON_PARSED_HEADER	0x1		// AUDIO program creates HTTP headers
#define MPR_Audio_HEADER_SEEN			0x2		// Server has parsed AUDIO response

class MaAudioHandler : public MaHandler {
  private:
	MprBuf			*headerBuf;
	int				audioFlags;
	//MprCmd			*cmd;
	MaAudioCmd		*cmd;
	MprLogModule	*log;
	MprStr			newLocation;

  public:
					MaAudioHandler(char *ext, MprLogModule *log);
					~MaAudioHandler();
	void			buildArgs(int *argcp, char ***argvp, MprCmd *cmd, 
						MaRequest *rq);
	int				AudioDone(MaRequest *rq, int exitCode);
	MaHandler		*cloneHandler();
	void			parseHeader(MaRequest *rq);
//	int             matchRequest(MaRequest *rq, char *uri, int uriLen);
	void			postData(MaRequest *rq, char *buf, int buflen);
	int				gatherOutputData(MaRequest *rq);
	int				run(MaRequest *rq);
	int				setup(MaRequest *rq);
#if WIN
	void			findExecutable(char **program, char **script, 
						char **bangScript, MaRequest *rq, char *fileName);
#endif
#if BLD_FEATURE_CONFIG_PARSE
	int				parseConfig(char *key, char *value, MaServer *server, 
						MaHost *host, MaAuth *auth, MaDir* dir, 
						MaLocation *location);
#endif
};

//#endif // BLD_FEATURE_AUDIO_MODULE
////////////////////////////////////////////////////////////////////////////////
#endif // _h_AUDIO_MODULE 

//
// Local variables:
// tab-width: 4
// c-basic-offset: 4
// End:
// vim: sw=4 ts=4 
//
