/*
 *  testAlias.c - Unit tests for various Aliases
 *
 *  Copyright (c) All Rights Reserved. See details at the end of the file.
 */

/********************************** Includes **********************************/

#include    "testAppweb.h"

/*********************************** Code *************************************/

static void simple(MprTestGroup *gp)
{
    assert(simpleGet(gp, "/aliasDir/test.html", 0));
    assert(simpleGet(gp, "/aliasFile/", 0));
#if BUG
    assert(simpleGet(gp, "/aliasBase.ejs", 0));
    assert(simpleGet(gp, "/aliasFromHtml.html", 0));
    assert(simpleGet(gp, "/aliasFromPhp.php", 0));
    assert(simpleGet(gp, "/aliasToHtml.ejs", 0));
#endif
}


static void script(MprTestGroup *gp)
{
#if BUG
    assert(simpleGet(gp, "/cgi-bin/cgiProgram", 0));
#endif
}


MprTestDef testAlias = {
    "alias", 0, 0, 0,
    {
        MPR_TEST(0, simple),
        MPR_TEST(0, script),
        MPR_TEST(0, 0),
    },
};


/*
 *  @copy   default
 *
 *  Copyright (c) Embedthis Software LLC, 2003-2009. All Rights Reserved.
 *  Copyright (c) Michael O'Brien, 1993-2009. All Rights Reserved.
 *
 *  This software is distributed under commercial and open source licenses.
 *  You may use the GPL open source license described below or you may acquire
 *  a commercial license from Embedthis Software. You agree to be fully bound
 *  by the terms of either license. Consult the LICENSE.TXT distributed with
 *  this software for full details.
 *
 *  This software is open source; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version. See the GNU General Public License for more
 *  details at: http://www.embedthis.com/downloads/gplLicense.html
 *
 *  This program is distributed WITHOUT ANY WARRANTY; without even the
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *  This GPL license does NOT permit incorporating this software into
 *  proprietary programs. If you are unable to comply with the GPL, you must
 *  acquire a commercial license to use this software. Commercial licenses
 *  for this software and support services are available from Embedthis
 *  Software at http://www.embedthis.com
 *
 *  @end
 */
