/*
 *	Config.es - Configuration settings from ./configure
 *
 *	NOTE: This file is generated by configure. Do NOT edit.
 *
 *	Copyright (c) Embedthis Software LLC, 2003-2009. All Rights Reserved.
 */

module ejs.sys {

	use default namespace public

	/**
	 *	Config class providing settings for various ./configure settings.
	 */
	class Config extends Object {

        use default namespace public

		/**
		 *	True if a debug build
		 */
		static const Debug: Boolean = 1


		/**
		 *	CPU type (eg. i386, ppc, arm)
		 */
		static const CPU: String = "arm"


		/**
		 *	Build with database (SQLite) support
		 */
		static const DB: Boolean = 1


		/**
		 *	Build with E4X support
		 */
		static const E4X: Boolean = 1


		/**
		 *	Build with strict ECMA compliance
		 */
		static const ECMA: Boolean = 0


		/**
		 *	Build with floating point support
		 */
		static const Floating: Boolean = 1


		/**
		 *	Build with HTTP client support 
		 */
		static const Http: Boolean = 1


		/**
		 *	Build with legacy API support
		 */
		static const Legacy: Boolean = 0


		/**
		 *	Build with multithreading support
		 */
		static const Multithread: Boolean = 0


		/**
		 *	Number type
		 */
		static const numberType: String = "double"


		/**
		 *	Operating system version. One of: WIN, LINUX, MACOSX, FREEBSD, SOLARIS
		 */
		static const OS: String = "LINUX"


		/**
		 *	Ejscript product name. Single word name.
		 */
		static const Product: String = "appweb"


		/**
		 *	Regular expression support.
		 */
		static const RegularExpressions: String = "1"


		/**
		 *	Ejscript product title. Multiword title.
		 */
		static const Title: String = "Embedthis Appweb"


		/**
		 *	Ejscript version. Multiword title. Format is Major.Minor.Patch-Build For example: 1.1.2-1
		 */
		static const Version: String = "3.0A.1-1"
	}
}

