/*
 * 2007/07/16
 * Jack.
 * very small mail client functions.
 * Include attach files , user login AUTH 
 */

#ifndef __MAIL_FUNC_H__
#define __MAIL_FUNC_H__
#include <arpa/inet.h>

#ifdef __cplusplus
extern "C" {
#endif

#define	MAIL_MSG_HELLO 	"EHLO mydomain.com\n"
#define MAIL_MSG_AUTH	"AUTH LOGIN\n"
#define	MAIL_MSG_DATA 	"DATA\n"
#define	MAIL_MSG_END	"\r\n.\r\n"
#define	MAIL_MSG_QUIT	"QUIT\n"
#define MAIL_PORT	25
#define	MAX_ATTACHFILE	10
#define MAIL_BOUNDARY	"dasfewtquiopsagfafdsg"
#define CVT "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"

struct MAILSTRUCT;
typedef int (*FUNC_SET)		( struct MAILSTRUCT*, char*, char*, char*, char*, char*);
typedef int (*FUNC_SUBCONTENT)	( struct MAILSTRUCT*, char*, char*);
typedef int (*FUNC_FILE)	( struct MAILSTRUCT*, char*, char*);
typedef int (*FUNC_SEND)	( struct MAILSTRUCT*);
typedef void (*FUNC_QUIT)	( struct MAILSTRUCT*);

struct MAILSTRUCT{
	char	username[ 32 ];
	char	password[ 32 ];
	char	mailserver[ 32 ];
	char	to[ 32 ];
	char	from[ 32 ];
	char	*subject;
	int	blogin;
	int	nfile;
	char	*filename[ MAX_ATTACHFILE ];
	char	*contentype[ MAX_ATTACHFILE ];
	char	boundary[ 64 ];
	char	*content;
  	struct	sockaddr_in 	servaddr;
	int	connfd;
	FUNC_SET	set;
	FUNC_SUBCONTENT	addsubcon;
	FUNC_FILE	addfile;
	FUNC_SEND	send;
	FUNC_QUIT	quit;
};

struct MAILSTRUCT* mailInit();

#ifdef __cplusplus
}
#endif

#endif

