#!/bin/sh

DEV=$1
DEVFILE=/dev/${DEV}

echo -ne "Mounting partition ${DEV} ... "

# Use vol_id to get the all the data about
# the new storage
ID_FS_TYPE=$(/lib/udev/vol_id ${DEVFILE} | grep ID_FS_TYPE | sed -e 's/ID_FS_TYPE=//');
ID_FS_LABEL_SAFE=$(/lib/udev/vol_id ${DEVFILE} | grep ID_FS_LABEL_SAFE | sed -e 's/ID_FS_LABEL_SAFE=//');
case ${ID_FS_TYPE} in
    "") 
        echo -ne "error: filesystem type not found\n"
        exit 1
        ;;
    "vfat") 
        FS_TYPE="vfat";
        FS_MODULES="vfat nls_cp437 nls_ascii";
        FS_OPTIONS="fmask=0000,dmask=0000,quiet";
        ;;
    *) 
        FS_TYPE=${ID_FS_TYPE};
        FS_MODULES=${FS_TYPE};
        FS_OPTIONS="";
        ;;
esac

if [ -z "${ID_FS_LABEL_SAFE}" ]; then
    FS_LABEL=${DEV};
else
    FS_LABEL=${ID_FS_LABEL_SAFE};
fi

# Mount filesystem if not listed in /proc/filesystems
if [ "X$(grep -c ${FS_TYPE} /proc/filesystems)" = "X0" ]; then
    for modname in ${FS_MODULES}; do
        /sbin/modprobe ${modname};
        if [ "X$?" != "X0" ]; then 
            echo -ne "error: unable to load ${FS_TYPE} module ${modname}\n";
            exit 2; 
        fi
    done
fi

# Check if the device is in fstab.
# If it is we mount it in the mount point specified there
if [ "X$(grep -c ${DEVFILE} /etc/fstab)" != "X0" ]; then
    /bin/mount ${DEVFILE};
    if [ "X$?" != "X0" ]; then 
        echo -ne "error: mount failed\n";
        exit 3; 
    fi
    echo -ne "done, mounted as specified in fstab\n";
    exit 0;
fi            

if [ ${FS_LABEL} == "mmcblk0p1" ];then
	MOUNT_POINT=/tmp/media/SD
	#parhandclient set Storage.Local.Type SD
else
        MOUNT_POINT=/tmp/media/USBDISK
	#parhandclient set Storage.Local.Type USBDISK       	
fi

# Otherwise mount the device in /media
# using its name and if not found its block dev name
#MOUNT_POINT=/media/${FS_LABEL}

if [ ! -d ${MOUNT_POINT} ]; then
    mkdir -p ${MOUNT_POINT};
    if [ "X$?" != "X0" ]; then 
        echo -ne "error: failed to create mountpoint ${MOUNT_POINT}\n";
        exit 4; 
    fi
fi

# can't trace case staments with -x so if/elif for now
if [ "X${ID_FS_TYPE}" == "Xjfs" ] 
then
	echo "Running jfs_fsck to verify fs integrity on ${DEVFILE}" > /dev/console
	/usr/sbin/jfs_fsck -a ${DEVFILE}
elif [ "X${ID_FS_TYPE}" == "Xext2" ] 
then
	true
	#echo "Running fsck.ext2 to verify fs integrity on ${DEVFILE}" > /dev/console
	#/usr/sbin/fsck.ext2 -p ${DEVFILE}
elif [ "X${ID_FS_TYPE}" == "Xext3" ] 
then
	true
	#echo "Running fsck.ext3 to verify fs integrity on ${DEVFILE}" > /dev/console
	#/usr/sbin/fsck.ext3 -p ${DEVFILE}
elif [ "X${ID_FS_TYPE}" == "Xxfs" ] 
then
	true
	#echo "Running fsck.xfs to verify fs integrity on ${DEVFILE}" > /dev/console
	#/usr/sbin/fsck.xfs -p ${DEVFILE}
fi

if [ "X${FS_OPTIONS}" == "X" ]
then
	mount -t ${FS_TYPE} ${DEVFILE} ${MOUNT_POINT}
else
	mount -t ${FS_TYPE} ${DEVFILE} ${MOUNT_POINT} -o ${FS_OPTIONS};
fi

if [ "X$?" != "X0" ]; then
    echo -ne "error: mount failed\n";
    exit 5; 
else
		if [ ${FS_LABEL} == "mmcblk0p1" ]
		then
		parhandclient set Storage.Local.Enable yes
		parhandclient set Storage.Local.Name ${DEVFILE}
		parhandclient set Storage.Local.Type SD
		parhandclient set Storage.Local.Status normal
		else
		parhandclient set Storage.Local.Enable yes
		parhandclient set Storage.Local.Name ${DEVFILE}
		parhandclient set Storage.Local.Type USBDISK
		parhandclient set Storage.Local.Status normal
		fi
    echo "Mount of ${DEVFILE} on ${MOUNT_POINT} complete" > /dev/console
fi

echo -ne "done, mounted as ${MOUNT_POINT}\n"
exit 0;
