#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <search.h> 	//for hash table

typedef	struct environment_s 
{
	char	name[100];
	char  value[100];
}env_t;

env_t genv[1000];
ENTRY		e,*ep;
int count=0;

int
Add_to_Hash_Table ( char *name, char * value ) {

	e.key = name;
	e.data = value;
	ep = hsearch(e, ENTER);
	/* there should be no failures */
	if (ep == NULL) {
		fprintf(stderr, "entry failed\n");
		return 0;
	}

	return 1;

}

static int Load_to_Table (const char* filename)
{
	FILE  	*fp;
	int 		n=0;
	char para1[100],*para2,*para3,c;
	
	memset(para1,0,sizeof(char)*100);
	// read data from  file into structure
	if ( (fp = fopen (filename, "r")) == NULL )
		return 0;		// can't open device

		
		while(!feof(fp)){
			c=fgetc(fp);
				if (c != 0x0a){
					para1[n]=c;
					n++;
				}
				else
					{			
				n=0;
				para3=para1;
				para2=strsep(&para3,"=");
				sprintf(genv[count].name,"%s",para2);
				sprintf(genv[count].value,"%s",para3);
				Add_to_Hash_Table ( genv[count].name, genv[count].value );
				count++;
				memset(para1,0,sizeof(char)*100);
			}
	}
		
	fclose(fp);

	return 1;
}

static int Patch_Var (const char* filename)
{
	FILE  	*fp;
	int 		n=0;
	char para1[100],*para2,*para3,c;
	
	memset(para1,0,sizeof(char)*100);
	// read data from  file into structure
	if ( (fp = fopen (filename, "r")) == NULL )
		return 0;		// can't open device
	
	while(!feof(fp)){
				c=fgetc(fp);
				if (c != 0x0a){
					para1[n]=c;
					n++;
				}
				else
					{			
						n=0;
				para3=para1;
				para2=strsep(&para3,"=");
				e.key=para2;
				ep = hsearch(e, FIND);
				
				if ( ep == NULL ) { 	// using the user's data or default value
						sprintf(genv[count].name,"%s",para2);
						sprintf(genv[count].value,"%s",para3);
						count++;
				}	
				memset(para1,0,sizeof(char)*100);
			}	
	}			
	fclose(fp);
	
	return 1;
}

int cmp (env_t *a ,env_t *b )
{

	return strcmp(a->name ,b->name);	

}


int
Write_Env_to_File ( const char* filename ) 
{
	FILE  	*fp;
	int i;
	
	qsort(genv,count,sizeof(env_t),cmp);
	if ( (fp = fopen (filename, "w")) == NULL )
		return 0;
		
		for (i=0;i<count;i++)
			fprintf(fp,"%s=%s\n",genv[i].name,genv[i].value);
	fclose(fp);		
		return 0;		// can't open device
}

int main(int argc,char *argv[])
{
	if (argc < 3 || argc > 4)
		printf("The correct format is: update_sysconf file1 file2 file3\n");
	memset(genv,0,sizeof(env_t)*1000);
	hcreate(1024);
	Load_to_Table (argv[1]);
	Patch_Var (argv[2]);
	Write_Env_to_File (argv[3]);
	hdestroy();
}
