/*========================================================================
 *	N O N - S O C K E T    F U N C T I O N S
 *========================================================================
 */
#include <stdio.h>
#include <stdlib.h> // atoi
#include <ctype.h> // isdigit
#include "perr.h"
#ifdef NO_MM
  #include <nvram.h>
#endif

/*
Nvram <err> value is used to filter out messages.
Messages which are greater than <err> will not be shown.

> [P1400] ERROR Level
- set error level of target (jpr_msg)
- 0: NO MSG
- 10: Show Errors
- 20: Show Warning
- 30: Show WIS driver msg
- 40: Show Pixord Msg
- 50: Show debug Msg
*/

int jpr_msg(int errLv, const char *fmt, ...)
{
	va_list varg;
	int retv;
#ifdef NO_MM
	int nv_err = atoi(nvram_safe_get("err"));
#else
	int nv_err = 99;  // show many messages
#endif
	
	printf("def-err=%d\n", nv_err);

	if (errLv <= nv_err) {

		if (errLv == JPR_ERROR) {
			fprintf(stderr, "\tpEERROR: ");
		}
		else if (errLv == JPR_WARNING) {
			fprintf(stderr, "\tpWARNING: ");
		}
		else if (errLv == JPR_DEBUG) {
			fprintf(stderr, "\tpDEBUG: ");
		}
	} // if (errLv <= nv_err) {

	va_start(varg, fmt);
	retv = vfprintf(stderr, fmt, varg);
	va_end(varg);

	return retv;
}

/*
concept looks like printk
*/


int jpr(const char *fmt, ...)
{
	va_list varg;
	int retv;
#ifdef NO_MM
	int nv_err = atoi(nvram_safe_get("err"));
#else
	int nv_err = 99;  // show many messages
#endif
	int errLv;
	char ch[5];
	const char *p;

	if (isdigit(fmt[0]) && isdigit(fmt[1])) {
		ch[0] = fmt[0];
		ch[1] = fmt[1];
		ch[2] = '\0';
		errLv = atoi(ch);
		p = fmt+2;
	}
	else {
		// just the same as printf
		p = fmt;
		goto endr;
	}
		
	//printf("def-err=%d, now=%d\n", nv_err, errLv); // debug

	if (errLv > nv_err) {
		return 0;
	}

	if (errLv == JPR_ERROR) {
		fprintf(stderr, "\tpEERROR: ");
	}
	else if (errLv == JPR_WARNING) {
		fprintf(stderr, "\tpWARNING: ");
	}
	else if (errLv == JPR_DEBUG) {
		fprintf(stderr, "\tpDEBUG: ");
	}

endr:
	va_start(varg, fmt);
	retv = vfprintf(stderr, p, varg);
	va_end(varg);

	return retv;
}

