
#include <stdio.h>

#ifdef KS32C50100
#include "sys_conf.h"
#include <psos.h>
#include <prepc.h>
#include <pna.h>
#include "EventsManager.h"
#include "event.h"
#include "conf.h"
#endif

#ifdef linux
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h> // for struct sockaddr_in
#include <string.h>

#include "pddns.h"
#include "jsos.h"
#include "netlib.h"
#endif

#ifdef NO_MM
  #include "nvram.h"
#endif

#if 0
#include <stdarg.h>
#include <rescfg.h>

#include "stdinc.h"
#include "net.h"
#endif




//jamesVer2.18 Add for DDNS==============================================================================
/*
	Function: evDDNSCGI_Handler(http_server_t *)				

 	http://<ServerName>/ddns?[parameter=value]&[...]

 	[PARAMETER]	[VALUE]		[DESCRIPTION]		[EXAMPLE]
 	enable		0/1		0:disable 1:enable	enable=1
 	ddnsaddr	IP		ddns server 		61.220.235.170, ddns.pixord.com(default)
 	ddnsport	0..65535	ddns server port	80 (default)
 	routerinport	0..65535	pixord NVS port		80 (default)
	updatetime	long		seconds to update	600, i.e. 10 minutes
		
The algorithm as below:

1. When user want to register NVS_NAME to remote ddns server, issue CGI
	http://ip/ddns?
		enable=1&
		ddnsaddr=ddns.pixord.com&
		ddnsport=80&
		nvsname=rd.james&
		updatetime=600
	NVS will send register packet to remote ddns server
	http://ddnsaddr:ddnsport/register.asp?
		mac=[nvsmac]&
		port=[nvshttpport]&
		name=[nvsname]
	then receive response packet to check register successful or not
	then send update packet by every [updatetime]
	http://ddnsaddr:ddnsport/update.asp?
		mac=[nvsmac]

	Then user could access NVS by [nvsname].[ddnsaddr], e.g. rd.james.ddns.pixord.com
2. To stop ddns update by issue
	http://ip/ddns?
		enable=0&
		...(don't care)

james021031								
*/
//========================================================================================================

DDNS_t	gDDNSInfo;
U32	gDDNSsmid;
U32	gDDNStid;
U32	gDDNScallertid;

	

//static const U8 *ddnsmsg[] = {
//const U8 *ddnsmsg[] = {
const char *ddnsmsg[] = {
	"cmd",
	"enable",
	"ddnsaddr",
	"ddnsport",
	"routerinport",
	"updatetime",
	"retpage"
};


//static const U8 *ddnsreplycomparemsg[]={
const U8 *ddnsreplycomparemsg[]={
	"Succeeded",
	"already registered",
	"Failed",
	"unKnown",
	"Timeout",
	"SocketErr",
	"CommandErr",
};

typedef enum {
	enddnsrepOK,
	enddnsrepAlreadyRegisted,
	enddnsrepFailed,
	enddnsLASTrep,
	enddnsrepTimeout,
	enddnsrepSockErr,
	enddnscmdErr,
	enddnsLASTEv,
} enDDNSReplyMsg;



#define	dMsgSize	1024
U8	gDDNSmsgbuf[dMsgSize];


enDDNSReplyMsg ddnssockact(DDNS_t *ddnsinfo, enDDNSCmd cmd) {
	int 	sock;
	int	i;
	
	ULONG 			rc;
	int 			ret,cnt,size;
	struct sockaddr_in 	remote_addr;
#ifdef KS32C50100
	int 			MslValue=1;		// set MSL=1, that is TIME_WAIT = 2 sec
#endif
	U8			*pmsg,*pmsgscan;
	U8			sendmsg[256];	
	ULONG 		date, time, ticks;

	sock = socket(AF_INET, SOCK_STREAM, 0);
	if (sock < 0) {
  		EvErrPrt(("ddnsact: socket() err!\n"));
  		return enddnsrepSockErr;
  	}
  	
#ifdef KS32C50100
  	ret = 	setsockopt(sock, IPPROTO_TCP, TCP_MSL, (char*) &MslValue, sizeof(int));
  	
  	if (ret) {
  		EvErrPrt(("ddnsact: setsockopt() err!\n"));
		close(sock);
  		return enddnsrepSockErr;
  	}
#endif

	memset(&remote_addr, 0, sizeof(remote_addr));

  	remote_addr.sin_family 	    = AF_INET;

	remote_addr.sin_addr.s_addr = (ddnsinfo->ddnsaddr); // for x86
#ifndef KS32C50100
	if (!inet_ntop(AF_INET, &remote_addr.sin_addr, sendmsg, sizeof(sendmsg)) )
		printf("error IP address\n");
#endif	
	printf("verify ip=%s#\n", sendmsg);

	remote_addr.sin_port 	    = htons(ddnsinfo->ddnsport);
      	      	
      	rc = connect(sock, (struct sockaddr *)&remote_addr, sizeof(remote_addr));
      	if (rc) {
		perror("socket connect error:");
      		EvErrPrt(("ddnsact: connect IP=0x%08lx, port=%ld err!\n", 
      			ddnsinfo->ddnsaddr, ddnsinfo->ddnsport));
		close(sock);
  		return enddnsrepSockErr;
      	}  	
	
	printf("connect OK\n");

	tm_get(&date, &time, &ticks);
  	
  	if (cmd==ddnsCmdRegister) {
	  	sprintf(sendmsg,"GET /register.asp?mac=%02x%02x%02x%02x%02x%02x&port=%ld&name=%s&datetime=%08lx%08lx HTTP/1.0\r\n\r\n",
	  		ddnsinfo->mac[0],ddnsinfo->mac[1],ddnsinfo->mac[2],ddnsinfo->mac[3],ddnsinfo->mac[4],ddnsinfo->mac[5],
	  		ddnsinfo->routerinport,ddnsinfo->ServerName,date,time);
	  		
	}
	else if (cmd==ddnsCmdUpdate) {
	  	sprintf(sendmsg,"GET /update.asp?mac=%02x%02x%02x%02x%02x%02x&datetime=%08lx%08lx HTTP/1.0\r\n\r\n",
	  		ddnsinfo->mac[0],ddnsinfo->mac[1],ddnsinfo->mac[2],ddnsinfo->mac[3],ddnsinfo->mac[4],ddnsinfo->mac[5],
	  		date,time);
	}
	else {
      		EvErrPrt(("ddnsact: cmd err!\n"));
		close(sock);
  		return enddnscmdErr;
      	}  	
		
  	EvPRT(("ddns msg send:ip=%lx, port=%ld, <%s>\n",ddnsinfo->ddnsaddr,ddnsinfo->ddnsport,sendmsg));
  
  	ret = send(sock, sendmsg, strlen(sendmsg), 0);
  	if (ret < 0) {
      		EvErrPrt(("ddnsact: send() err!\n"));
		close(sock);
  		return enddnsrepSockErr;
      	}

	cnt=0;
	memset(gDDNSmsgbuf,0,dMsgSize);
	pmsg=pmsgscan=gDDNSmsgbuf;
	size=dMsgSize;
	
	while (1) {
		//receive into buffer
	      	ret=recv(sock,pmsgscan,size,0);
	      	if (ret<0) {
			if (cnt++>5) {
		      		EvErrPrt(("ddnsact: 5sec timeout err!\n"));
				close(sock);
		      		return enddnsrepTimeout;
		      	}
			//tm_wkafter(100);
			continue;
		}
		if (ret==0) {	      	
	      		EvErrPrt(("ddnsact:sock err!\n"));
			close(sock);
	      		return enddnsrepSockErr;
	      	}
		printf("ret=%d, pmsg=%s#\n", ret, pmsgscan);
		printf("ret size=%d\n", ret);
	      	//got reply message, scan if match to looking string
	      	pmsgscan+=ret;
	      	size-=ret;
	      	if (size<=0) {
	      		EvErrPrt(("ddnsact:size<0 err!\n"));
			close(sock);
	      		return enddnsrepSockErr;
	      	}
			
	      	*pmsgscan=0x0;	//null end

	      	for (i=0;i<enddnsLASTrep;i++) {
      			if (strstr(pmsg,ddnsreplycomparemsg[i])) {
			  	EvPRT(("ddns receive:%s!\n",ddnsreplycomparemsg[i]));
				close(sock);
				//compare match, return compared result code
      				return (enDDNSReplyMsg) i;
      			}
	      	}
	}	      
}	


void ddnslinkinfo(DDNS_t *ddnsinfo)
#ifdef linux
{
        // Is this safe? should we use another static char string??
#ifdef NO_MM
        ddnsinfo->ServerName = nvram_safe_get("sysdesc");
#endif
	// uclinux
	if (jne_GetMAC( (char * )ddnsinfo->mac) < 0) {
		printf("ERROR: Cannot get MAC ADDRESS!!\n");
	}
}
#endif

#ifdef KS32C50100 
{
	int i;
	struct DeviceConfig *pDeviceConf;

	pDeviceConf= ConfigGetDeviceConf();
	if (!pDeviceConf) return; // jsnVer2.33 add: null pointer ERROR
		
	//set NVS name
	ddnsinfo->ServerName=pDeviceConf->DeviceName;
	for (i=0;i<6;i++) {
		ddnsinfo->mac[i]=EthernetAddress[i];
	}
}
#endif

void ddnscmdrun(void)
{
	int rc;
	t_ident(0,0,&(gDDNScallertid));
	printf("gDDNStid = %d \n", gDDNStid );
	printf("ddnsCGICmd= %d \n", ddnsCGICmd );

	if ((rc=ev_send(gDDNStid,ddnsCGICmd))) {
      		EvErrPrt(("ddnscmdrun: ev_send err:%x!\n",rc));
      	}
}	
// 2006/11/10 Ellis -->
static void ddnscmdrun_update(void)
{
	int rc;
	t_ident(0,0,&(gDDNScallertid));
	if ((rc=ev_send(gDDNStid,ddnsTimerUpdate))) {
      		EvErrPrt(("ddnscmdrun_update: ev_send err:%x!\n",rc));
      	}
}	

#ifdef OEM_BOLIDE
char gstrddnsname[]="";
#else
char gstrddnsname[]="";
#endif

void ddnsdefault(DDNS_t *pddns)
{
	ddnslinkinfo(pddns);	//fill ServerName & mac field
	pddns->enable=0x0;
	pddns->ddnsport=80;
	pddns->routerinport=_http_port();
	pddns->updatetime=60*10;
	// jsnVer2.33 modify
#if (dOEM_DYNACOLOR==1)
	strcpy(pddns->ddnsname, "ddns.iview-ddns.com");
	pddns->routerinport=700;
#else 
	strcpy(pddns->ddnsname, gstrddnsname);
	pddns->routerinport=80;  // jsnVer2_41R07 add for DynaColor Customization
#endif
}


void *ddns_task(void *arg)
{
	ULONG 			rc,ev;
	DDNS_t			*ddnsinfo;
	int			start=0;
	ULONG			timerid,evsnd;

	if ((rc=sm_create ("ddsm", 1, SM_LOCAL | SM_FIFO, &gDDNSsmid))) {
		EvPRT(("ddns_task sm_create fail:%lX\n",rc));
	}
	ddnsinfo=&gDDNSInfo;
	while (1) {
		if ((rc=ev_receive(DDNSTaskEvMask,EV_WAIT|EV_ANY, 0, &ev))) {
			EvPRT(("ddns_task ev_receive fail:%lX\n",rc));
		}
		if (ev&ddnsCGICmd) {
			evsnd=CGISuccess;
			if (start) {
				if (timerid) {
					tm_cancel(timerid);
					timerid=dEvNull;
					start=0;
				}
			}
			if (ddnsinfo->enable) {
				if ((rc=ddnssockact(ddnsinfo,ddnsCmdRegister))==dEvOK) {
					if ((ddnsinfo->updatetime)>0) {
						if ((rc=tm_evevery((ddnsinfo->updatetime)*100,ddnsTimerUpdate,&timerid))) {
							EvPRT(("ddns_task tm_evafter fail:%lX\n",rc));
						}
					}
				}
				else {
					evsnd=0x01<<rc;
				}
				start=1;
			}
#ifdef KS32C50100 
			if ((rc=ev_send(gDDNScallertid,evsnd))) {
#endif
#ifdef linux
			if ((rc=ev_psnd(gDDNScallertid,evsnd))) {
#endif
				EvPRT(("ddns_task ev_send fail:%lX\n",rc));
			}
		}
		else if (ev&ddnsTimerUpdate) {
			if ((ddnsinfo->enable)&&(start)) {
				if (ddnssockact(ddnsinfo,ddnsCmdUpdate)) {
					EvPRT(("ddns_task upd fail\n"));
				}
			}
		}
		else if (ev&ddnsTaskFree) {
			if (timerid) {
				tm_cancel(timerid);
				timerid=dEvNull;
			}
			break;
		}
	} //while(1)

	printf("Warning: END of TASK %s, ev=0x%04lX\n", __FUNCTION__, ev);
#ifdef linux

#endif
	evTDelete();

	return arg;
}			

#ifdef NO_MM
#define DDNSEvMask	((0x01<<enddnsrepOK)|(0x01<<enddnsrepAlreadyRegisted)| (0x01<<enddnsrepFailed)|	(0x01<<enddnsrepTimeout)|(0x01<<enddnsrepSockErr)|(0x01<<enddnscmdErr))
#else
#define DDNSEvMask	((0x01<<enddnsrepOK)| \
			(0x01<<enddnsrepAlreadyRegisted)| \
			(0x01<<enddnsrepFailed)|\
			(0x01<<enddnsrepTimeout)|\
			(0x01<<enddnsrepSockErr)|\
			(0x01<<enddnscmdErr))
#endif // NO_MM

int ddns_evsnd(char *response) {
	unsigned long evrec=0;
	unsigned long rc;

	int i;

	ddnscmdrun();
#ifdef KS32C50100
	if (rc=ev_receive(DDNSEvMask,EV_WAIT|EV_ANY, 1000, &evrec)) {
#endif
#ifdef linux
#ifdef NO_MM
	if ((rc=ev_pwait(DDNSEvMask,EV_WAIT|EV_ANY, 0, &evrec))) {
#else
	if ((rc=ev_pwait(DDNSEvMask,EV_WAIT|EV_ANY, 500, &evrec))) {
#endif
#endif
      		EvErrPrt(("ddnscgi ev_receive err:%lX!\n",rc));
      		strcat(response,ddnsreplycomparemsg[enddnsrepTimeout]);
	}
	else {
		for (i=0;i<enddnsLASTEv;i++) {
			if (evrec&(1<<i)) {
				strcat(response,ddnsreplycomparemsg[i]);
				break;
			}
		} // END for
	}

	return 0;

#if 0
	ev_send(tid, arg1);

	// wait for reply
	printf("Main Task waiting...\n");
	wait_ev = (arg2) ? atoi(arg2) : 0x0011;
	ev_pwait(wait_ev, 0, timeout, &evrec);

	return 0;
#endif
}


int ddns_evsnd_update(void) {
	ddnscmdrun_update();
	return 0;
}

static const U8 *ddnscgimsgresult[] = {
	"Succeeded",
	"CGI fail\n",
};


int ddns_temp(char *response, int err, int cgiSET, int cgiGET, enDDNScgi enEntry)
{
	char 	*defddnsname=gstrddnsname;
	U16 	defddnsport=80;
	U16	defrouterinport=_http_port();
	int	defupdatetime=60*10;  ///10 minutes per update
	
	if ((err==dEvNull)&&(cgiSET)&&(gDDNSInfo.enable)) {
		if (((enEntry)&(1<<enddnsaddr))==dEvNull) {
			if ((*(gDDNSInfo.ddnsname))==dEvNull) {
#ifdef KS32C50100
				if (((gDDNSInfo.ddnsaddr)=GetIpaddr_fromStr(defddnsname, 0))==dEvNull) err=enddnsaddr+1;
#endif
				strcpy(gDDNSInfo.ddnsname,defddnsname);
			}
		}
		if (((enEntry)&(1<<enddnsport))==dEvNull) {
			if (gDDNSInfo.ddnsport==dEvNull) {
				gDDNSInfo.ddnsport=defddnsport;
			}
		}
		if (((enEntry)&(1<<enrouterinport))==dEvNull) {
			if (gDDNSInfo.routerinport==dEvNull) {
				gDDNSInfo.routerinport=defrouterinport;
			}
		}
		if (((enEntry)&(1<<enupdatetime))==dEvNull) {
			if (gDDNSInfo.updatetime==dEvNull) {
				gDDNSInfo.updatetime=defupdatetime;
			}
		}
	}
	response[0]=0x0;
	
	ddnslinkinfo(&gDDNSInfo);
	if (cgiSET) {

		if (err==dEvNull) {
			unsigned long tid, rc;
			
		        t_create("ddns", 0, 0, 0, 0, &tid);
		        t_start(tid, 0, ddns_task, 0);

			ddns_evsnd(response);

			//sleep(1); // debug only
			if ((rc=ev_send(gDDNStid,ddnsTaskFree))) {
		      		EvErrPrt(("ddnscmdrun: ev_send err:%lx!\n",rc));
		      	}

			// terminate ddns task
			t_delete(tid);
		}
		else {	
			//parameter err
			strcat(response, ddnsmsg[err-1]);
			strcat(response, ddnscgimsgresult[1]);
		}
		strcat(response,"\r\n\r\n");
	}
	else if (cgiGET) {
		sprintf(response,"%s=%d\n%s=%s\n%s=%ld\n%s=%ld\n%s=%d\r\n\r\n",
			ddnsmsg[enenable],gDDNSInfo.enable,
			ddnsmsg[enddnsaddr],gDDNSInfo.ddnsname,
			ddnsmsg[enddnsport],gDDNSInfo.ddnsport,
			ddnsmsg[enrouterinport],gDDNSInfo.routerinport,
			ddnsmsg[enupdatetime],gDDNSInfo.updatetime);
	}
	else 	
		sprintf(response,"DDNS cmd unreconized\r\n\r\n");

	return 0;

}

