/*
 *  Create by Jason@pixord, September 14, 2005
 *
 * Note:
 * 	1. jsn, 2005 Nov
 *		As a library module, this should not include or depend on too many other modules.
 *		so I rewrite it NOT to use <nvram_ramset>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <unistd.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <assert.h>
#include <sys/ioctl.h>

#include "netlib.h"
#include "netdb.h" // 2006/11/10 Ellis



// jason@pixord, 2005/9/14
#ifndef INTEL_IXP
  #define DNS_FNAME	"/var/www/resolv.conf"
#else
  #define DNS_FNAME	"/etc/resolv.conf"
#endif 

// jsn add, 2007 June
int Parse_dns(/* out */char *dns1, char *dns2, char *dns3, const char *all_dns)
{
	const char *p=all_dns;
	char *dst;
//	int i=0; // number of DNS servers.
	
	printf("%s.........................all dns=%s\n", __FUNCTION__, all_dns);

// future improvement
#if 0
	while (*p) {
		p += strspn(p, " \t" );
		dst = dns[i];
		while (*p && !isspace(*p))	*dst++ = *p++;
		
		*dst = '\0';
		i++;
		printf("%s.........................dns1=%s\n", __FUNCTION__, dns1);
		printf("%s.........................p=%s\n", __FUNCTION__, p);	
	} // END while
#endif

	p += strspn(p, " \t" );
	dst = dns1;
	while (*p && !isspace(*p)) {
		*dst++ = *p++;
	} // END while
	*dst = '\0';
//	printf("%s.........................dns1=%s\n", __FUNCTION__, dns1);
//	printf("%s.........................p=%s\n", __FUNCTION__, p);

	p += strspn(p, " \t" );
	dst = dns2;
	while (*p && !isspace(*p)) {
		*dst++ = *p++;
	} // END while
	*dst = '\0';
//	printf("%s.........................dns2=%s\n", __FUNCTION__, dns2);
//	printf("%s.........................p=%s\n", __FUNCTION__, p);

	p += strspn(p, " \t" );
	dst = dns3;
	while (*p && !isspace(*p)) {
		*dst++ = *p++;
	} // END while
	*dst = '\0';
//	printf("%s.........................dns3=%s\n", __FUNCTION__, dns3);
//	printf("%s.........................p=%s\n", __FUNCTION__, p);

	return 0;
}

// set DNS by NULL-terminated strings
int js_SetDNS(const char *dns1, const char *dns2, const char *dns3)
{
	char eth_dns1[20], eth_dns2[20], eth_dns3[20];
	FILE *f;

	//printf("\njsn.dns.0447, size=%d\n", sizeof(eth_dns1));
	//printf("DNS1=%s#\n", dns1);

	memset(eth_dns1, '\0', sizeof(eth_dns1));
	memset(eth_dns2, '\0', sizeof(eth_dns2));
	memset(eth_dns3, '\0', sizeof(eth_dns3));

	strncpy(eth_dns1, dns1, sizeof(eth_dns1));
	strncpy(eth_dns2, dns2, sizeof(eth_dns2));
	strncpy(eth_dns3, dns3, sizeof(eth_dns3));
 

	f = fopen(DNS_FNAME, "w+");
	if (f == NULL) {
		printf("\nERROR on open file %s\n", DNS_FNAME);
		return -1;
	}
	if (strlen(eth_dns1) >= 7)	// if DNS ipaddr len is no less than strlen(1.1.1.1)
	    fprintf(f, "nameserver %s\n", eth_dns1);
	if (strlen(eth_dns2) >= 7)
	    fprintf(f, "nameserver %s\n", eth_dns2);
	if (strlen(eth_dns3) >= 7)
	    fprintf(f, "nameserver %s\n", eth_dns3);
	if (strlen(eth_dns1) < 7 && strlen(eth_dns2) < 7 && strlen(eth_dns3) < 7)
	    fprintf(f, "nameserver %s", "168.95.1.1\n");

	fclose(f);
 
	return 0; // success
	
	
}


// helper function to convert IP Address from LONG to STRING
char *jsnet_ntoa(char *str, ULONG ip)
{
	struct in_addr addr;

	addr.s_addr = ntohl(ip);
	
	// DO NOT exceed the length of the output string
	strcpy(str, inet_ntoa(addr));

	// REMEMBER to handle error condition of <inet_ntoa>

	return str;
}

#define MAXLEN_NetAddr		20
static char StaticNetAddr[MAXLEN_NetAddr];
// use static memory
// helper function to convert IP Address from LONG to STRING
char *jne_ntoa(ULONG ip)
{
	struct in_addr addr;
	char *str = StaticNetAddr;
//printf("%s..................%08lX\n", __FUNCTION__, ip);
// 2006/09/21 Ellis, fix bug -->
#ifdef NO_MM
	addr.s_addr = ip;
#else
// <-- Ellis
	addr.s_addr = ntohl(ip);
#endif	
	// DO NOT exceed the length of the output string
	strncpy(str, inet_ntoa(addr), MAXLEN_NetAddr);

	// REMEMBER to handle error condition of <inet_ntoa>

	return str;
}

ULONG jne_aton(char *str)
{
	struct in_addr addr;

	return inet_aton(str, &addr) ? addr.s_addr : 0;
}
// 2006/11/10 Ellis -->
char *px_nslookup(char *str)
{
	struct hostent *hp;
	struct in_addr in;
	struct sockaddr_in local_addr;

	if (!str) goto error;
	if (!(hp = gethostbyname(str))) goto error;
	
	memcpy(&local_addr.sin_addr.s_addr, hp->h_addr, 4);
	in.s_addr = local_addr.sin_addr.s_addr;
	return jne_ntoa(in.s_addr);

error:
	return "0.0.0.0";
}
ULONG px_nslookup_n(char *str)
{
	struct hostent *hp;
	struct in_addr in;
	struct sockaddr_in local_addr;

	if (!str) goto error;
	if (!(hp = gethostbyname(str))) goto error;
	
	memcpy(&local_addr.sin_addr.s_addr, hp->h_addr, 4);
	in.s_addr = local_addr.sin_addr.s_addr;
	return (in.s_addr);

error:
	return 0;
}
// <-- Ellis
#if 0
// set DNS by 4-byte IP address
int js_SetDNS_byIP(ULONG dns1, ULONG dns2, ULONG dns3)
{
	struct in_addr addr1, addr2, addr3;
	char str1[20], str2[20], str3[20];

	addr1.s_addr = ntohl(dns1);
	addr2.s_addr = ntohl(dns2);
	addr3.s_addr = ntohl(dns3);

	strcpy(str1, inet_ntoa(addr1));
	strcpy(str2, inet_ntoa(addr2));
	strcpy(str3, inet_ntoa(addr3));


	nvram_ramset("eth_dns1", str1);
	nvram_ramset("eth_dns2", str2);
	nvram_ramset("eth_dns3", str3);
	
	return js_SetDNS(str1, str2, str3);
	 
}
#endif

// 2006/02/24 Ellis -->
#if defined(WIRELESS_IF_BR0)
  #define IF0_NAME	"br0"
//#ifdef INTEL_IXP
#elif defined(INTEL_IXP)
// <-- Ellis
  #define IF0_NAME	"ixp0"
#else
  #define IF0_NAME	"eth0"
#endif

unsigned long jne_GetIP(void)
{
	int skfd;
	unsigned long ip_addr;
	struct ifreq ifr;
	struct sockaddr_in *saddr;

	// create a socket
	skfd = socket(AF_INET, SOCK_DGRAM, 0);
	if (skfd < 0) {
		perror("Error open socket");
		return 0; // error
	}

	strcpy(ifr.ifr_name, IF0_NAME);
	// Get IP Address
	if (ioctl(skfd, SIOCGIFADDR, &ifr) < 0) {
		perror("Error ioctl(SIOCGIFADDR)");
		close(skfd);
		return 0;
	}
	
	saddr = (struct sockaddr_in *) &ifr.ifr_addr;
	ip_addr = (saddr->sin_addr).s_addr;

	close(skfd);
	return ntohl(ip_addr);
}


unsigned long jne_Get_ethIP(const char *ifname)
{
	int skfd;
	unsigned long ip_addr;
	struct ifreq ifr;
	struct sockaddr_in *saddr;

	// create a socket
	skfd = socket(AF_INET, SOCK_DGRAM, 0);
	if (skfd < 0) {
		perror("Error open socket");
		return 0; // error
	}

	strcpy(ifr.ifr_name, ifname);
	// Get IP Address
	if (ioctl(skfd, SIOCGIFADDR, &ifr) < 0) {
		perror("Error ioctl(SIOCGIFADDR)");
		close(skfd);
		return 0;
	}
	
	saddr = (struct sockaddr_in *) &ifr.ifr_addr;
	ip_addr = (saddr->sin_addr).s_addr;

	close(skfd);
#ifdef NO_MM
	return ip_addr;
#else
	return ntohl(ip_addr);
#endif
}


unsigned long jne_Get_ethNetMask(const char *ifname)
{
	int skfd;
	unsigned long ip_addr;
	struct ifreq ifr;
	struct sockaddr_in *saddr;

	// create a socket
	skfd = socket(AF_INET, SOCK_DGRAM, 0);
	if (skfd < 0) {
		perror("Error open socket");
		return 0; // error
	}

	strcpy(ifr.ifr_name, ifname);
	// Get IP Address
	if (ioctl(skfd, SIOCGIFNETMASK, &ifr) < 0) {
		perror("Error ioctl(SIOCGIFADDR)");
		close(skfd);
		return 0;
	}
	
	saddr = (struct sockaddr_in *) &ifr.ifr_addr;
	ip_addr = (saddr->sin_addr).s_addr;

	close(skfd);
#ifdef NO_MM
	return ip_addr;
#else
	return ntohl(ip_addr);
#endif
}


// 2006/9/24 Jason -->

ssize_t readn(int fd, void *vptr, size_t n)
{
	size_t	nleft;
	ssize_t	nread;
	char	*ptr;

	ptr = (char*)vptr;
	nleft = n;
	while (nleft > 0) {
		if ( (nread = read(fd, ptr, nleft)) < 0) {
			if (errno == EINTR)
				nread = 0;		/* and call read() again */
			else
				return(-1);
		} else if (nread == 0)
			break;				/* EOF */

		nleft -= nread;
		ptr   += nread;
	}
	return(n - nleft);		/* return >= 0 */
}


ssize_t writen(int fd, const void *vptr, size_t n)
{
	size_t		nleft;
	ssize_t		nwritten;
	const char	*ptr;

	ptr = (char*)vptr;
	nleft = n;
	while (nleft > 0) {
		if ( (nwritten = write(fd, ptr, nleft)) <= 0) {
			if (nwritten < 0 && errno == EINTR)
				nwritten = 0;		/* and call write() again */
			else
				return(-1);			/* error */
		}

		nleft -= nwritten;
		ptr   += nwritten;
	}
	return(n);
}



/*
 * Network interface prober
 *
 * Probe for existence of device, return hw address in hwaddr
 * if the device exists. 
 * 
 * Return:     0 - device exists, hwaddr, if present valid.
 *           < 0 - device does not exist.
 *
 * Original source: WIS/ipcam.c
 *
 */
int if_probe(const char* name, char hwaddr[6])
{
    int i, fd;
    struct ifreq ifr;

    if (( fd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) { 
	//printf("if_probe: error opening netlink socket\n");
	return -1;
    }

    memset(&ifr, 0, sizeof(ifr));
    strcpy(ifr.ifr_name, name);

    if (ioctl(fd, SIOCGIFHWADDR, &ifr) == -1) {
	//printf("There is no MACADDR for %s\n", name);
	close (fd);
	return -1;
    }
    close (fd);

    for (i = 0; i < IFHWADDRLEN; i++)
	hwaddr[i] = (unsigned char) ifr.ifr_ifru.ifru_hwaddr.sa_data[i];

    return 0;
}


/*
 * reference: 
 *	if_probe(char* name, char hwaddr[6])
 *	from ipcam.c
 */
int  jne_GetMAC(char *hwaddr)
{
	return if_probe(IF0_NAME, hwaddr);
}
// <-- Jason

/*========================================================================
 *	N O N - S O C K E T    F U N C T I O N S
 *========================================================================
 */

#include "perr.h"

#if 0
int jpr_msg(int errLv, const char *fmt, ...)
{
	va_list varg;
	int retv;
	
	//printf("def-err=%d\n", atoi(nvram_safe_get("err")));

	if (errLv == JPR_ERROR) {
		fprintf(stderr, "pEERROR: ");
	}
	else if (errLv == JPR_WARNING) {
		fprintf(stderr, "pWARNING: ");
	}
	else if (errLv == JPR_DEBUG) {
		fprintf(stderr, "pDEBUG: ");
	}

	va_start(varg, fmt);
	retv = vfprintf(stderr, fmt, varg);
	va_end(varg);

	return retv;
}

#endif



// jsn, 2005/11/21
// to solve wireless reset issue
// from Sean's suggestion	
int wlan_pcheck(void)
{	
	int bNoCable, bEth1; // bWL;

	//getbenv("wl_ifname");

	// ask Sean how the message is
	bNoCable = !system("dmesg|grep -qi \"no cable\"");
	printf("no cable = %d\n", bNoCable);

	bEth1 = !system("dmesg|grep -qi eth1");
	printf("eth1 = %d\n", bEth1);

	// how about getbenv()??
	//bWL = atoi(nvram_safe_get("wl_enable"));
	//printf("wl_enable = %d\n", bWL);

	if (bNoCable && bEth1) {
		printf("task -d eth0");
		system("task -d eth0");
	}

	return 0;
}


#define HWP_WLAN_EXIST	0x01
struct HwProbe_t {
	int hwp_bit;
} HwConf;


#define WRITE_TEXT	0
#define WRITE_RECORD	1

//int jcf_keepval(const char *name, const char *value)
int jcf_keepval(const char *name, int value)
{
	FILE *fp;
	int rc;

#if WRITE_TEXT
	fp = fopen("/var/jcfvar", "a+");
#endif
#if WRITE_RECORD
	fp = fopen("/var/jcfvar", "w+");
#endif
	if (fp == NULL) {
		//perror("Error open file");
                printf("Error open file <%s>: %s\n", "/var/jcfvar", strerror(errno));
		return -1;
	}

	//if (name == HWP_WLAN_EXIST) {
	if (!strcmp(name, "wlan_probe")) {
		HwConf.hwp_bit = value ? 0x41 : 0x42;
	}

#if WRITE_TEXT
	// improve: append this item only if the entry not found, 
	fprintf(fp, "%s=%s\n", name, value);
#endif
#if WRITE_RECORD
	rc = fwrite(&HwConf, sizeof(struct HwProbe_t), 1, fp);
	if (rc < 1) {
		perror("Error on fwrite!");
		fclose(fp);
		return -1;
	}
#endif
	
	fclose(fp);

	return 0;
}

//#ifndef INTEL_IXP
#include "wconfigs.h"
//#endif

static char Jcf_String[32];

//int jcf_getval(const char *name, int *value)
char *jcf_getval(const char *name)
{
	FILE *fp;
	char *p = Jcf_String;
	int rc;

	fp = fopen("/var/jcfvar", "r+");
	if (fp == NULL) {
                printf("Error open file <%s>: %s\n", "jcfvar", strerror(errno));
		return NULL;
	}

	rc = fread(&HwConf, sizeof(struct HwProbe_t), 1, fp);
	if (rc < 1) {
		perror("Error on fread!");
		p = NULL;
		goto err;
	}

	// which is better?? 1. get this value when system boot by other process.
	// 2. get this value by call if_probe any time?
	if (!strcmp(name, "wlan_probe")) {
		if (HwConf.hwp_bit & HWP_WLAN_EXIST)
			sprintf(p, "%d", 1);
		else
			sprintf(p, "%d", 0);
	}
#ifdef NO_MM 
	else if (!strcmp(name, "fm_version")) {
		sprintf(p, "%d.%02d%s", WBC_VERSION_MAJOR, WBC_VERSION_MINOR, WBC_VERSION_SUFFIX);
	}
#endif
	else {
		// input <name> not found
		//printf("ssi name<%s> not found!\n", name);
		p = NULL;
	}
	//printf("jsn:ver=%s#\n", p);

err:
	fclose(fp);
	return p;
	
}


// jason, 2007 June, move here from ipinst.c to be shared with WIS httpd/Up.c
#define MAXLEN_ETHERMAC		6
#define SEPARATOR_COLON		':'

// can only contain 4 digits at maximum
#define MAXLEN_SHORTSTR		3


static int GetMacPos(const char *str, int pos)
{
	int p=0; // index of <str>
	int i=0; // the i-th byte

	// find the head-ptr of byte-n
	while (str[p]) {
		if (i >= pos) break;
		if (str[p] == SEPARATOR_COLON) {
			i++;
		}
		p++;
	} // End while

	if (i >= MAXLEN_ETHERMAC) return -1; //ERROR

	return p;
}

int MAC_Byte(char *hwaddr, int iByte)
{
	int val;
	int p, q; // index to the string <hwaddr> 
	char ch;

	// find the starting index of byte-n
	q = p = GetMacPos(hwaddr, iByte);
	if (p < 0) return -1; // ERROR

	// find the ending index of byte-n
	while ((ch = hwaddr[q]) != '\0') {
		if (ch == SEPARATOR_COLON) break;
		q++;
	}
	
	// now <q> points to either a colon or NULL.
	hwaddr[q] = '\0';
	//printf("DEBUG: M=%s#\n", hwaddr+p);
	val = strtoull(hwaddr+p, NULL, 16);
	hwaddr[q] = ch; //  restore the original char to overwrite NULL CHAR which we added for previous string processing
	return val;
}

#if 0
static int Set_NetMask(int skfd, ULONG netmask)
{
	struct ifreq ifr;
	struct sockaddr_in *saddr;
	struct in_addr addr;
	
	if (skfd < 0) {
		perror("ERROR Socket");
		return -1;
	}
	
	// Get IP Address and initialize struct <ifr>
	strcpy(ifr.ifr_name, IF0_NAME);
	if (ioctl(skfd, SIOCGIFNETMASK, &ifr) < 0) {
		perror("> > > ERROR SIOCGIFADDR");
		return -1;
	}
	
	saddr = (struct sockaddr_in *) &ifr.ifr_addr;
	if ((saddr->sin_addr).s_addr == netmask) {
		// if new IP address is the same as the original one, then do nothing and return.
		return 0;
	}
	
	// Set subnet mask, NOTE that netmask is related to IP address
	(saddr->sin_addr).s_addr = netmask;
	if (ioctl(skfd, SIOCSIFNETMASK, &ifr) < 0) {
		perror("ERROR SIOCSIFNETMASK");
		return -1;
	}
	
	nvram_ramval("eth_netmask", netmask, VTYPE_IP);

	return 0; // success
}

int Set_IPAddr(ULONG new_ip, ULONG netmask)
{
	struct ifreq ifr;
	int skfd;
	struct sockaddr_in *saddr;
	struct in_addr addr;
	
	//printf("New IP addr = %s, 0x%08X\n", inet_ntoa(new_ip), new_ip);
	
	// create socket
	skfd = socket(AF_INET, SOCK_DGRAM, 0);
	if (skfd < 0) {
		perror("ERROR Create Socket");
		return -1;
	}
	
	// Get IP Address and initialize struct <ifr>
	strcpy(ifr.ifr_name, IF0_NAME);
	if (ioctl(skfd, SIOCGIFADDR, &ifr) < 0) {
		perror("> > > ERROR SIOCGIFADDR");
		goto err_label;
	}

	Set_NetMask(skfd, netmask);
	
	saddr = (struct sockaddr_in *) &ifr.ifr_addr;
	if ((saddr->sin_addr).s_addr == new_ip) {
		// if new IP address is the same as the original one, then do nothing and return.
		return 0;
	}
	
	// Set New IP address
	//(saddr->sin_addr).s_addr = ntohl(new_ip);
	(saddr->sin_addr).s_addr = new_ip;
	if (ioctl(skfd, SIOCSIFADDR, &ifr) < 0) {
		perror("ERROR SIOCSIFADDR");
		goto err_label;
	}

	// Set subnet mask, NOTE that netmask is related to IP address
	(saddr->sin_addr).s_addr = netmask;
	if (ioctl(skfd, SIOCSIFNETMASK, &ifr) < 0) {
		perror("ERROR SIOCSIFNETMASK");
		goto err_label;
	}
	
	
	// To solve "Network is unreachable", the bootloader variable "ipaddr" should be the same as "ifconfig eth0"
	// use console command "printbenv" to test
	//printf("newip=%s", inet_ntoa(new_ip));
	//nvram_ramset("eth_ipaddr", inet_ntoa(new_ip));  // this cause warning while compiling, Hint: use struct in_addr
	//addr.s_addr = netmask;
	//nvram_ramset("eth_netmask", inet_ntoa(addr));
	nvram_ramval("eth_netmask", netmask, VTYPE_IP);

	//addr.s_addr = new_ip;
	//nvram_ramset("eth_ipaddr", inet_ntoa(addr));
	nvram_ramval("eth_ipaddr", new_ip, VTYPE_IP);
	// <ipaddr> is only for bootloader.
	// this can be omitted, but for integrity, we still modify its value
	//nvram_ramset("ipaddr", inet_ntoa(addr));
	nvram_ramval("ipaddr", new_ip, VTYPE_IP);
	
	//system("reset");
	
	// close socket
	close(skfd);
	return 0; // success

err_label:
	close(skfd);
	return -1;	
}

#endif
