
#ifndef _PDDNS__H_
#define _PDDNS__H_

#ifdef linux
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <arpa/inet.h>
  #include "ixp_porting.h"
  #include "jsos.h"
  #include "netlib.h"
#endif

//jamesVer2.18 add DDNS---------------------------------
typedef struct {
	int 		chksum;
	char		enable;
	ULONG 		ddnsaddr;	//IP of ddns server
	char		ddnsname[MIN_NUM];
	ULONG 		ddnsport;	//Port of ddns server
	char 		*ServerName;	//Server Name which used for register
	ULONG 		routerinport;	//Router incoming port
	unsigned char		mac[6];		//mac address of NVS
	int		updatetime;
} DDNS_t;

//jsn: if not declare <mac> to unsigned, 0xf1 will be 0xfffffff1 when printf.

typedef enum {
	ddnsCGICmd		=0x01,
	ddnsTimerUpdate		=0x02,
	ddnsTaskFree		=0x04
} DDNSTaskEvent;

typedef enum {
	ddnsCmdRegister,
	ddnsCmdUpdate,
} enDDNSCmd;

#define DDNSTaskEvMask	(ddnsCGICmd|ddnsTimerUpdate|ddnsTaskFree)


typedef enum {
	CGISuccess=0x01,
	CGIFail=0x02,
} DDNSCGIResult;

#define DDNSCGIMask	(CGISuccess|CGIFail)

typedef enum {
	encmd,
	enenable,
	enddnsaddr,	//IP of ddns server
	enddnsport,	//Port of ddns server
	enrouterinport,	//Router incoming port
	enupdatetime,
	enReturnPage,
	enlastDNSCGIEntry
} enDDNScgi;	

extern DDNS_t	gDDNSInfo;
extern ULONG	gDDNSsmid;
extern ULONG	gDDNStid;
extern ULONG	gDDNScallertid;


// function prototypes
extern void *ddns_task(void *);
extern void ddnsdefault(DDNS_t *pddns);
extern int ddns_evsnd(char *response);

extern USHORT _http_port(void);



#endif // _PDDNS__H_
